/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.references;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.KubernetesUtilKt;
import com.intellij.kubernetes.MiscUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.references.InClusterElement;
import com.intellij.kubernetes.references.KubernetesMapResourceEntryReference;
import com.intellij.kubernetes.references.KubernetesMapResourceEntryRenameHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J/\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J0\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0016J2\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010!\u001a\u00020\"\u00a8\u0006#"}, d2={"Lcom/intellij/kubernetes/references/KubernetesMapResourceEntryRenameHandler;", "Lcom/intellij/refactoring/rename/RenameHandler;", "()V", "findUsages", "", "Lcom/intellij/usageView/UsageInfo;", "scope", "Lcom/intellij/psi/search/SearchScope;", "resolver", "Lcom/intellij/kubernetes/KubernetesResolver;", "ref", "Lcom/intellij/kubernetes/references/KubernetesMapResourceEntryReference;", "getKubernetesMapResourceEntryReference", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isAvailableOnDataContext", "", "rename", "targets", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "usages", "newName", "", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesMapResourceEntryRenameHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesMapResourceEntryRenameHandler.kt\ncom/intellij/kubernetes/references/KubernetesMapResourceEntryRenameHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n766#2:153\n857#2,2:154\n1549#2:156\n1620#2,3:157\n1855#2,2:160\n1855#2,2:162\n*S KotlinDebug\n*F\n+ 1 KubernetesMapResourceEntryRenameHandler.kt\ncom/intellij/kubernetes/references/KubernetesMapResourceEntryRenameHandler\n*L\n48#1:153\n48#1:154,2\n140#1:156\n140#1:157,3\n121#1:160,2\n127#1:162,2\n*E\n"})
public final class KubernetesMapResourceEntryRenameHandler
implements RenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return this.getKubernetesMapResourceEntryReference(dataContext) != null;
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project2, @Nullable Editor editor, @Nullable PsiFile file2, @Nullable DataContext dataContext) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (dataContext == null) {
            return;
        }
        KubernetesMapResourceEntryReference kubernetesMapResourceEntryReference = this.getKubernetesMapResourceEntryReference(dataContext);
        if (kubernetesMapResourceEntryReference == null) {
            return;
        }
        KubernetesMapResourceEntryReference ref = kubernetesMapResourceEntryReference;
        Collection<PsiElement> targets = MiscUtilKt.resolveToPsi((PsiReference)ref);
        Iterable $this$filter$iv = targets;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof InClusterElement))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inSourceTargets = (List)destination$iv$iv;
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull((Iterable)targets);
        if (psiElement == null) {
            return;
        }
        PsiElement mainTarget = psiElement;
        RenameDialog dialog2 = new RenameDialog(project2, mainTarget, editor, ref, targets, inSourceTargets, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ KubernetesMapResourceEntryReference $ref;
            final /* synthetic */ Collection<PsiElement> $targets;
            final /* synthetic */ List<PsiElement> $inSourceTargets;
            final /* synthetic */ KubernetesMapResourceEntryRenameHandler this$0;
            {
                this.$project = $project;
                this.$ref = $ref;
                this.$targets = $targets;
                this.$inSourceTargets = $inSourceTargets;
                this.this$0 = $receiver;
                super($project, $mainTarget, null, $editor);
            }

            protected void canRun() {
                super.canRun();
                String string = this.getNewName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
                if (!KubernetesUtilKt.isMapResourceEntryNameValid(string)) {
                    throw new ConfigurationException(KubernetesBundle.message("KubernetesMapResourceEntryRenameHandler.invalid.name.error", new Object[0]));
                }
            }

            protected boolean areButtonsValid() {
                return true;
            }

            protected boolean isToSearchForTextOccurrencesForRename() {
                return false;
            }

            protected boolean isToSearchInCommentsForRename() {
                return false;
            }

            @NotNull
            protected String getFullName() {
                return this.$ref.getTargetInfo().getResourceInfo().getKind() + " entry \"" + this.$ref.getTargetInfo().getKey() + "\"";
            }

            /*
             * WARNING - void declaration
             */
            protected void createCheckboxes(@Nullable JPanel panel2, @Nullable GridBagConstraints gbConstraints) {
                block1: {
                    super.createCheckboxes(panel2, gbConstraints);
                    this.getCbSearchInComments().setVisible(false);
                    if (this.$targets.size() == this.$inSourceTargets.size()) break block1;
                    JPanel jPanel = panel2;
                    if (jPanel != null) {
                        void it;
                        JBLabel jBLabel;
                        JBLabel jBLabel2 = jBLabel = new JBLabel(KubernetesBundle.message("KubernetesResourceRenameHandler.unable.noInClusterRenames.warning", new Object[0]));
                        JPanel jPanel2 = jPanel;
                        boolean bl = false;
                        it.setForeground((Color)new JBColor(new Color(127, 127, 0), new Color(127, 127, 0)));
                        jPanel2.add((Component)jBLabel, gbConstraints);
                    }
                }
            }

            public void performRename(@NotNull String newName) {
                Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
                this.invokeRefactoring(new BaseRefactoringProcessor(this.$project, this.$inSourceTargets, this.$ref, this.this$0, this, newName){
                    @NotNull
                    private final KubernetesResolver resolver;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ List<PsiElement> $inSourceTargets;
                    final /* synthetic */ KubernetesMapResourceEntryReference $ref;
                    final /* synthetic */ KubernetesMapResourceEntryRenameHandler this$0;
                    final /* synthetic */ invoke.dialog.1 this$1;
                    final /* synthetic */ String $newName;
                    {
                        this.$project = $project;
                        this.$inSourceTargets = $inSourceTargets;
                        this.$ref = $ref;
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$newName = $newName;
                        super($project);
                        ComponentManager $this$service$iv = (ComponentManager)$project;
                        boolean $i$f$service = false;
                        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                        }
                        this.resolver = (KubernetesResolver)object;
                    }

                    @NotNull
                    public final KubernetesResolver getResolver() {
                        return this.resolver;
                    }

                    @NotNull
                    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usages) {
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        return new UsageViewDescriptor(this.$inSourceTargets, this.$ref){
                            final /* synthetic */ List<PsiElement> $inSourceTargets;
                            final /* synthetic */ KubernetesMapResourceEntryReference $ref;
                            {
                                this.$inSourceTargets = $inSourceTargets;
                                this.$ref = $ref;
                            }

                            @NotNull
                            public PsiElement[] getElements() {
                                Collection $this$toTypedArray$iv = this.$inSourceTargets;
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                return thisCollection$iv.toArray(new PsiElement[0]);
                            }

                            @NotNull
                            public String getProcessedElementsHeader() {
                                Object[] objectArray = new Object[]{this.$ref.getTargetInfo().getKey()};
                                String string = KubernetesBundle.message("KubernetesMapResourceEntryRenameHandler.processed.elements.header", objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                return string;
                            }

                            @NotNull
                            public String getCodeReferencesText(int usagesCount, int filesCount) {
                                Object[] objectArray = new Object[]{usagesCount, filesCount};
                                String string = KubernetesBundle.message("KubernetesMapResourceEntryRenameHandler.code.references.text", objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                return string;
                            }
                        };
                    }

                    @NotNull
                    protected UsageInfo[] findUsages() {
                        SearchScope searchScope = this.this$1.getRefactoringScope();
                        Intrinsics.checkNotNullExpressionValue((Object)searchScope, (String)"getRefactoringScope(...)");
                        Collection $this$toTypedArray$iv = KubernetesMapResourceEntryRenameHandler.access$findUsages(this.this$0, searchScope, this.resolver, this.$ref);
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new UsageInfo[0]);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected void performRefactoring(@NotNull UsageInfo[] usages) {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        Intrinsics.checkNotNullParameter((Object)usages, (String)"usages");
                        Iterable iterable = this.$inSourceTargets;
                        Project project2 = this.$project;
                        KubernetesMapResourceEntryRenameHandler kubernetesMapResourceEntryRenameHandler = this.this$0;
                        boolean $i$f$mapNotNull = false;
                        void var4_6 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            YAMLKeyValue it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            PsiElement it = (PsiElement)element$iv$iv;
                            boolean bl2 = false;
                            if ((it instanceof YAMLKeyValue ? (YAMLKeyValue)it : null) == null) continue;
                            it$iv$iv = it$iv$iv;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List list2 = (List)destination$iv$iv;
                        kubernetesMapResourceEntryRenameHandler.rename(project2, list2, ArraysKt.asList((Object[])usages), this.$newName);
                    }

                    @NotNull
                    protected String getCommandName() {
                        String string = KubernetesBundle.message("KubernetesMapResourceEntryRenameHandler.command.name", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        return string;
                    }
                });
                this.close(0);
            }
        };
        RenameDialog.showRenameDialog((DataContext)dataContext, (RenameDialog)dialog2);
    }

    public final void rename(@NotNull Project project2, @NotNull Collection<? extends YAMLKeyValue> targets, @NotNull Collection<? extends UsageInfo> usages, @NotNull String newName) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        Intrinsics.checkNotNullParameter(usages, (String)"usages");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> KubernetesMapResourceEntryRenameHandler.rename$lambda$3(project2, usages, targets, newName));
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] elements, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)elements, (String)"elements");
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<UsageInfo> findUsages(SearchScope scope2, KubernetesResolver resolver, KubernetesMapResourceEntryReference ref) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = resolver.findKubernetesMapObjectEntryReferrers(scope2, ref.getElement(), ref.getTargetInfo().getKey(), ref.getTargetInfo().getResourceInfo().getName(), ref.getTargetInfo().getResourceInfo().getKind());
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            YAMLValue yAMLValue = it.getValue();
            Intrinsics.checkNotNull((Object)yAMLValue);
            collection.add(new UsageInfo((PsiElement)yAMLValue, false));
        }
        return (List)destination$iv$iv;
    }

    private final KubernetesMapResourceEntryReference getKubernetesMapResourceEntryReference(DataContext dataContext) {
        if (dataContext == null) {
            return null;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        PsiReference psiReference = TargetElementUtil.findReference((Editor)editor2);
        return psiReference instanceof KubernetesMapResourceEntryReference ? (KubernetesMapResourceEntryReference)psiReference : null;
    }

    private static final void rename$lambda$3(Project $project, Collection $usages, Collection $targets, String $newName) {
        UsageInfo it;
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$usages, (String)"$usages");
        Intrinsics.checkNotNullParameter((Object)$targets, (String)"$targets");
        Intrinsics.checkNotNullParameter((Object)$newName, (String)"$newName");
        YAMLElementGenerator gen = YAMLElementGenerator.getInstance((Project)$project);
        Iterable $this$forEach$iv = $usages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YAMLKeyValue newVal;
            YAMLScalar usageElement;
            it = (UsageInfo)element$iv;
            boolean bl = false;
            PsiElement psiElement = it.getElement();
            if ((psiElement instanceof YAMLScalar ? (YAMLScalar)psiElement : null) == null) continue;
            usageElement = usageElement;
            Intrinsics.checkNotNullExpressionValue((Object)gen.createYamlKeyValue("dummyKey", $newName), (String)"createYamlKeyValue(...)");
            YAMLValue yAMLValue = newVal.getValue();
            Intrinsics.checkNotNull((Object)yAMLValue);
            usageElement.replace((PsiElement)yAMLValue);
        }
        $this$forEach$iv = $targets;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            YAMLKeyValue newVal;
            it = (YAMLKeyValue)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)gen.createYamlKeyValue($newName, "dummyValue"), (String)"createYamlKeyValue(...)");
            PsiElement psiElement = it.getKey();
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement psiElement2 = newVal.getKey();
            Intrinsics.checkNotNull((Object)psiElement2);
            psiElement.replace(psiElement2);
        }
    }

    public static final /* synthetic */ Collection access$findUsages(KubernetesMapResourceEntryRenameHandler $this, SearchScope scope2, KubernetesResolver resolver, KubernetesMapResourceEntryReference ref) {
        return $this.findUsages(scope2, resolver, ref);
    }
}

