/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.kubernetes.model.openapi.GroupVersionKind;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/model/ResourceIdentity;", "", "group", "", "version", "kind", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "apiVersion", "getApiVersion", "()Ljava/lang/String;", "getGroup", "getKind", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.clouds.kubernetes"})
public final class ResourceIdentity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String group;
    @NotNull
    private final String version;
    @NotNull
    private final String kind;
    @NotNull
    private static final ResourceIdentity UNDEFINED = new ResourceIdentity("", "", "_UndefinedResource");
    @NotNull
    private static final ResourceIdentity LIST_ID = new ResourceIdentity("", "v1", "List");

    public ResourceIdentity(@NotNull String group2, @NotNull String version2, @NotNull String kind) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        this.group = group2;
        this.version = version2;
        this.kind = kind;
    }

    @NotNull
    public final String getGroup() {
        return this.group;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    @NotNull
    public final String getKind() {
        return this.kind;
    }

    @NotNull
    public final String getApiVersion() {
        return StringsKt.isBlank((CharSequence)this.group) ? this.version : this.group + "/" + this.version;
    }

    @NotNull
    public String toString() {
        return this.getApiVersion() + "/" + this.kind;
    }

    @NotNull
    public final String component1() {
        return this.group;
    }

    @NotNull
    public final String component2() {
        return this.version;
    }

    @NotNull
    public final String component3() {
        return this.kind;
    }

    @NotNull
    public final ResourceIdentity copy(@NotNull String group2, @NotNull String version2, @NotNull String kind) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        return new ResourceIdentity(group2, version2, kind);
    }

    public static /* synthetic */ ResourceIdentity copy$default(ResourceIdentity resourceIdentity, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = resourceIdentity.group;
        }
        if ((n & 2) != 0) {
            string2 = resourceIdentity.version;
        }
        if ((n & 4) != 0) {
            string3 = resourceIdentity.kind;
        }
        return resourceIdentity.copy(string, string2, string3);
    }

    public int hashCode() {
        int result2 = this.group.hashCode();
        result2 = result2 * 31 + this.version.hashCode();
        result2 = result2 * 31 + this.kind.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourceIdentity)) {
            return false;
        }
        ResourceIdentity resourceIdentity = (ResourceIdentity)other;
        if (!Intrinsics.areEqual((Object)this.group, (Object)resourceIdentity.group)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.version, (Object)resourceIdentity.version)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.kind, (Object)resourceIdentity.kind);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/model/ResourceIdentity$Companion;", "", "()V", "LIST_ID", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "getLIST_ID", "()Lcom/intellij/kubernetes/model/ResourceIdentity;", "UNDEFINED", "getUNDEFINED", "create", "gvk", "Lcom/intellij/kubernetes/model/openapi/GroupVersionKind;", "apiVersion", "", "kind", "createUnknown", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ResourceIdentity getUNDEFINED() {
            return UNDEFINED;
        }

        @NotNull
        public final ResourceIdentity getLIST_ID() {
            return LIST_ID;
        }

        @NotNull
        public final ResourceIdentity create(@NotNull String apiVersion, @NotNull String kind) {
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            char[] cArray = new char[]{'/'};
            List parts = StringsKt.split$default((CharSequence)apiVersion, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            return switch (parts.size()) {
                case 1 -> new ResourceIdentity("", (String)parts.get(0), kind);
                case 2 -> new ResourceIdentity((String)parts.get(0), (String)parts.get(1), kind);
                default -> this.getUNDEFINED();
            };
        }

        @NotNull
        public final ResourceIdentity create(@NotNull GroupVersionKind gvk) {
            Intrinsics.checkNotNullParameter((Object)gvk, (String)"gvk");
            return new ResourceIdentity(gvk.getGroup(), gvk.getVersion(), gvk.getKind());
        }

        @NotNull
        public final ResourceIdentity createUnknown(@NotNull String apiVersion) {
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            return this.create(apiVersion, "_UndefinedResource");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

