/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.kubernetes.K8sSpecVersion;
import com.intellij.kubernetes.model.openapi.OpenApiSpec;
import com.intellij.kubernetes.model.openapi.SchemaObject;
import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ0\u0010\u0007\u001a\u00020\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0002J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00152\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002J'\u0010\u001b\u001a\u00020\b\"\b\b\u0000\u0010\u001c*\u00020\u00012\u0006\u0010\u001d\u001a\u0002H\u001c2\u0006\u0010\u001e\u001a\u0002H\u001cH\u0002\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/kubernetes/model/RefinementApplier;", "", "classLoader", "Ljava/lang/ClassLoader;", "mainSpecVersion", "", "(Ljava/lang/ClassLoader;Ljava/lang/String;)V", "apply", "", "mainSpec", "Lcom/intellij/kubernetes/model/openapi/OpenApiSpec;", "originalDefinitions", "", "Lcom/intellij/kubernetes/model/openapi/SchemaObject;", "refiningDefinitions", "applyRefinement", "originalDefinition", "refiningDefinition", "extractSpecVersion", "specFileName", "filterAndSortApplicableRefinementSpecs", "", "allRefinementSpecs", "getAllFields", "Ljava/lang/reflect/Field;", "type", "Ljava/lang/Class;", "patchFields", "T", "original", "refining", "(Ljava/lang/Object;Ljava/lang/Object;)V", "readAvailableRefinementSpecNames", "readRefinementSpec", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nRefinementApplier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RefinementApplier.kt\ncom/intellij/kubernetes/model/RefinementApplier\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1855#2,2:97\n1549#2:99\n1620#2,3:100\n1855#2:103\n1855#2,2:104\n1856#2:106\n1549#2:108\n1620#2,3:109\n766#2:112\n857#2,2:113\n1045#2:115\n1549#2:116\n1620#2,3:117\n1#3:107\n*S KotlinDebug\n*F\n+ 1 RefinementApplier.kt\ncom/intellij/kubernetes/model/RefinementApplier\n*L\n17#1:97,2\n71#1:99\n71#1:100,3\n79#1:103\n80#1:104,2\n79#1:106\n88#1:108\n88#1:109,3\n89#1:112\n89#1:113,2\n90#1:115\n91#1:116\n91#1:117,3\n*E\n"})
public final class RefinementApplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassLoader classLoader;
    @Nullable
    private final String mainSpecVersion;
    @NotNull
    private static final String refinementSpecFolder = "api-spec/refine";

    public RefinementApplier(@NotNull ClassLoader classLoader, @Nullable String mainSpecVersion) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = classLoader;
        this.mainSpecVersion = mainSpecVersion;
    }

    public final void apply(@NotNull OpenApiSpec mainSpec) {
        Intrinsics.checkNotNullParameter((Object)mainSpec, (String)"mainSpec");
        Iterable $this$forEach$iv = this.filterAndSortApplicableRefinementSpecs(this.readAvailableRefinementSpecNames());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.apply(mainSpec.getDefinitions(), this.readRefinementSpec(it).getDefinitions());
        }
    }

    private final void apply(Map<String, SchemaObject> originalDefinitions, Map<String, SchemaObject> refiningDefinitions) {
        for (Map.Entry<String, SchemaObject> entry : refiningDefinitions.entrySet()) {
            SchemaObject originalDefinition;
            String definitionId = entry.getKey();
            SchemaObject refiningDefinition = entry.getValue();
            if (originalDefinitions.get(definitionId) == null) continue;
            this.applyRefinement(originalDefinition, refiningDefinition);
        }
    }

    private final void applyRefinement(SchemaObject originalDefinition, SchemaObject refiningDefinition) {
        originalDefinition.setMetatypeName(refiningDefinition.getMetatypeName());
        originalDefinition.setMetatypeSupplierName(refiningDefinition.getMetatypeSupplierName());
        if (refiningDefinition.getReadOnly() != null) {
            originalDefinition.setReadOnly(refiningDefinition.getReadOnly());
        }
        Map<String, SchemaObject> refiningDefinitionProperties = refiningDefinition.getProperties();
        Map<String, SchemaObject> originalDefinitionProperties = originalDefinition.getProperties();
        for (Map.Entry<String, SchemaObject> entry : refiningDefinitionProperties.entrySet()) {
            SchemaObject originalProperty;
            String propertyName = entry.getKey();
            SchemaObject refiningProperty = entry.getValue();
            if (originalDefinitionProperties.get(propertyName) == null) continue;
            boolean bl = false;
            SchemaObject schemaObject = refiningProperty;
            Intrinsics.checkNotNull((Object)schemaObject);
            this.patchFields(originalProperty, schemaObject);
        }
    }

    private final <T> void patchFields(T original, T refining) {
        try {
            for (Field field : this.getAllFields(original.getClass())) {
                field.setAccessible(true);
                Object value2 = field.get(refining);
                if (value2 == null) continue;
                field.set(original, value2);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private final List<Field> getAllFields(Class<?> type) {
        List list2;
        Field[] fieldArray = type.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        List thisFields = ArraysKt.asList((Object[])fieldArray);
        if (type.getSuperclass() != null) {
            Class<?> clazz = type.getSuperclass();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getSuperclass(...)");
            list2 = CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)this.getAllFields(clazz), (Iterable)thisFields));
        } else {
            list2 = thisFields;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> readAvailableRefinementSpecNames() {
        void $this$mapTo$iv$iv;
        InputStream inputStream2 = this.classLoader.getResourceAsStream("api-spec/refine/reflist.txt");
        Intrinsics.checkNotNull((Object)inputStream2);
        List list2 = FileUtil.loadLines((BufferedReader)new BufferedReader(new InputStreamReader(inputStream2)));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"loadLines(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("refine-" + (String)it + ".json");
        }
        return (List)destination$iv$iv;
    }

    private final OpenApiSpec readRefinementSpec(String specFileName) {
        OpenApiSpec openApiSpec;
        InputStream inputStream2 = this.classLoader.getResourceAsStream("api-spec/refine/" + specFileName);
        Intrinsics.checkNotNull((Object)inputStream2);
        OpenApiSpec openApiSpec2 = OpenApiSpec.Companion.loadFrom(new InputStreamReader(inputStream2, Charsets.UTF_8));
        Intrinsics.checkNotNull((Object)openApiSpec2);
        OpenApiSpec spec = openApiSpec = openApiSpec2;
        boolean bl = false;
        Iterable $this$forEach$iv = new ArrayList<SchemaObject>(spec.getDefinitions().values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SchemaObject def = (SchemaObject)element$iv;
            boolean bl2 = false;
            List<String> list2 = def.getOtherTypeIds();
            if (list2 == null) continue;
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl3 = false;
                Map<String, SchemaObject> map2 = spec.getDefinitions();
                Intrinsics.checkNotNull((Object)def);
                map2.put(it, def);
            }
        }
        return openApiSpec;
    }

    private final List<String> filterAndSortApplicableRefinementSpecs(List<String> allRefinementSpecs) {
        Iterable $this$filterTo$iv$iv;
        Pair it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Object object;
        block6: {
            block5: {
                object = this.mainSpecVersion;
                if (object == null) break block5;
                String it2 = object;
                boolean bl = false;
                K8sSpecVersion k8sSpecVersion = K8sSpecVersion.Companion.fromString(it2);
                object = k8sSpecVersion;
                if (k8sSpecVersion != null) break block6;
            }
            object = K8sSpecVersion.Companion.getMAX_VERSION();
        }
        Object mainVersion = object;
        Iterable $this$map$iv = allRefinementSpecs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair((Object)it, (Object)K8sSpecVersion.Companion.fromString(this.extractSpecVersion((String)it))));
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((K8sSpecVersion)it.getSecond()).compareTo((K8sSpecVersion)mainVersion) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (K8sSpecVersion)it.getSecond();
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((K8sSpecVersion)it.getSecond()));
            }
        });
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)it.getFirst());
        }
        return (List)destination$iv$iv;
    }

    private final String extractSpecVersion(String specFileName) {
        return StringsKt.substringAfterLast$default((String)StringsKt.substringBeforeLast$default((String)specFileName, (char)'.', null, (int)2, null), (char)'-', null, (int)2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/kubernetes/model/RefinementApplier$Companion;", "", "()V", "refinementSpecFolder", "", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

