/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlScalarType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/model/OpenApiSchemaMinLengthValidator;", "Lorg/jetbrains/yaml/meta/model/YamlScalarType;", "minLength", "", "(I)V", "validateScalarValue", "", "value", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes"})
public final class OpenApiSchemaMinLengthValidator
extends YamlScalarType {
    private final int minLength;

    public OpenApiSchemaMinLengthValidator(int minLength) {
        super("minLength validator");
        this.minLength = minLength;
    }

    protected void validateScalarValue(@NotNull YAMLScalar value2, @NotNull ProblemsHolder holder) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            String string = YamlUtilKt.getAsStrictString(value2);
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            if (it.length() < this.minLength) {
                Object[] objectArray = new Object[]{this.minLength};
                holder.registerProblem((PsiElement)value2, KubernetesBundle.message("KubernetesModelDefinition.value.too.short.error", objectArray), new LocalQuickFix[0]);
            }
        }
    }
}

