/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.KubernetesLabelUtilKt;
import com.intellij.kubernetes.TextRegex;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0014\u00a8\u0006\r"}, d2={"Lcom/intellij/kubernetes/model/KubernetesLabelType;", "Lorg/jetbrains/yaml/meta/model/YamlStringType;", "()V", "validateKey", "", "keyValue", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "validateScalarValue", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "intellij.clouds.kubernetes"})
final class KubernetesLabelType
extends YamlStringType {
    @NotNull
    public static final KubernetesLabelType INSTANCE = new KubernetesLabelType();

    private KubernetesLabelType() {
    }

    public void validateKey(@NotNull YAMLKeyValue keyValue, @NotNull ProblemsHolder problemsHolder) {
        Intrinsics.checkNotNullParameter((Object)keyValue, (String)"keyValue");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        PsiElement psiElement = keyValue.getKey();
        if (psiElement == null) {
            return;
        }
        PsiElement key2 = psiElement;
        String effectiveKeyText = YamlUtilKt.getEffectiveKeyText(keyValue);
        if (!KubernetesLabelUtilKt.isLabelTextValid(effectiveKeyText, TextRegex.KEY) && !KubernetesLabelUtilKt.isLabelTextValid(effectiveKeyText, TextRegex.MERGE_KEY)) {
            problemsHolder.registerProblem(key2, KubernetesBundle.message("KubernetesLabelType.inspection.invalid.key.message", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super.validateScalarValue(scalarValue, holder);
        if (!KubernetesLabelUtilKt.isLabelTextValid(YamlUtilKt.getEffectiveText((YAMLValue)scalarValue), false)) {
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message("KubernetesLabelType.inspection.invalid.value.message", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }
}

