/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.model;

import com.intellij.kubernetes.model.KubernetesModelDefinition;
import com.intellij.kubernetes.model.ResourceIdentity;
import com.intellij.kubernetes.model.SchemaSpecInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlAnything;
import org.jetbrains.yaml.meta.model.YamlMetaClass;
import org.jetbrains.yaml.meta.model.YamlMetaType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000eJ\u0014\u0010\u0016\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u0018J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0014J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/intellij/kubernetes/model/GenericKubernetesModelDefinition;", "Lcom/intellij/kubernetes/model/KubernetesModelDefinition;", "Lorg/jetbrains/yaml/meta/model/YamlMetaClass;", "typeName", "", "specInfo", "Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "(Ljava/lang/String;Lcom/intellij/kubernetes/model/SchemaSpecInfo;)V", "applicableResources", "", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "getApplicableResources", "()Ljava/util/Set;", "hasAnyNameFeature", "", "getSpecInfo", "()Lcom/intellij/kubernetes/model/SchemaSpecInfo;", "addAnyNameFeature", "", "fieldType", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "isArray", "addApplicableResources", "keys", "", "addFeature", "Lorg/jetbrains/yaml/meta/model/Field;", "name", "typeSupplier", "Lorg/jetbrains/yaml/meta/model/Field$MetaTypeSupplier;", "type", "addUnstructuredAnyNameFeature", "intellij.clouds.kubernetes"})
public class GenericKubernetesModelDefinition
extends YamlMetaClass
implements KubernetesModelDefinition {
    @Nullable
    private final SchemaSpecInfo specInfo;
    private boolean hasAnyNameFeature;
    @NotNull
    private final Set<ResourceIdentity> applicableResources;

    public GenericKubernetesModelDefinition(@NotNull String typeName, @Nullable SchemaSpecInfo specInfo) {
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        super(typeName);
        this.specInfo = specInfo;
        this.applicableResources = new HashSet();
    }

    @Override
    @Nullable
    public SchemaSpecInfo getSpecInfo() {
        return this.specInfo;
    }

    @Override
    @NotNull
    public Set<ResourceIdentity> getApplicableResources() {
        return this.applicableResources;
    }

    @NotNull
    public final Field addFeature(@NotNull String name2, @NotNull YamlMetaType type) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Field field = this.addFeature(new Field(name2, type));
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"addFeature(...)");
        return field;
    }

    @NotNull
    public final Field addFeature(@NotNull String name2, @NotNull Field.MetaTypeSupplier typeSupplier) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)typeSupplier, (String)"typeSupplier");
        Field field = this.addFeature(new Field(name2, typeSupplier));
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"addFeature(...)");
        return field;
    }

    public final void addApplicableResources(@NotNull Collection<ResourceIdentity> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Set<ResourceIdentity> set = this.getApplicableResources();
        Intrinsics.checkNotNull(set, (String)"null cannot be cast to non-null type java.util.HashSet<com.intellij.kubernetes.model.ResourceIdentity>");
        ((HashSet)set).addAll(keys);
    }

    public final void addAnyNameFeature(@NotNull YamlMetaType fieldType, boolean isArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)fieldType, (String)"fieldType");
        boolean bl2 = bl = !this.hasAnyNameFeature;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Field field = this.addFeature(new Field("<any-name>", fieldType)).withAnyName();
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"withAnyName(...)");
        Field feature = field;
        if (isArray) {
            feature.withMultiplicityMany();
        }
        this.hasAnyNameFeature = true;
    }

    public final void addUnstructuredAnyNameFeature() {
        boolean bl;
        boolean bl2 = bl = !this.hasAnyNameFeature;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        YamlMetaType yamlMetaType = YamlAnything.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)yamlMetaType, (String)"getInstance(...)");
        this.addFeature("<any-key>", yamlMetaType).withAnyName().withRelationSpecificType(Field.Relation.SEQUENCE_ITEM, YamlAnything.getInstance()).withEmptyValueAllowed(true);
        this.hasAnyNameFeature = true;
    }

    public final boolean hasAnyNameFeature() {
        return this.hasAnyNameFeature;
    }
}

