/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.install.kubectl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettingsKt;
import com.intellij.kubernetes.install.BinaryInstaller;
import com.intellij.kubernetes.install.InstallationResult;
import com.intellij.kubernetes.install.SuccessfulInstallation;
import com.intellij.kubernetes.install.kubectl.InstallKubectlAction;
import com.intellij.kubernetes.install.kubectl.InstallKubectlActionKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.CpuArch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0005\u001a\u0004\u0018\u00010\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\b\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\b\u0010\b\u001a\u00020\u0001H\u0002\u001a\b\u0010\t\u001a\u00020\u0001H\u0002\u001a\n\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0002\u001a2\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\f0\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"KUBECTL_BASE_URL", "", "KUBECTL_VERSION_ENDPOINT", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "downloadChecksum", "downloadUrl", "getArchName", "getBinaryName", "getDownloadUrl", "getOSName", "installKubectl", "", "project", "Lcom/intellij/openapi/project/Project;", "resultHandler", "Lkotlin/Function1;", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nInstallKubectlAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstallKubectlAction.kt\ncom/intellij/kubernetes/install/kubectl/InstallKubectlActionKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,99:1\n13#2:100\n*S KotlinDebug\n*F\n+ 1 InstallKubectlAction.kt\ncom/intellij/kubernetes/install/kubectl/InstallKubectlActionKt\n*L\n22#1:100\n*E\n"})
public final class InstallKubectlActionKt {
    @NotNull
    private static final String KUBECTL_BASE_URL = "https://dl.k8s.io/release";
    @NotNull
    private static final String KUBECTL_VERSION_ENDPOINT = "https://dl.k8s.io/release/stable.txt";
    @NotNull
    private static final Logger LOG;

    public static final void installKubectl(@NotNull Project project2, @NotNull Function1<? super Boolean, Unit> resultHandler, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project2, (Object)"install-kubectl");
        BinaryInstaller.Companion.create(project2).withBinaryName((Function0<String>)((Function0)installKubectl.2.INSTANCE)).withDownloadUrl((Function1<? super BinaryInstaller.Configuration, String>)((Function1)installKubectl.3.INSTANCE)).withChecksum((Function1<? super BinaryInstaller.Configuration, String>)((Function1)installKubectl.4.INSTANCE)).withProgressIndicator(progressIndicator).withResultHandler((Function1<? super InstallationResult, Unit>)((Function1)new Function1<InstallationResult, Unit>(resultHandler){
            final /* synthetic */ Function1<Boolean, Unit> $resultHandler;
            {
                this.$resultHandler = $resultHandler;
                super(1);
            }

            public final void invoke(@NotNull InstallationResult result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (result2 instanceof SuccessfulInstallation) {
                    PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
                    KubernetesApiGlobalSettingsKt.setKubectlPath(propertiesComponent, ((Object)((SuccessfulInstallation)result2).getBinary().toAbsolutePath()).toString());
                }
                this.$resultHandler.invoke((Object)(result2 instanceof SuccessfulInstallation));
            }
        })).install();
    }

    public static /* synthetic */ void installKubectl$default(Project project2, Function1 function1, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = installKubectl.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        InstallKubectlActionKt.installKubectl(project2, (Function1<? super Boolean, Unit>)function1, progressIndicator);
    }

    private static final String getBinaryName() {
        return SystemInfoRt.isWindows ? "kubectl.exe" : "kubectl";
    }

    private static final String getDownloadUrl() {
        String string = HttpRequests.request((String)KUBECTL_VERSION_ENDPOINT).productNameAsUserAgent().readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String latestStableVersion = string;
        return "https://dl.k8s.io/release/" + latestStableVersion + "/bin/" + InstallKubectlActionKt.getOSName() + "/" + InstallKubectlActionKt.getArchName() + "/" + InstallKubectlActionKt.getBinaryName();
    }

    private static final String getOSName() {
        return SystemInfoRt.isWindows ? "windows" : (SystemInfoRt.isLinux ? "linux" : (SystemInfoRt.isMac ? "darwin" : null));
    }

    private static final String getArchName() {
        return CpuArch.isArm64() ? "arm64" : "amd64";
    }

    private static final String downloadChecksum(String downloadUrl) {
        String string;
        String string2 = downloadUrl;
        if (string2 == null) {
            string2 = InstallKubectlActionKt.getDownloadUrl();
        }
        String checksumFileDownloadUrl = string2 + ".sha256";
        try {
            string = HttpRequests.request((String)checksumFileDownloadUrl).productNameAsUserAgent().readString();
        }
        catch (Exception e) {
            LOG.error("Failed to download kubectl checksum file from: " + checksumFileDownloadUrl, (Throwable)e);
            string = null;
        }
        return string;
    }

    public static final /* synthetic */ String access$getBinaryName() {
        return InstallKubectlActionKt.getBinaryName();
    }

    public static final /* synthetic */ String access$getDownloadUrl() {
        return InstallKubectlActionKt.getDownloadUrl();
    }

    public static final /* synthetic */ String access$downloadChecksum(String downloadUrl) {
        return InstallKubectlActionKt.downloadChecksum(downloadUrl);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(InstallKubectlAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

