/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.helm.model.HelmMetaClassDefinitionsKt;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/helm/model/SemVerMetaClass;", "Lorg/jetbrains/yaml/meta/model/YamlStringType;", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "(Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "validateScalarValue", "", "scalarValue", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "intellij.clouds.kubernetes"})
public final class SemVerMetaClass
extends YamlStringType {
    public SemVerMetaClass(@NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        super.validateScalarValue(scalarValue, holder);
        Regex regex = HelmMetaClassDefinitionsKt.access$getSemVerRegex$p();
        String string = scalarValue.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
        if (!regex.matches((CharSequence)string)) {
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message("HelmChartUnknownValuesInspection.invalid.semver.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }
}

