/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmResolverKt;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.SimpleSearchableObject;
import com.intellij.kubernetes.helm.model.spec.Definition;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0016\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u0014\u0010\u0013\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/kubernetes/helm/model/PredefinedHelmDataObject;", "Lcom/intellij/kubernetes/helm/model/SimpleSearchableObject;", "name", "", "pathInChart", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "schema", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "(Ljava/lang/String;Lcom/intellij/kubernetes/helm/model/PathInChart;Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "description", "getDescription", "()Ljava/lang/String;", "isDeprecated", "", "()Z", "isFunction", "isOverridable", "isRenameable", "isRequired", "mustHaveValueDefinition", "getMustHaveValueDefinition", "getName", "names", "", "getNames", "()Ljava/util/Set;", "getPathInChart", "()Lcom/intellij/kubernetes/helm/model/PathInChart;", "findChildObject", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "intellij.clouds.kubernetes"})
public class PredefinedHelmDataObject
extends SimpleSearchableObject {
    @NotNull
    private final String name;
    @NotNull
    private final PathInChart pathInChart;
    @NotNull
    private final Definition schema;
    private final boolean isFunction;
    private final boolean isRequired;
    private final boolean isDeprecated;
    private final boolean isOverridable;
    private final boolean isRenameable;
    @NotNull
    private final Set<String> names;
    @Nullable
    private final String description;
    private final boolean mustHaveValueDefinition;

    public PredefinedHelmDataObject(@NotNull String name2, @NotNull PathInChart pathInChart, @NotNull Definition schema) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        super(pathInChart);
        this.name = name2;
        this.pathInChart = pathInChart;
        this.schema = schema;
        this.isFunction = this.schema.isFunction();
        this.isRequired = this.schema.getRequired();
        this.isDeprecated = this.schema.getDeprecated();
        this.isOverridable = this.schema.getOverridable();
        Map<String, Definition> map2 = this.schema.getDefinitions();
        if (map2 == null || (map2 = map2.keySet()) == null) {
            map2 = SetsKt.emptySet();
        }
        this.names = map2;
        this.description = this.schema.getDescription();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final PathInChart getPathInChart() {
        return this.pathInChart;
    }

    @Override
    public boolean isFunction() {
        return this.isFunction;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public boolean isOverridable() {
        return this.isOverridable;
    }

    @Override
    public boolean isRenameable() {
        return this.isRenameable;
    }

    @Override
    @NotNull
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean getMustHaveValueDefinition() {
        return this.mustHaveValueDefinition;
    }

    @Override
    @Nullable
    public HelmObject findChildObject(@NotNull String name2) {
        PredefinedHelmDataObject predefinedHelmDataObject;
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Map<String, Definition> map2 = this.schema.getDefinitions();
        if (map2 != null && (map2 = map2.get(name2)) != null) {
            Map<String, Definition> it = map2;
            boolean bl = false;
            predefinedHelmDataObject = new PredefinedHelmDataObject(((Definition)((Object)it)).getName(), HelmResolverKt.append(this.pathInChart, ((Definition)((Object)it)).getName()), (Definition)((Object)it));
        } else {
            predefinedHelmDataObject = null;
        }
        return predefinedHelmDataObject;
    }
}

