/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.ChartsModificationListener;
import com.intellij.kubernetes.helm.CustomChartSupport;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.model.ChartObject;
import com.intellij.kubernetes.helm.model.HelmModelProvider;
import com.intellij.kubernetes.helm.model.HelmNavigationTargetProviderMixin;
import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmObjectKt;
import com.intellij.kubernetes.helm.model.HelmResolveTarget;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.kubernetes.helm.model.HelmResolver;
import com.intellij.kubernetes.helm.model.HelmResolverKt;
import com.intellij.kubernetes.helm.model.HelmValuePomTarget;
import com.intellij.kubernetes.helm.model.MergeableHelmObject;
import com.intellij.kubernetes.helm.model.MultiHelmObject;
import com.intellij.kubernetes.helm.model.ObjectPath;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.PathObject;
import com.intellij.kubernetes.helm.model.PredefinedHelmDataObject;
import com.intellij.kubernetes.helm.model.SimpleHelmResolveTarget;
import com.intellij.kubernetes.helm.model.TransformDirection;
import com.intellij.kubernetes.helm.model.ValuesYamlFileObject;
import com.intellij.kubernetes.helm.model.YamlFileObject;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0007\u0018\u0000 Z2\u00020\u0001:\u0003Z[\\B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JU\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00110\u0010\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152'\u0010\u0017\u001a#\u0012\u0013\u0012\u00110\u0013\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00110\u00100\u0018H\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020%H\u0016J3\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b*J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020'H\u0002J\u001a\u0010.\u001a\u0004\u0018\u00010#2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u0004\u0018\u00010\u00132\u0006\u0010-\u001a\u00020'J\u000e\u00102\u001a\u0002032\u0006\u0010\u001b\u001a\u00020\u0013J\u0010\u00104\u001a\u0004\u0018\u0001032\u0006\u00105\u001a\u00020'J\u000e\u00106\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u00107\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0013H\u0002J\u0010\u00108\u001a\u00020\u00152\u0006\u00109\u001a\u00020'H\u0002J\u000e\u0010:\u001a\u00020\u00152\u0006\u00109\u001a\u00020'J\u0010\u0010;\u001a\u00020\u00152\u0006\u00109\u001a\u00020'H\u0002J\u001e\u0010<\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020=2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0010H\u0002J\u001e\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020\u001d2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0010H\u0002J\u001d\u0010B\u001a\u00020%2\u0006\u00109\u001a\u00020'2\u0006\u0010C\u001a\u00020=H\u0000\u00a2\u0006\u0002\bDJ$\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010F\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0014\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u001b\u001a\u00020\u0013J\u0014\u0010H\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010I\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010J\u001a\u00020KH\u0002J#\u0010L\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\bMJT\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010O\u001a\u00020\u00152\u0006\u0010P\u001a\u00020\u00152\u0018\u0010Q\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00100\u00182\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00150\u0018H\u0002J\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010T\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010U\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u001b\u001a\u00020\u0013J\u0016\u0010V\u001a\u0004\u0018\u00010\u001d*\u00020\u001f2\u0006\u0010W\u001a\u00020,H\u0002J\u000e\u0010X\u001a\u0004\u0018\u00010\u001d*\u00020\u0013H\u0002J\u0016\u0010Y\u001a\u0004\u0018\u00010\u001d*\u00020\u001f2\u0006\u0010\u001a\u001a\u00020=H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006]"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmResolver;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "chartModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getChartModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "chartsModificationListener", "Lcom/intellij/kubernetes/helm/ChartsModificationListener;", "usagesHandler", "Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler;", "getUsagesHandler", "()Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler;", "collectItemsForSameNamedPathsInAllCharts", "", "T", "startFrom", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "forRename", "", "stopOnFirst", "collector", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "pathInChart", "collectMergedInObjects", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "createRootObject", "createValuesObject", "schema", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "dispose", "", "findUsages", "Lcom/intellij/psi/PsiElement;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "findUsages$intellij_clouds_kubernetes", "getObjectPathByDefinitionElement", "Lcom/intellij/kubernetes/helm/model/ObjectPath;", "definitionElement", "getObjectSchemaByFileName", "fileName", "", "getPathInChartByDefinitionElement", "getResolveTarget", "Lcom/intellij/kubernetes/helm/model/HelmResolveTarget;", "getResolveTargetByDeclarationElement", "declarationElement", "getRootPathInChart", "isOverridable", "isProbablyValueDefinition", "element", "isUsageTarget", "isValueDeclaration", "joinIfNeeded", "", "objects", "mergeIfNeeded", "mainObject", "mergedInObjects", "renameUsage", "newName", "renameUsage$intellij_clouds_kubernetes", "resolveByObjectPath", "onlyNavigatable", "resolveClosestObjects", "resolveEffectiveObjects", "resolveNearestObjectsInOverrideChain", "direction", "Lcom/intellij/kubernetes/helm/model/TransformDirection;", "resolveObjectsInAllChartsNamedBy", "resolveObjectsInAllChartsNamedBy$intellij_clouds_kubernetes", "resolveOverridableObjectsOneDirection", "onlyFirstOnPath", "resolveInInitialChart", "transformPathInChart", "isKosher", "resolveOverriddenObjects", "resolveOverridingObjects", "resolveReachableObjectsInAllCharts", "resolveHere", "objectPath", "resolveRightHere", "resolveTopObject", "Companion", "RootObject", "UsagesHandler", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmResolver.kt\ncom/intellij/kubernetes/helm/model/HelmResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 MiscUtil.kt\ncom/intellij/kubernetes/MiscUtilKt\n*L\n1#1,343:1\n1360#2:344\n1446#2,5:345\n1655#2,8:350\n1747#2,3:363\n1360#2:366\n1446#2,2:367\n1603#2,9:369\n1855#2:378\n1856#2:380\n1612#2:381\n1448#2,3:382\n14#3:358\n14#3:359\n31#4,2:360\n1#5:362\n1#5:379\n53#6:385\n*S KotlinDebug\n*F\n+ 1 HelmResolver.kt\ncom/intellij/kubernetes/helm/model/HelmResolver\n*L\n49#1:344\n49#1:345,5\n56#1:350,8\n139#1:363,3\n258#1:366\n258#1:367,2\n259#1:369,9\n259#1:378\n259#1:380\n259#1:381\n258#1:382,3\n64#1:358\n69#1:359\n77#1:360,2\n259#1:379\n272#1:385\n*E\n"})
public final class HelmResolver
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ChartsModificationListener chartsModificationListener;
    @NotNull
    private final ModificationTracker chartModificationTracker;

    public HelmResolver(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.chartsModificationListener = new ChartsModificationListener(this.project, this);
        this.chartModificationTracker = this.chartsModificationListener.getValuesModificationTracker();
    }

    @NotNull
    public final ModificationTracker getChartModificationTracker() {
        return this.chartModificationTracker;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<HelmObject> resolveEffectiveObjects(@NotNull PathInChart startFrom) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        if (!this.isOverridable(startFrom)) {
            return CollectionsKt.listOfNotNull((Object)this.resolveRightHere(startFrom));
        }
        Function1 isKosher2 = resolveEffectiveObjects.isKosher.1.INSTANCE;
        if (HelmResolver.Companion.isGlobal(startFrom.getObjectPath())) {
            collection = CollectionsKt.listOfNotNull((Object)CollectionsKt.lastOrNull((Iterable)this.resolveOverridableObjectsOneDirection(startFrom, false, true, TransformDirection.UPCHART.getTransformOperation(true), (Function1<? super HelmObject, Boolean>)isKosher2)));
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = HelmResolveUtilKt.transformToTopmost(startFrom);
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PathInChart it = (PathInChart)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = this.resolveOverridableObjectsOneDirection(it, true, true, TransformDirection.DOWNCHART.getTransformOperation(false), (Function1<? super HelmObject, Boolean>)isKosher2);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$distinctBy$iv = (List)destination$iv$iv;
            boolean $i$f$distinctBy = false;
            HashSet<Set> set$iv = new HashSet<Set>();
            ArrayList list$iv = new ArrayList();
            for (Object e$iv : $this$distinctBy$iv) {
                HelmObject it = (HelmObject)e$iv;
                boolean bl = false;
                Set key$iv = CollectionsKt.toSet((Iterable)it.getDefinitionElements());
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            collection = list$iv;
        }
        return collection;
    }

    @NotNull
    public final PathInChart getRootPathInChart(@NotNull Chart chart2) {
        Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
        return HelmResolveUtilKt.getRootPathInChart(chart2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final HelmResolveTarget getResolveTargetByDeclarationElement(@NotNull PsiElement declarationElement) {
        HelmNavigationTargetProviderMixin helmNavigationTargetProviderMixin;
        Intrinsics.checkNotNullParameter((Object)declarationElement, (String)"declarationElement");
        if (declarationElement instanceof PomTargetPsiElement) {
            PomTarget $this$asSafely$iv = ((PomTargetPsiElement)declarationElement).getTarget();
            boolean $i$f$asSafely = false;
            PomTarget pomTarget = $this$asSafely$iv;
            if (!(pomTarget instanceof HelmValuePomTarget)) {
                pomTarget = null;
            }
            HelmValuePomTarget helmValuePomTarget = (HelmValuePomTarget)pomTarget;
            Object object = helmValuePomTarget;
            if (helmValuePomTarget == null) return null;
            PathInChart pathInChart = ((HelmValuePomTarget)object).getPathInChart();
            object = pathInChart;
            if (pathInChart == null) return null;
            HelmResolveTarget helmResolveTarget = HelmResolverKt.resolveTarget((PathInChart)object);
            return helmResolveTarget;
        }
        if (!(declarationElement instanceof YAMLScalar)) return null;
        YamlMetaTypeProvider yamlMetaTypeProvider = HelmModelProvider.Companion.getInstance().getMetaTypeProvider(((YAMLScalar)declarationElement).getContainingFile());
        if (yamlMetaTypeProvider == null) return null;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = yamlMetaTypeProvider.getValueMetaType((YAMLValue)declarationElement);
        if (metaTypeProxy == null) return null;
        YamlMetaType yamlMetaType = metaTypeProxy.getMetaType();
        if (yamlMetaType == null) return null;
        YamlMetaType $this$asSafely$iv = yamlMetaType;
        boolean $i$f$asSafely = false;
        YamlMetaType yamlMetaType2 = $this$asSafely$iv;
        if (!(yamlMetaType2 instanceof HelmNavigationTargetProviderMixin)) {
            yamlMetaType2 = null;
        }
        if ((helmNavigationTargetProviderMixin = (HelmNavigationTargetProviderMixin)yamlMetaType2) == null) return null;
        HelmResolveTarget helmResolveTarget = helmNavigationTargetProviderMixin.getResolveTarget((YAMLScalar)declarationElement);
        return helmResolveTarget;
    }

    @Nullable
    public final PathInChart getPathInChartByDefinitionElement(@NotNull PsiElement definitionElement) {
        Intrinsics.checkNotNullParameter((Object)definitionElement, (String)"definitionElement");
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        Chart chart2 = ((ChartManager)object).findChartByDefinitionElement(definitionElement);
        if (chart2 == null) {
            return null;
        }
        Chart chart3 = chart2;
        ObjectPath objectPath = this.getObjectPathByDefinitionElement(chart3, definitionElement);
        if (objectPath == null) {
            return null;
        }
        ObjectPath objectPath2 = objectPath;
        return new PathInChart(objectPath2, chart3);
    }

    private final ObjectPath getObjectPathByDefinitionElement(Chart chart2, PsiElement definitionElement) {
        VirtualFile virtualFile = YamlUtilKt.getVfsFile(definitionElement);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile containerFile = virtualFile;
        CharSequence charSequence = containerFile.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        Definition definition = this.getObjectSchemaByFileName(chart2, charSequence);
        if (definition == null) {
            return null;
        }
        Definition rootObjectSchema = definition;
        return ObjectPath.Companion.fromDefinition(rootObjectSchema.getName(), definitionElement, rootObjectSchema.getReferencedWithCapitalization());
    }

    @NotNull
    public final HelmResolveTarget getResolveTarget(@NotNull PathInChart pathInChart) {
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        HelmResolveTarget helmResolveTarget = (HelmResolveTarget)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes()), (Function1)((Function1)new Function1<CustomChartSupport, HelmResolveTarget>(pathInChart){
            final /* synthetic */ PathInChart $pathInChart;
            {
                this.$pathInChart = $pathInChart;
                super(1);
            }

            @Nullable
            public final HelmResolveTarget invoke(@NotNull CustomChartSupport it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getResolveTarget(this.$pathInChart);
            }
        })));
        if (helmResolveTarget == null) {
            helmResolveTarget = new SimpleHelmResolveTarget(pathInChart);
        }
        return helmResolveTarget;
    }

    @NotNull
    public final Collection<HelmObject> resolveClosestObjects(@NotNull PathInChart pathInChart) {
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        return this.resolveByObjectPath(pathInChart, false, true);
    }

    @NotNull
    public final Collection<HelmObject> resolveReachableObjectsInAllCharts(@NotNull PathInChart pathInChart) {
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        return this.resolveByObjectPath(pathInChart, false, false);
    }

    @NotNull
    public final Collection<HelmObject> resolveOverridingObjects(@NotNull PathInChart startFrom) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        return this.resolveNearestObjectsInOverrideChain(startFrom, TransformDirection.UPCHART);
    }

    @NotNull
    public final Collection<HelmObject> resolveOverriddenObjects(@NotNull PathInChart startFrom) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        return this.resolveNearestObjectsInOverrideChain(startFrom, TransformDirection.DOWNCHART);
    }

    private final Collection<HelmObject> resolveNearestObjectsInOverrideChain(PathInChart startFrom, TransformDirection direction) {
        if (!this.isOverridable(startFrom)) {
            return CollectionsKt.emptyList();
        }
        Function1<PathInChart, Collection<PathInChart>> transformOperation = direction.getTransformOperation(HelmResolver.Companion.isGlobal(startFrom.getObjectPath()));
        Object object = this.resolveRightHere(startFrom);
        if (object == null || (object = object.getDefinitionElements()) == null || (object = CollectionsKt.toSet((Iterable)((Iterable)object))) == null) {
            object = SetsKt.emptySet();
        }
        Object localDefinitions = object;
        return this.resolveOverridableObjectsOneDirection(startFrom, true, false, transformOperation, (Function1<? super HelmObject, Boolean>)((Function1)new Function1<HelmObject, Boolean>((Set<? extends PsiElement>)localDefinitions){
            final /* synthetic */ Set<PsiElement> $localDefinitions;
            {
                this.$localDefinitions = $localDefinitions;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull HelmObject it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !((Collection)CollectionsKt.minus((Iterable)it.getDefinitionElements(), (Iterable)this.$localDefinitions)).isEmpty();
            }
        }));
    }

    @NotNull
    public final Collection<HelmObject> resolveByObjectPath(@NotNull PathInChart startFrom, boolean onlyNavigatable, boolean stopOnFirst) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        return !this.isOverridable(startFrom) ? (Collection)CollectionsKt.listOfNotNull((Object)HelmResolver.resolveByObjectPath$resolveInChart(this, onlyNavigatable, startFrom)) : HelmResolveUtilKt.collectInCharts(startFrom, HelmResolver.Companion.isGlobal(startFrom.getObjectPath()), stopOnFirst, (Function1)new Function1<PathInChart, Collection<? extends HelmObject>>(this, onlyNavigatable){
            final /* synthetic */ HelmResolver this$0;
            final /* synthetic */ boolean $onlyNavigatable;
            {
                this.this$0 = $receiver;
                this.$onlyNavigatable = $onlyNavigatable;
                super(1);
            }

            @NotNull
            public final Collection<HelmObject> invoke(@NotNull PathInChart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CollectionsKt.listOfNotNull((Object)HelmResolver.access$resolveByObjectPath$resolveInChart(this.this$0, this.$onlyNavigatable, it));
            }
        });
    }

    public final boolean isUsageTarget(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.isProbablyValueDefinition(element) || this.isValueDeclaration(element);
    }

    private final boolean isValueDeclaration(PsiElement element) {
        return element instanceof PomTargetPsiElement && ((PomTargetPsiElement)element).getTarget() instanceof HelmValuePomTarget;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isProbablyValueDefinition(PsiElement element) {
        CustomChartSupport it;
        if (element instanceof YAMLKeyValue || element instanceof YAMLDocument || element instanceof YAMLScalar) {
            VirtualFile it2 = YamlUtilKt.getVfsFile(element);
            boolean bl = false;
            if (Chart.Companion.isChartDefinitionYaml(it2)) return true;
            if (Chart.Companion.isRequirementsFile(it2)) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) return true;
        }
        Iterable $this$any$iv = CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (CustomChartSupport)element$iv;
            boolean bl = false;
        } while (!it.isValueDefinition(element));
        return true;
    }

    @NotNull
    public final Collection<HelmObject> resolveObjectsInAllChartsNamedBy$intellij_clouds_kubernetes(@NotNull PathInChart startFrom, boolean forRename) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        HelmObject helmObject = this.resolveRightHere(startFrom);
        if (helmObject == null) {
            return CollectionsKt.emptyList();
        }
        HelmObject resolvedObject = helmObject;
        if (!this.isOverridable(startFrom)) {
            return CollectionsKt.listOf((Object)resolvedObject);
        }
        boolean isGlobalValue = HelmResolver.Companion.isGlobal(startFrom.getObjectPath());
        return HelmResolveUtilKt.collectInCharts(forRename && !isGlobalValue ? HelmResolveUtilKt.transformToBottommost(startFrom) : (Collection<PathInChart>)CollectionsKt.listOf((Object)startFrom), isGlobalValue, false, (Function1)new Function1<PathInChart, Collection<? extends HelmObject>>(this, resolvedObject){
            final /* synthetic */ HelmResolver this$0;
            final /* synthetic */ HelmObject $resolvedObject;
            {
                this.this$0 = $receiver;
                this.$resolvedObject = $resolvedObject;
                super(1);
            }

            @NotNull
            public final Collection<HelmObject> invoke(@NotNull PathInChart it) {
                HelmObject helmObject;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                HelmObject helmObject2 = HelmResolver.access$resolveRightHere(this.this$0, it);
                if (helmObject2 != null) {
                    HelmObject helmObject3 = helmObject2;
                    HelmObject helmObject4 = this.$resolvedObject;
                    HelmObject it2 = helmObject3;
                    boolean bl = false;
                    helmObject = Intrinsics.areEqual((Object)it2.getName(), (Object)helmObject4.getName()) ? helmObject3 : null;
                } else {
                    helmObject = null;
                }
                return CollectionsKt.listOfNotNull(helmObject);
            }
        });
    }

    private final UsagesHandler getUsagesHandler() {
        return (UsagesHandler)CollectionsKt.firstOrNull((List)UsagesHandler.Companion.getEP_NAME().getExtensionList((AreaInstance)this.project));
    }

    @NotNull
    public final Collection<PsiElement> findUsages$intellij_clouds_kubernetes(@NotNull PathInChart startFrom, @NotNull SearchScope searchScope, boolean forRename, boolean stopOnFirst) {
        Intrinsics.checkNotNullParameter((Object)startFrom, (String)"startFrom");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        UsagesHandler handler = this.getUsagesHandler();
        if (handler == null) {
            return CollectionsKt.emptyList();
        }
        return this.collectItemsForSameNamedPathsInAllCharts(startFrom, forRename, stopOnFirst, (Function1)new Function1<PathInChart, Collection<? extends PsiElement>>(handler, searchScope){
            final /* synthetic */ UsagesHandler $handler;
            final /* synthetic */ SearchScope $searchScope;
            {
                this.$handler = $handler;
                this.$searchScope = $searchScope;
                super(1);
            }

            @NotNull
            public final Collection<PsiElement> invoke(@NotNull PathInChart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$handler.collectUsages(it, this.$searchScope);
            }
        });
    }

    public final void renameUsage$intellij_clouds_kubernetes(@NotNull PsiElement element, @NotNull String newName) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            UsagesHandler usagesHandler = this.getUsagesHandler();
            if (usagesHandler == null) break block0;
            usagesHandler.renameUsage(element, newName);
        }
    }

    private final <T> Collection<T> collectItemsForSameNamedPathsInAllCharts(PathInChart startFrom, boolean forRename, boolean stopOnFirst, Function1<? super PathInChart, ? extends Collection<? extends T>> collector2) {
        HelmObject helmObject = this.resolveRightHere(startFrom);
        if (helmObject == null) {
            return CollectionsKt.emptyList();
        }
        HelmObject resolvedObject = helmObject;
        if (!this.isOverridable(startFrom)) {
            return (Collection)collector2.invoke((Object)startFrom);
        }
        boolean isGlobalValue = HelmResolver.Companion.isGlobal(startFrom.getObjectPath());
        return HelmResolveUtilKt.collectInCharts(forRename && !isGlobalValue ? HelmResolveUtilKt.transformToBottommost(startFrom) : (Collection<PathInChart>)CollectionsKt.listOf((Object)startFrom), isGlobalValue, stopOnFirst, (Function1)new Function1<PathInChart, Collection<? extends T>>(resolvedObject, collector2){
            final /* synthetic */ HelmObject $resolvedObject;
            final /* synthetic */ Function1<PathInChart, Collection<T>> $collector;
            {
                this.$resolvedObject = $resolvedObject;
                this.$collector = $collector;
                super(1);
            }

            @NotNull
            public final Collection<T> invoke(@NotNull PathInChart it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(it.getObjectPath().getFullPath()), (Object)this.$resolvedObject.getName()) ? (Collection)this.$collector.invoke((Object)it) : (Collection)CollectionsKt.emptyList();
            }
        });
    }

    private final boolean isOverridable(PathInChart pathInChart) {
        if (Intrinsics.areEqual((Object)pathInChart.getObjectPath(), (Object)HelmResolveUtilKt.getCHART_OBJECT_PATH())) {
            return true;
        }
        String string = pathInChart.getObjectPath().getTopObjectName();
        if (string == null) {
            return false;
        }
        String topObjectName = string;
        HelmObject helmObject = this.resolveTopObject(pathInChart.getChart(), topObjectName);
        return helmObject != null ? helmObject.isOverridable() : false;
    }

    private final Definition getObjectSchemaByFileName(Chart chart2, CharSequence fileName) {
        Object v0;
        block2: {
            if (Chart.Companion.isValuesYamlName(fileName)) {
                return chart2.getModel().getObjectSchemas().get("Values");
            }
            int dotIndex = StringsKt.lastIndexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
            CharSequence containerName = dotIndex > 0 ? fileName.subSequence(0, dotIndex) : fileName;
            Iterable iterable = chart2.getModel().getObjectSchemas().values();
            for (Object t : iterable) {
                Definition it = (Definition)t;
                boolean bl = false;
                if (!StringUtil.equalsIgnoreCase((CharSequence)it.getValueContainer(), (CharSequence)containerName)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    private final Collection<HelmObject> resolveOverridableObjectsOneDirection(PathInChart startFrom, boolean onlyFirstOnPath, boolean resolveInInitialChart, Function1<? super PathInChart, ? extends Collection<PathInChart>> transformPathInChart, Function1<? super HelmObject, Boolean> isKosher2) {
        return HelmResolveUtilKt.collectInChartsOneDirection(startFrom, onlyFirstOnPath, resolveInInitialChart, transformPathInChart, (Function1)new Function1<PathInChart, Collection<? extends HelmObject>>(this, isKosher2){
            final /* synthetic */ HelmResolver this$0;
            final /* synthetic */ Function1<HelmObject, Boolean> $isKosher;
            {
                this.this$0 = $receiver;
                this.$isKosher = $isKosher;
                super(1);
            }

            @NotNull
            public final Collection<HelmObject> invoke(@NotNull PathInChart it) {
                HelmObject helmObject;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                HelmObject helmObject2 = HelmResolver.access$resolveRightHere(this.this$0, it);
                return CollectionsKt.listOfNotNull(helmObject2 != null ? (((Boolean)this.$isKosher.invoke((Object)(helmObject = helmObject2))).booleanValue() ? helmObject : null) : null);
            }
        });
    }

    public void dispose() {
    }

    private final HelmObject resolveRightHere(PathInChart $this$resolveRightHere) {
        return this.resolveHere($this$resolveRightHere.getChart(), $this$resolveRightHere.getObjectPath());
    }

    private final HelmObject resolveTopObject(Chart $this$resolveTopObject, String name2) {
        return this.createRootObject($this$resolveTopObject).findChildObject(name2);
    }

    private final HelmObject resolveHere(Chart $this$resolveHere, ObjectPath objectPath) {
        return Intrinsics.areEqual((Object)objectPath, (Object)HelmResolveUtilKt.getCHART_OBJECT_PATH()) ? (HelmObject)new ChartObject($this$resolveHere) : HelmObjectKt.resolve(this.createRootObject($this$resolveHere), objectPath.getFullPath());
    }

    private final HelmObject createRootObject(Chart chart2) {
        return this.mergeIfNeeded(new RootObject(chart2), this.collectMergedInObjects(chart2));
    }

    private final Collection<HelmObject> collectMergedInObjects(Chart chart2) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMapIterable((Sequence)CollectionsKt.asSequence((Iterable)CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes()), (Function1)((Function1)new Function1<CustomChartSupport, Collection<? extends Pair<? extends List<? extends String>, ? extends HelmObject>>>(chart2){
            final /* synthetic */ Chart $chart;
            {
                this.$chart = $chart;
                super(1);
            }

            @NotNull
            public final Collection<Pair<List<String>, HelmObject>> invoke(@NotNull CustomChartSupport it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.collectObjects(this.$chart);
            }
        })), (Function1)((Function1)new Function1<Pair<? extends List<? extends String>, ? extends HelmObject>, HelmObject>(chart2){
            final /* synthetic */ Chart $chart;
            {
                this.$chart = $chart;
                super(1);
            }

            @NotNull
            public final HelmObject invoke(@NotNull Pair<? extends List<String>, ? extends HelmObject> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return PathObject.Companion.create(new PathInChart(ObjectPath.Companion.getROOT(), this.$chart), (List)it.getFirst(), (HelmObject)it.getSecond());
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private final HelmObject createValuesObject(Chart chart2, Definition schema) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable iterable = chart2.getDependencies().values();
        boolean $i$f$flatMap = false;
        void var6_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapNotNullTo$iv$iv;
            Chart.Dependency dependency = (Chart.Dependency)element$iv$iv;
            boolean bl = false;
            Iterable $this$mapNotNull$iv = dependency.getImportValuesMappings();
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                HelmObject helmObject;
                HelmObject helmObject2;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Chart.ImportValues importValues = (Chart.ImportValues)element$iv$iv2;
                boolean bl3 = false;
                Chart chart3 = dependency.getChart();
                if (chart3 != null && (helmObject2 = this.resolveHere(chart3, HelmResolveUtilKt.getVALUES_ROOT().append(importValues.getFromPath()))) != null) {
                    HelmObject it = helmObject2;
                    boolean bl4 = false;
                    helmObject = PathObject.Companion.create(new PathInChart(HelmResolveUtilKt.getVALUES_ROOT(), chart2), importValues.getToPath(), it);
                } else {
                    helmObject = null;
                }
                if (helmObject == null) continue;
                HelmObject it$iv$iv = helmObject;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List importedValueObjects = (List)destination$iv$iv;
        return this.mergeIfNeeded(new ValuesYamlFileObject(chart2, schema), importedValueObjects);
    }

    /*
     * WARNING - void declaration
     */
    private final HelmObject mergeIfNeeded(HelmObject mainObject, Collection<? extends HelmObject> mergedInObjects) {
        HelmObject helmObject;
        void condition$iv;
        HelmObject helmObject2 = mainObject;
        boolean bl = !mergedInObjects.isEmpty();
        boolean $i$f$transformIf = false;
        if (condition$iv != false) {
            void $this$transformIf$iv;
            void it = $this$transformIf$iv;
            boolean bl2 = false;
            helmObject = new MergeableHelmObject((HelmObject)it, this.joinIfNeeded(it.getName(), mergedInObjects));
        } else {
            helmObject = helmObject2;
        }
        return helmObject;
    }

    private final HelmObject joinIfNeeded(String name2, Collection<? extends HelmObject> objects) {
        return objects.size() == 1 ? (HelmObject)CollectionsKt.first((Iterable)objects) : (HelmObject)new MultiHelmObject(name2, objects);
    }

    private static final HelmObject resolveByObjectPath$resolveInChart(HelmResolver this$0, boolean $onlyNavigatable, PathInChart pathInChart) {
        HelmObject helmObject;
        HelmObject helmObject2 = this$0.resolveRightHere(pathInChart);
        if (helmObject2 != null) {
            HelmObject helmObject3;
            HelmObject it = helmObject3 = helmObject2;
            boolean bl = false;
            helmObject = !$onlyNavigatable || !it.getDefinitionElements().isEmpty() || !it.getDeclarationElements().isEmpty() ? helmObject3 : null;
        } else {
            helmObject = null;
        }
        return helmObject;
    }

    public static final /* synthetic */ HelmObject access$resolveByObjectPath$resolveInChart(HelmResolver this$0, boolean $onlyNavigatable, PathInChart pathInChart) {
        return HelmResolver.resolveByObjectPath$resolveInChart(this$0, $onlyNavigatable, pathInChart);
    }

    public static final /* synthetic */ HelmObject access$resolveRightHere(HelmResolver $this, PathInChart $receiver) {
        return $this.resolveRightHere($receiver);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmResolver$Companion;", "", "()V", "isGlobal", "", "Lcom/intellij/kubernetes/helm/model/ObjectPath;", "(Lcom/intellij/kubernetes/helm/model/ObjectPath;)Z", "getInstance", "Lcom/intellij/kubernetes/helm/model/HelmResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isGlobal(ObjectPath $this$isGlobal) {
            return Intrinsics.areEqual((Object)$this$isGlobal.getTopObjectName(), (Object)"Values") && Intrinsics.areEqual((Object)$this$isGlobal.getTopDefinitionName(), (Object)"global");
        }

        @NotNull
        public final HelmResolver getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Object object = project2.getService(HelmResolver.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (HelmResolver)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmResolver$RootObject;", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "(Lcom/intellij/kubernetes/helm/model/HelmResolver;Lcom/intellij/kubernetes/helm/chart/Chart;)V", "name", "", "getName", "()Ljava/lang/String;", "names", "", "getNames", "()Ljava/util/Set;", "objects", "", "findChildObject", "intellij.clouds.kubernetes"})
    @SourceDebugExtension(value={"SMAP\nHelmResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmResolver.kt\ncom/intellij/kubernetes/helm/model/HelmResolver$RootObject\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,343:1\n494#2,7:344\n453#2:351\n403#2:352\n1238#3,4:353\n*S KotlinDebug\n*F\n+ 1 HelmResolver.kt\ncom/intellij/kubernetes/helm/model/HelmResolver$RootObject\n*L\n286#1:344,7\n287#1:351\n287#1:352\n287#1:353,4\n*E\n"})
    private final class RootObject
    implements HelmObject {
        @NotNull
        private final Map<String, HelmObject> objects;
        @NotNull
        private final String name;

        /*
         * WARNING - void declaration
         */
        public RootObject(Chart chart2) {
            void $this$mapValuesTo$iv$iv;
            void $this$mapValues$iv;
            Map $this$filterValues$iv;
            Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
            Map<String, Definition> map2 = chart2.getModel().getObjectSchemas();
            RootObject rootObject = this;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                Definition it = (Definition)entry$iv.getValue();
                boolean bl = false;
                if (!(!it.getHiddenForTemplates())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            $this$filterValues$iv = result$iv;
            HelmResolver helmResolver = HelmResolver.this;
            boolean $i$f$mapValues = false;
            Iterator iterator = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                HelmObject helmObject;
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map4 = map3;
                boolean bl2 = false;
                if (((Definition)it.getValue()).getValueContainer() != null) {
                    if (Intrinsics.areEqual((Object)((Definition)it.getValue()).getValueContainer(), (Object)"values")) {
                        helmObject = helmResolver.createValuesObject(chart2, (Definition)it.getValue());
                    } else {
                        Definition definition = (Definition)it.getValue();
                        VirtualFile virtualFile = chart2.getBaseDir();
                        String string = ((Definition)it.getValue()).getValueContainer();
                        Intrinsics.checkNotNull((Object)string);
                        helmObject = new YamlFileObject(definition, chart2, CollectionsKt.listOfNotNull((Object)YamlUtilKt.findYamlWithName(virtualFile, string)));
                    }
                } else {
                    String[] stringArray = new String[]{((Definition)it.getValue()).getName()};
                    helmObject = new PredefinedHelmDataObject(((Definition)it.getValue()).getName(), new PathInChart(ObjectPath.Companion.getROOT().append(stringArray), chart2), (Definition)it.getValue());
                }
                HelmObject helmObject2 = helmObject;
                map4.put(k, helmObject2);
            }
            rootObject.objects = destination$iv$iv;
            this.name = "<root object>: " + chart2;
        }

        @Override
        @NotNull
        public Set<String> getNames() {
            return this.objects.keySet();
        }

        @Override
        @Nullable
        public HelmObject findChildObject(@NotNull String name2) {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            return this.objects.get(name2);
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\bf\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ\u001e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH&J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler;", "", "collectUsages", "", "Lcom/intellij/psi/PsiElement;", "pathInChart", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "renameUsage", "", "element", "newName", "", "Companion", "intellij.clouds.kubernetes"})
    public static interface UsagesHandler {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @NotNull
        public Collection<PsiElement> collectUsages(@NotNull PathInChart var1, @NotNull SearchScope var2);

        public void renameUsage(@NotNull PsiElement var1, @NotNull String var2);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/intellij/kubernetes/helm/model/HelmResolver$UsagesHandler;", "getEP_NAME", "()Lcom/intellij/openapi/extensions/ExtensionPointName;", "intellij.clouds.kubernetes"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final ExtensionPointName<UsagesHandler> EP_NAME;

            private Companion() {
            }

            @NotNull
            public final ExtensionPointName<UsagesHandler> getEP_NAME() {
                return EP_NAME;
            }

            static {
                $$INSTANCE = new Companion();
                EP_NAME = ExtensionPointName.Companion.create("com.intellij.kubernetes.helm.helmUsageHandler");
            }
        }
    }
}

