/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.CustomChartSupport;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.HelmModel;
import com.intellij.kubernetes.helm.model.HelmModelProvider;
import com.intellij.kubernetes.helm.model.HelmObjectMetaClass;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.helm.model.spec.ModelSpecKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u001a\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R'\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0012R\u00020\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmModelProvider;", "", "()V", "allFunctions", "", "", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "getAllFunctions", "()Ljava/util/Map;", "allFunctions$delegate", "Lkotlin/Lazy;", "apiVersions", "", "getApiVersions", "()Ljava/util/Set;", "chartYamlTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "models", "Lcom/intellij/kubernetes/helm/model/HelmModelProvider$HelmModelImpl;", "requirementsYamlTypeProvider", "getMetaTypeProvider", "psiFile", "Lcom/intellij/psi/PsiFile;", "getModel", "Lcom/intellij/kubernetes/helm/model/HelmModel;", "apiVersion", "getModelByChartFile", "Companion", "HelmModelImpl", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmModel.kt\ncom/intellij/kubernetes/helm/model/HelmModelProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class HelmModelProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final YamlMetaTypeProvider chartYamlTypeProvider = new YamlMetaTypeProvider(arg_0 -> HelmModelProvider.chartYamlTypeProvider$lambda$1(this, arg_0), HelmModelProvider::chartYamlTypeProvider$lambda$2);
    @NotNull
    private final YamlMetaTypeProvider requirementsYamlTypeProvider = new YamlMetaTypeProvider(arg_0 -> HelmModelProvider.requirementsYamlTypeProvider$lambda$3(this, arg_0), HelmModelProvider::requirementsYamlTypeProvider$lambda$4);
    @NotNull
    private final Map<String, HelmModelImpl> models;
    @NotNull
    private final Lazy allFunctions$delegate;

    public HelmModelProvider() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"v1", (Object)new HelmModelImpl("v1")), TuplesKt.to((Object)"v2", (Object)new HelmModelImpl("v2"))};
        this.models = MapsKt.mapOf((Pair[])pairArray);
        this.allFunctions$delegate = LazyKt.lazy((Function0)allFunctions.2.INSTANCE);
    }

    @Nullable
    public final YamlMetaTypeProvider getMetaTypeProvider(@Nullable PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = YamlUtilKt.getVfsFile((PsiElement)psiFile2)) == null) {
            return null;
        }
        PsiFile file2 = psiFile2;
        return Chart.Companion.isChartFile((VirtualFile)file2) ? this.chartYamlTypeProvider : (Chart.Companion.isRequirementsFile((VirtualFile)file2) ? this.requirementsYamlTypeProvider : (YamlMetaTypeProvider)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CustomChartSupport.Companion.getAll$intellij_clouds_kubernetes()), (Function1)((Function1)new Function1<CustomChartSupport, YamlMetaTypeProvider>(psiFile){
            final /* synthetic */ PsiFile $psiFile;
            {
                this.$psiFile = $psiFile;
                super(1);
            }

            @Nullable
            public final YamlMetaTypeProvider invoke(@NotNull CustomChartSupport it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getMetaTypeProvider(this.$psiFile);
            }
        }))));
    }

    @NotNull
    public final HelmModel getModel(@Nullable String apiVersion) {
        HelmModelImpl helmModelImpl = this.models.get(apiVersion);
        return helmModelImpl != null ? (HelmModel)helmModelImpl : (HelmModel)MapsKt.getValue(this.models, (Object)"v1");
    }

    private final HelmModel getModelByChartFile(PsiFile psiFile) {
        YAMLKeyValue yAMLKeyValue;
        YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping(psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null);
        String apiVersionSpecified = yAMLMapping != null && (yAMLKeyValue = YamlUtilKt.getKeyValueByKeyIgnoreSpaces(yAMLMapping, "apiVersion")) != null ? yAMLKeyValue.getValueText() : null;
        return this.getModel(apiVersionSpecified);
    }

    @NotNull
    public final Set<String> getApiVersions() {
        return this.models.keySet();
    }

    private final Map<String, Definition> getAllFunctions() {
        Lazy lazy = this.allFunctions$delegate;
        return (Map)lazy.getValue();
    }

    private static final Field chartYamlTypeProvider$lambda$1(HelmModelProvider this$0, YAMLDocument it) {
        Field field;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Definition def = (Definition)MapsKt.getValue(this$0.getModelByChartFile(it.getContainingFile()).getObjectSchemas(), (Object)"Chart");
        Field $this$chartYamlTypeProvider_u24lambda_u241_u24lambda_u240 = field = new Field("Chart", (YamlMetaType)new HelmObjectMetaClass("Chart", def));
        boolean bl = false;
        $this$chartYamlTypeProvider_u24lambda_u241_u24lambda_u240.setRequired();
        return field;
    }

    private static final long chartYamlTypeProvider$lambda$2() {
        return 0L;
    }

    private static final Field requirementsYamlTypeProvider$lambda$3(HelmModelProvider this$0, YAMLDocument it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Definition def = (Definition)MapsKt.getValue(this$0.getModel("v1").getObjectSchemas(), (Object)"Requirements");
        return new Field("Requirements", (YamlMetaType)new HelmObjectMetaClass("Requirements", def));
    }

    private static final long requirementsYamlTypeProvider$lambda$4() {
        return 0L;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmModelProvider$Companion;", "", "()V", "getInstance", "Lcom/intellij/kubernetes/helm/model/HelmModelProvider;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HelmModelProvider getInstance() {
            Object object = ApplicationManager.getApplication().getService(HelmModelProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (HelmModelProvider)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR'\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/helm/model/HelmModelProvider$HelmModelImpl;", "Lcom/intellij/kubernetes/helm/model/HelmModel;", "apiVersion", "", "(Lcom/intellij/kubernetes/helm/model/HelmModelProvider;Ljava/lang/String;)V", "getApiVersion", "()Ljava/lang/String;", "functions", "", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "getFunctions", "()Ljava/util/Map;", "objectSchemas", "getObjectSchemas", "objectSchemas$delegate", "Lkotlin/Lazy;", "intellij.clouds.kubernetes"})
    private final class HelmModelImpl
    implements HelmModel {
        @NotNull
        private final String apiVersion;
        @NotNull
        private final Lazy objectSchemas$delegate;

        public HelmModelImpl(String apiVersion) {
            Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
            this.apiVersion = apiVersion;
            this.objectSchemas$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends Definition>>(this){
                final /* synthetic */ HelmModelImpl this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Map<String, Definition> invoke() {
                    return ModelSpecKt.loadHelmObjects(this.this$0.getApiVersion());
                }
            }));
        }

        @Override
        @NotNull
        public String getApiVersion() {
            return this.apiVersion;
        }

        @Override
        @NotNull
        public Map<String, Definition> getObjectSchemas() {
            Lazy lazy = this.objectSchemas$delegate;
            return (Map)lazy.getValue();
        }

        @Override
        @NotNull
        public Map<String, Definition> getFunctions() {
            return HelmModelProvider.this.getAllFunctions();
        }
    }
}

