/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.AliasedDependencyObject;
import com.intellij.kubernetes.helm.model.ChartPomTarget;
import com.intellij.kubernetes.helm.model.DirectDependencyObject;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.kubernetes.helm.model.HelmYamlObject;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.openapi.project.Project;
import com.intellij.pom.PomTarget;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B%\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0014R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u0082\u0001\u0002\u0016\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyObject;", "Lcom/intellij/kubernetes/helm/model/HelmYamlObject;", "hostChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "dependency", "Lcom/intellij/kubernetes/helm/chart/Chart$Dependency;", "definitionElements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/kubernetes/helm/chart/Chart;Lcom/intellij/kubernetes/helm/chart/Chart$Dependency;Ljava/util/Collection;)V", "declarationElements", "getDeclarationElements", "()Ljava/util/Collection;", "getDependency", "()Lcom/intellij/kubernetes/helm/chart/Chart$Dependency;", "description", "", "getDescription", "()Ljava/lang/String;", "createPomTarget", "Lcom/intellij/pom/PomTarget;", "Companion", "Lcom/intellij/kubernetes/helm/model/AliasedDependencyObject;", "Lcom/intellij/kubernetes/helm/model/DirectDependencyObject;", "intellij.clouds.kubernetes"})
public abstract class DependencyObject
extends HelmYamlObject {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Chart.Dependency dependency;

    private DependencyObject(Chart hostChart, Chart.Dependency dependency, Collection<? extends PsiElement> definitionElements) {
        super(dependency.getEffectiveName(), definitionElements, new PathInChart(HelmResolveUtilKt.getObjectPath(dependency), hostChart), false, null, true);
        this.dependency = dependency;
    }

    @NotNull
    protected final Chart.Dependency getDependency() {
        return this.dependency;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getDeclarationElements() {
        PsiElement psiElement = PomService.convertToPsi((Project)this.getPathInChart().getChart().getProject(), (PomTarget)this.createPomTarget());
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"convertToPsi(...)");
        return CollectionsKt.listOf((Object)psiElement);
    }

    @Override
    @NotNull
    protected PomTarget createPomTarget() {
        return (PomTarget)new ChartPomTarget(this.dependency.getName(), this.getPathInChart(), this.dependency.getChart());
    }

    @Override
    @NotNull
    public String getDescription() {
        return "A section for overriding/defining values used in dependency \"" + this.getName() + "\"";
    }

    public /* synthetic */ DependencyObject(Chart hostChart, Chart.Dependency dependency, Collection definitionElements, DefaultConstructorMarker $constructor_marker) {
        this(hostChart, dependency, definitionElements);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyObject$Companion;", "", "()V", "create", "Lcom/intellij/kubernetes/helm/model/DependencyObject;", "chart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "dependencyName", "", "keyVals", "", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DependencyObject create(@NotNull Chart chart2, @NotNull String dependencyName, @NotNull Collection<? extends YAMLKeyValue> keyVals) {
            Intrinsics.checkNotNullParameter((Object)chart2, (String)"chart");
            Intrinsics.checkNotNullParameter((Object)dependencyName, (String)"dependencyName");
            Intrinsics.checkNotNullParameter(keyVals, (String)"keyVals");
            Chart.Dependency dependency = chart2.getDependencies().get(dependencyName);
            if (dependency == null) {
                return null;
            }
            Chart.Dependency dependency2 = dependency;
            return dependency2.getAlias() != null && !Intrinsics.areEqual((Object)dependency2.getAlias(), (Object)dependency2.getName()) ? (DependencyObject)new AliasedDependencyObject(chart2, dependency2, keyVals) : (DependencyObject)new DirectDependencyObject(chart2, dependency2, keyVals);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

