/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.HelmDependencyRepository;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.dependencies.HelmIndex;
import com.intellij.kubernetes.helm.dependencies.dto.HubChartDto;
import com.intellij.kubernetes.helm.dependencies.dto.HubRepoDto;
import com.intellij.kubernetes.helm.model.FullDependencyInsertHandler;
import com.intellij.kubernetes.helm.model.HelmMetaClassDefinitionsKt;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.kubernetes.helm.model.SimpleKeyValueInsertHandler;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.helm.references.RegularHelmValueReference;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.CompletionContext;
import org.jetbrains.yaml.meta.model.YamlReferenceType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyNameMetaClass;", "Lorg/jetbrains/yaml/meta/model/YamlReferenceType;", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "(Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "getReferencesFromValue", "", "Lcom/intellij/psi/PsiReference;", "valueScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)[Lcom/intellij/psi/PsiReference;", "getValueLookups", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "scalarValue", "completionContext", "Lorg/jetbrains/yaml/meta/model/CompletionContext;", "validateScalarValue", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "Companion", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmMetaClassDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependencyNameMetaClass\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 5 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,585:1\n1#2:586\n1#2:609\n31#3,2:587\n31#3,2:592\n26#4:589\n26#4:594\n66#5,2:590\n1549#6:595\n1620#6,3:596\n1603#6,9:599\n1855#6:608\n1856#6:610\n1612#6:611\n*S KotlinDebug\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependencyNameMetaClass\n*L\n294#1:609\n276#1:587,2\n314#1:592,2\n310#1:589\n317#1:594\n312#1:590,2\n290#1:595\n290#1:596,3\n294#1:599,9\n294#1:608\n294#1:610\n294#1:611\n*E\n"})
public final class DependencyNameMetaClass
extends YamlReferenceType {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public DependencyNameMetaClass(@NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        super(YamlStringType.getInstance().getTypeName());
    }

    protected void validateScalarValue(@NotNull YAMLScalar scalarValue, @NotNull ProblemsHolder holder) {
        Collection charts;
        String string;
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        YAMLMapping yAMLMapping = YamlUtilKt.getTypedAncestorOrSelf((PsiElement)scalarValue, YAMLMapping.class);
        if (yAMLMapping == null) {
            return;
        }
        YAMLMapping dependencyMapping = yAMLMapping;
        HelmDependencyRepository helmDependencyRepository = HelmMetaClassDefinitionsKt.access$getRepoFromDependencyMapping(dependencyMapping);
        if (helmDependencyRepository == null) {
            return;
        }
        HelmDependencyRepository repo = helmDependencyRepository;
        String p0 = string = YamlUtilKt.getEffectiveText((YAMLValue)scalarValue);
        boolean bl = false;
        String string2 = ((CharSequence)p0).length() > 0 ? string : null;
        if (string2 == null) {
            return;
        }
        String chartName = string2;
        Callable<Collection> callable = () -> DependencyNameMetaClass.validateScalarValue$lambda$0(repo, chartName);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        Collection collection = charts = (Collection)ApplicationUtil.runWithCheckCanceled(callable, (ProgressIndicator)progressIndicator);
        boolean bl2 = collection != null ? collection.isEmpty() : false;
        if (bl2) {
            holder.registerProblem((PsiElement)scalarValue, KubernetesBundle.message("HelmChartUnknownValuesInspection.cannot.find.chart.in.repository.message", new Object[0]), ProblemHighlightType.WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    public List<LookupElement> getValueLookups(@NotNull YAMLScalar scalarValue, @Nullable CompletionContext completionContext) {
        Intrinsics.checkNotNullParameter((Object)scalarValue, (String)"scalarValue");
        YAMLMapping yAMLMapping = YamlUtilKt.getTypedAncestorOrSelf((PsiElement)scalarValue, YAMLMapping.class);
        if (yAMLMapping == null) {
            List<LookupElement> list2 = Collections.emptyList();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"emptyList(...)");
            return list2;
        }
        YAMLMapping dependencyMapping = yAMLMapping;
        HelmDependencyRepository repo = HelmMetaClassDefinitionsKt.access$getRepoFromDependencyMapping(dependencyMapping);
        Object object = ActionsKt.runReadAction((Function0)((Function0)new Function0<Project>(dependencyMapping){
            final /* synthetic */ YAMLMapping $dependencyMapping;
            {
                this.$dependencyMapping = $dependencyMapping;
                super(0);
            }

            @NotNull
            public final Project invoke() {
                return this.$dependencyMapping.getProject();
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        Project project2 = (Project)object;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<HelmIndex> serviceClass$iv = HelmIndex.class;
        Object object2 = $this$service$iv.getService(serviceClass$iv);
        if (object2 == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        HelmIndex helmIndex = (HelmIndex)object2;
        Callable<List> lookupListCalculator2 = () -> DependencyNameMetaClass.getValueLookups$lambda$3(repo, completionContext, helmIndex, project2, dependencyMapping);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"getProgressIndicator(...)");
        Object object3 = ApplicationUtil.runWithCheckCanceled(lookupListCalculator2, (ProgressIndicator)progressIndicator);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"runWithCheckCanceled(...)");
        return (List)object3;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesFromValue(@NotNull YAMLScalar valueScalar) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)valueScalar, (String)"valueScalar");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)valueScalar);
        if (virtualFile == null) {
            return new PsiReference[0];
        }
        VirtualFile vfsFile = virtualFile;
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)valueScalar;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        YAMLMapping yAMLMapping = (YAMLMapping)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLMapping.class, (boolean)true);
        String version2 = yAMLMapping != null && (yAMLMapping = YamlUtilKt.get(yAMLMapping, "version")) != null ? YamlUtilKt.getEffectiveText((YAMLValue)yAMLMapping) : null;
        Project project2 = valueScalar.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ChartManager chartManager = (ChartManager)object;
        VirtualFile virtualFile2 = vfsFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
        Chart chart2 = chartManager.findChartByBaseDir(virtualFile2);
        if (chart2 != null) {
            String string = valueScalar.getTextValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
            Chart chart3 = chart2.findSubChart(string, version2);
            if (chart3 != null) {
                Chart it = chart3;
                boolean bl = false;
                RegularHelmValueReference it2 = new RegularHelmValueReference((PsiElement)valueScalar, HelmResolveUtilKt.getRootPathInChart(it));
                boolean bl2 = false;
                PsiReference[] psiReferenceArray2 = new PsiReference[]{it2};
                psiReferenceArray = psiReferenceArray2;
                return psiReferenceArray;
            }
        }
        boolean $i$f$emptyArray = false;
        psiReferenceArray = new PsiReference[]{};
        return psiReferenceArray;
    }

    private static final Collection validateScalarValue$lambda$0(HelmDependencyRepository $repo, String $chartName) {
        Intrinsics.checkNotNullParameter((Object)$repo, (String)"$repo");
        Intrinsics.checkNotNullParameter((Object)$chartName, (String)"$chartName");
        return $repo.getDependencyCharts($chartName);
    }

    private static final List<HubChartDto> getValueLookups$lambda$3$jointListOfLocalAndRemoteDependencies(HelmIndex helmIndex, Project project2, YAMLMapping dependencyMapping) {
        Collection collection = (Collection)ActionsKt.runReadAction((Function0)((Function0)new Function0<Collection<? extends HubChartDto>>(project2, dependencyMapping){
            final /* synthetic */ Project $project;
            final /* synthetic */ YAMLMapping $dependencyMapping;
            {
                this.$project = $project;
                this.$dependencyMapping = $dependencyMapping;
                super(0);
            }

            @Nullable
            public final Collection<HubChartDto> invoke() {
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<ChartManager> serviceClass$iv = ChartManager.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Chart chart2 = ((ChartManager)object).findChartByMetadataElement((PsiElement)this.$dependencyMapping);
                return chart2 != null ? HelmMetaClassDefinitionsKt.getLocalRepositoryChartsAsHubCharts(chart2) : null;
            }
        }));
        if (collection == null) {
            collection = CollectionsKt.emptyList();
        }
        Collection localDependencies2 = collection;
        return CollectionsKt.plus(helmIndex.getAllCharts(), (Iterable)localDependencies2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getValueLookups$lambda$3(HelmDependencyRepository $repo, CompletionContext $completionContext, HelmIndex $helmIndex, Project $project, YAMLMapping $dependencyMapping) {
        List lookups;
        List list2;
        List list3;
        Intrinsics.checkNotNullParameter((Object)$helmIndex, (String)"$helmIndex");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$dependencyMapping, (String)"$dependencyMapping");
        if ($repo != null && $completionContext != null && $completionContext.getCompletionType() == CompletionType.BASIC && $completionContext.getInvocationCount() == 1) {
            Collection<String> collection = $repo.getDependencyNames();
            if (collection != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(LookupElementBuilder.create((String)it).withInsertHandler((InsertHandler)Companion.DependencyNameInsertHandler.INSTANCE));
                }
                list3 = (List)destination$iv$iv;
            } else {
                list3 = null;
            }
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = DependencyNameMetaClass.getValueLookups$lambda$3$jointListOfLocalAndRemoteDependencies($helmIndex, $project, $dependencyMapping);
            boolean $i$f$mapNotNull = false;
            Iterable $i$f$map = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                LookupElementBuilder lookupElementBuilder;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                HubChartDto it = (HubChartDto)element$iv$iv;
                boolean bl2 = false;
                String string = it.getName();
                if (string == null) {
                    LookupElementBuilder lookupElementBuilder2;
                    lookupElementBuilder = lookupElementBuilder2 = null;
                } else {
                    LookupElementBuilder lookupElementBuilder3 = LookupElementBuilder.create((Object)it).withLookupString(string).withPresentableText(it.getName());
                    String string2 = it.getVersion();
                    if (string2 == null) {
                        string2 = "no version";
                    }
                    HubRepoDto hubRepoDto = it.getRepository();
                    lookupElementBuilder = lookupElementBuilder3.withTailText(" (" + string2 + ")").withTypeText(hubRepoDto != null ? hubRepoDto.getName() : null, true).withInsertHandler((InsertHandler)FullDependencyInsertHandler.INSTANCE);
                }
                if (lookupElementBuilder == null) continue;
                LookupElementBuilder it$iv$iv = lookupElementBuilder;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list3 = (List)destination$iv$iv;
        }
        if ((list2 = (lookups = list3)) == null || (list2 = CollectionsKt.toMutableList((Collection)list2)) == null) {
            list2 = new ArrayList();
        }
        return list2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyNameMetaClass$Companion;", "", "()V", "DependencyNameInsertHandler", "intellij.clouds.kubernetes"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyNameMetaClass$Companion$DependencyNameInsertHandler;", "Lcom/intellij/kubernetes/helm/model/SimpleKeyValueInsertHandler;", "()V", "intellij.clouds.kubernetes"})
        private static final class DependencyNameInsertHandler
        extends SimpleKeyValueInsertHandler {
            @NotNull
            public static final DependencyNameInsertHandler INSTANCE = new DependencyNameInsertHandler();

            private DependencyNameInsertHandler() {
                super("name");
            }
        }
    }
}

