/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.kubernetes.helm.model.HelmNavigationTargetProviderMixin;
import com.intellij.kubernetes.helm.model.HelmResolveTarget;
import com.intellij.kubernetes.helm.model.HelmResolveUtilKt;
import com.intellij.kubernetes.helm.model.HelmResolverKt;
import com.intellij.kubernetes.helm.model.ObjectPath;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.spec.Definition;
import com.intellij.kubernetes.helm.references.RegularHelmValueReference;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.model.YamlReferenceType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLScalar;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/helm/model/DependencyAliasMetaClass;", "Lorg/jetbrains/yaml/meta/model/YamlReferenceType;", "Lcom/intellij/kubernetes/helm/model/HelmNavigationTargetProviderMixin;", "def", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "(Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "getReferencesFromValue", "", "Lcom/intellij/psi/PsiReference;", "valueScalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "(Lorg/jetbrains/yaml/psi/YAMLScalar;)[Lcom/intellij/psi/PsiReference;", "getResolveTarget", "Lcom/intellij/kubernetes/helm/model/HelmResolveTarget;", "value", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmMetaClassDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependencyAliasMetaClass\n+ 2 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,585:1\n26#2:586\n26#2:589\n26#2:590\n26#2:592\n31#3,2:587\n31#3,2:593\n1#4:591\n*S KotlinDebug\n*F\n+ 1 HelmMetaClassDefinitions.kt\ncom/intellij/kubernetes/helm/model/DependencyAliasMetaClass\n*L\n328#1:586\n330#1:589\n331#1:590\n335#1:592\n330#1:587,2\n339#1:593,2\n*E\n"})
public final class DependencyAliasMetaClass
extends YamlReferenceType
implements HelmNavigationTargetProviderMixin {
    public DependencyAliasMetaClass(@NotNull Definition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        super(YamlStringType.getInstance().getTypeName());
    }

    @NotNull
    public PsiReference[] getReferencesFromValue(@NotNull YAMLScalar valueScalar) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)valueScalar, (String)"valueScalar");
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)valueScalar);
        if (virtualFile == null) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        VirtualFile vfsFile = virtualFile;
        String string = valueScalar.getTextValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextValue(...)");
        String aliasName = string;
        Project project2 = valueScalar.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ChartManager chartManager = (ChartManager)object;
        VirtualFile virtualFile2 = vfsFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
        Chart chart2 = chartManager.findChartByBaseDir(virtualFile2);
        if (chart2 == null) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        Chart thisChart = chart2;
        Chart.Dependency dependency = thisChart.getDependencies().get(aliasName);
        if (dependency == null) {
            boolean $i$f$emptyArray = false;
            return new PsiReference[0];
        }
        Chart.Dependency dependency2 = dependency;
        Chart chart3 = dependency2.getChart();
        if (chart3 != null) {
            Chart it = chart3;
            boolean bl = false;
            RegularHelmValueReference it2 = new RegularHelmValueReference((PsiElement)valueScalar, new PathInChart(HelmResolveUtilKt.getObjectPath(dependency2), thisChart));
            boolean bl2 = false;
            PsiReference[] psiReferenceArray2 = new PsiReference[]{it2};
            psiReferenceArray = psiReferenceArray2;
        } else {
            boolean $i$f$emptyArray = false;
            psiReferenceArray = new PsiReference[]{};
        }
        return psiReferenceArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public HelmResolveTarget getResolveTarget(@NotNull YAMLScalar value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Project project2 = value2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ChartManager chartManager = (ChartManager)object;
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)value2);
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile virtualFile2 = virtualFile.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getParent(...)");
        Chart chart2 = chartManager.findChartByBaseDir(virtualFile2);
        if (chart2 == null) return null;
        ObjectPath objectPath = HelmResolveUtilKt.getVALUES_ROOT();
        String[] stringArray = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)value2.getTextValue(), (String)"getTextValue(...)");
        PathInChart pathInChart = HelmResolverKt.newPathInChart(chart2, objectPath.append(stringArray));
        if (pathInChart == null) return null;
        HelmResolveTarget helmResolveTarget = HelmResolverKt.resolveTarget(pathInChart);
        return helmResolveTarget;
    }
}

