/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.install;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.settings.KubernetesApiGlobalSettingsKt;
import com.intellij.kubernetes.helm.install.HelmDistributionUtilsKt;
import com.intellij.kubernetes.helm.install.InstallHelmActionKt;
import com.intellij.kubernetes.install.BinaryInstaller;
import com.intellij.kubernetes.install.InstallationResult;
import com.intellij.kubernetes.install.SuccessfulInstallation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a2\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00030\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u00a8\u0006\u000b"}, d2={"getBinaryName", "", "installHelm", "", "project", "Lcom/intellij/openapi/project/Project;", "resultHandler", "Lkotlin/Function1;", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.clouds.kubernetes"})
public final class InstallHelmActionKt {
    public static final void installHelm(@NotNull Project project2, @NotNull Function1<? super Boolean, Unit> resultHandler, @Nullable ProgressIndicator progressIndicator) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project2, (Object)"install-kubectl");
        Pair<String, String> pair = HelmDistributionUtilsKt.getHelmDownloadUrlAndChecksum();
        if (pair == null) {
            return;
        }
        Pair<String, String> pair2 = pair;
        String downloadUrl = (String)pair2.component1();
        String checksum = (String)pair2.component2();
        BinaryInstaller.Companion.create(project2).withBinaryName((Function0<String>)((Function0)installHelm.2.INSTANCE)).withDownloadUrl((Function1<? super BinaryInstaller.Configuration, String>)((Function1)new Function1<BinaryInstaller.Configuration, String>(downloadUrl){
            final /* synthetic */ String $downloadUrl;
            {
                this.$downloadUrl = $downloadUrl;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull BinaryInstaller.Configuration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$downloadUrl;
            }
        })).withChecksum((Function1<? super BinaryInstaller.Configuration, String>)((Function1)new Function1<BinaryInstaller.Configuration, String>(checksum){
            final /* synthetic */ String $checksum;
            {
                this.$checksum = $checksum;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull BinaryInstaller.Configuration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$checksum;
            }
        })).withFileToVerifyFilter((Function1<? super BinaryInstaller.Configuration, ? extends Function1<? super Path, Boolean>>)((Function1)new Function1<BinaryInstaller.Configuration, Function1<? super Path, ? extends Boolean>>(downloadUrl){
            final /* synthetic */ String $downloadUrl;
            {
                this.$downloadUrl = $downloadUrl;
                super(1);
            }

            @NotNull
            public final Function1<Path, Boolean> invoke(@NotNull BinaryInstaller.Configuration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (Function1)new Function1<Path, Boolean>(this.$downloadUrl){
                    final /* synthetic */ String $downloadUrl;
                    {
                        this.$downloadUrl = $downloadUrl;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Path path) {
                        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                        return Intrinsics.areEqual((Object)((Object)path.getFileName()).toString(), (Object)StringsKt.substringAfterLast$default((String)this.$downloadUrl, (char)'/', null, (int)2, null));
                    }
                };
            }
        })).withProgressIndicator(progressIndicator).withResultHandler((Function1<? super InstallationResult, Unit>)((Function1)new Function1<InstallationResult, Unit>(resultHandler){
            final /* synthetic */ Function1<Boolean, Unit> $resultHandler;
            {
                this.$resultHandler = $resultHandler;
                super(1);
            }

            public final void invoke(@NotNull InstallationResult result2) {
                Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                if (result2 instanceof SuccessfulInstallation) {
                    PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
                    Intrinsics.checkNotNullExpressionValue((Object)propertiesComponent, (String)"getInstance(...)");
                    KubernetesApiGlobalSettingsKt.setHelmPath(propertiesComponent, ((Object)((SuccessfulInstallation)result2).getBinary().toAbsolutePath()).toString());
                }
                this.$resultHandler.invoke((Object)(result2 instanceof SuccessfulInstallation));
            }
        })).install();
    }

    public static /* synthetic */ void installHelm$default(Project project2, Function1 function1, ProgressIndicator progressIndicator, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = installHelm.1.INSTANCE;
        }
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        InstallHelmActionKt.installHelm(project2, (Function1<? super Boolean, Unit>)function1, progressIndicator);
    }

    private static final String getBinaryName() {
        return SystemInfoRt.isWindows ? "helm.exe" : "helm";
    }

    public static final /* synthetic */ String access$getBinaryName() {
        return InstallHelmActionKt.getBinaryName();
    }
}

