/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.gotpl;

import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.gotpl.HelmJsonLanguage;
import com.intellij.kubernetes.helm.gotpl.i18n.ChartsGoTemplateBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.TemplateLanguageFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeIdentifiableByVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0016J\b\u0010\r\u001a\u00020\u0007H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0007H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/kubernetes/helm/gotpl/HelmJsonFileType;", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "Lcom/intellij/openapi/fileTypes/TemplateLanguageFileType;", "Lcom/intellij/openapi/fileTypes/ex/FileTypeIdentifiableByVirtualFile;", "Lcom/intellij/openapi/fileTypes/FileType;", "()V", "getCharset", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "content", "", "getDefaultExtension", "getDescription", "getIcon", "Ljavax/swing/Icon;", "getName", "isMyFileType", "", "intellij.clouds.kubernetes.charts.gotpl"})
public final class HelmJsonFileType
extends LanguageFileType
implements TemplateLanguageFileType,
FileTypeIdentifiableByVirtualFile,
FileType {
    private HelmJsonFileType() {
        super((Language)HelmJsonLanguage.Companion.getInstance());
    }

    public boolean isMyFileType(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return YamlUtilKt.hasJsonExtension(file2) && Chart.Companion.isChartsTemplateFile(file2);
    }

    @NotNull
    public String getName() {
        return "Helm JSON template";
    }

    @NotNull
    public String getDescription() {
        String string = ChartsGoTemplateBundle.message("filetype.HelmJson.description", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "json";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = KubernetesIcons.Helm;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Helm");
        return icon;
    }

    @NotNull
    public String getCharset(@NotNull VirtualFile file2, @NotNull byte[] content2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        return "UTF-8";
    }
}

