/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm;

import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.model.HelmModelProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.vdurmont.semver4j.Requirement;
import com.vdurmont.semver4j.Semver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0012\u001a\u0012\u0010\u0015\u001a\u00020\u0006*\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012\u001a \u0010\u0017\u001a\u0004\u0018\u0001H\u0018\"\n\b\u0000\u0010\u0018\u0018\u0001*\u00020\u0019*\u00020\fH\u0086\b\u00a2\u0006\u0002\u0010\u001a\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\"\u001c\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b*\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"helmMetaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "Lcom/intellij/psi/PsiFile;", "getHelmMetaTypeProvider", "(Lcom/intellij/psi/PsiFile;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "isChartsTemplateElement", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "valueHelmMetaTypeProxy", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "getValueHelmMetaTypeProxy", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "buildDependencyVersionRequirementWoExceptions", "Lcom/vdurmont/semver4j/Requirement;", "semVerSpec", "", "isValidGoTemplateIdentifier", "name", "isSatisfiedWoExceptions", "semVer", "valueHelmMetaType", "T", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nHelmUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HelmUtil.kt\ncom/intellij/kubernetes/helm/HelmUtilKt\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,49:1\n1083#2,2:50\n31#3,2:52\n*S KotlinDebug\n*F\n+ 1 HelmUtil.kt\ncom/intellij/kubernetes/helm/HelmUtilKt\n*L\n19#1:50,2\n24#1:52,2\n*E\n"})
public final class HelmUtilKt {
    public static final boolean isValidGoTemplateIdentifier(@NotNull String name2) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            if (((CharSequence)name2).length() == 0) {
                return false;
            }
            CharSequence $this$any$iv = name2;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!(!Character.isLetterOrDigit(it) && it != '_')) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return !bl && !Character.isDigit(StringsKt.first((CharSequence)name2));
    }

    public static final boolean isChartsTemplateElement(@NotNull PsiElement $this$isChartsTemplateElement) {
        Intrinsics.checkNotNullParameter((Object)$this$isChartsTemplateElement, (String)"<this>");
        return Chart.Companion.isChartsTemplateFile(YamlUtilKt.getVfsFile($this$isChartsTemplateElement));
    }

    @Nullable
    public static final YamlMetaTypeProvider getHelmMetaTypeProvider(@NotNull PsiFile $this$helmMetaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$helmMetaTypeProvider, (String)"<this>");
        Project project2 = $this$helmMetaTypeProvider.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<HelmModelProvider> serviceClass$iv = HelmModelProvider.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((HelmModelProvider)object).getMetaTypeProvider($this$helmMetaTypeProvider);
    }

    @Nullable
    public static final YamlMetaTypeProvider.MetaTypeProxy getValueHelmMetaTypeProxy(@NotNull YAMLKeyValue $this$valueHelmMetaTypeProxy) {
        Intrinsics.checkNotNullParameter((Object)$this$valueHelmMetaTypeProxy, (String)"<this>");
        PsiFile psiFile = $this$valueHelmMetaTypeProxy.getContainingFile();
        return psiFile != null && (psiFile = psiFile.getOriginalFile()) != null && (psiFile = HelmUtilKt.getHelmMetaTypeProvider(psiFile)) != null ? psiFile.getKeyValueMetaType($this$valueHelmMetaTypeProxy) : null;
    }

    public static final /* synthetic */ <T extends YamlMetaType> T valueHelmMetaType(YAMLKeyValue $this$valueHelmMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$valueHelmMetaType, (String)"<this>");
        boolean $i$f$valueHelmMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = HelmUtilKt.getValueHelmMetaTypeProxy($this$valueHelmMetaType);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    @Nullable
    public static final Requirement buildDependencyVersionRequirementWoExceptions(@NotNull String semVerSpec) {
        Requirement requirement;
        Intrinsics.checkNotNullParameter((Object)semVerSpec, (String)"semVerSpec");
        try {
            requirement = Requirement.buildNPM(semVerSpec);
        }
        catch (Exception e) {
            requirement = null;
        }
        return requirement;
    }

    public static final boolean isSatisfiedWoExceptions(@NotNull Requirement $this$isSatisfiedWoExceptions, @NotNull String semVer) {
        Intrinsics.checkNotNullParameter((Object)$this$isSatisfiedWoExceptions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)semVer, (String)"semVer");
        try {
            return $this$isSatisfiedWoExceptions.isSatisfiedBy(new Semver(semVer, Semver.SemverType.NPM));
        }
        catch (Exception e) {
            return false;
        }
    }
}

