/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.kubernetes.api.ClusterLogPublisher;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesLogHandler;
import com.intellij.kubernetes.api.ProcessFlowEvent;
import com.intellij.kubernetes.view.KubernetesContextServiceViewContributor;
import com.intellij.kubernetes.view.KubernetesServiceViewContributor;
import com.intellij.kubernetes.view.KubernetesServiceViewContributorKt;
import com.intellij.openapi.progress.CoroutinesKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096B\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/kubernetes/api/LogHandlerPublisher;", "Lcom/intellij/kubernetes/api/ClusterLogPublisher;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModel;", "(Lcom/intellij/kubernetes/api/KubernetesApiModel;)V", "getApiModel", "()Lcom/intellij/kubernetes/api/KubernetesApiModel;", "logHandler", "Lcom/intellij/kubernetes/api/KubernetesLogHandler;", "invoke", "", "value", "Lcom/intellij/kubernetes/api/ProcessFlowEvent;", "(Lcom/intellij/kubernetes/api/ProcessFlowEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publishConsoleProcessLog", "message", "", "printErr", "", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publishIdeProcessLog", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "selectModelInServiceView", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nFlowProcessExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlowProcessExecutor.kt\ncom/intellij/kubernetes/api/LogHandlerPublisher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
public final class LogHandlerPublisher
extends ClusterLogPublisher {
    @NotNull
    private final KubernetesApiModel apiModel;
    @NotNull
    private final KubernetesLogHandler logHandler;

    public LogHandlerPublisher(@NotNull KubernetesApiModel apiModel2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        this.apiModel = apiModel2;
        this.logHandler = (KubernetesLogHandler)this.apiModel.getProject().getMessageBus().syncPublisher(KubernetesLogHandler.TOPIC);
    }

    @NotNull
    public final KubernetesApiModel getApiModel() {
        return this.apiModel;
    }

    @Override
    @Nullable
    public Object invoke(@NotNull ProcessFlowEvent value2, @NotNull Continuation<? super Unit> $completion) {
        ProcessFlowEvent processFlowEvent = value2;
        if (processFlowEvent instanceof ProcessFlowEvent.OnProcessOutput.OnStdOut) {
            Object object = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Unit>(this, value2){
                final /* synthetic */ LogHandlerPublisher this$0;
                final /* synthetic */ ProcessFlowEvent $value;
                {
                    this.this$0 = $receiver;
                    this.$value = $value;
                    super(0);
                }

                public final void invoke() {
                    KubernetesLogHandler kubernetesLogHandler = LogHandlerPublisher.access$getLogHandler$p(this.this$0);
                    KubernetesApiModel kubernetesApiModel = this.this$0.getApiModel();
                    String string = ((ProcessFlowEvent.OnProcessOutput.OnStdOut)this.$value).getProcessEvent().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    kubernetesLogHandler.printNormal(kubernetesApiModel, string);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (processFlowEvent instanceof ProcessFlowEvent.OnProcessOutput.OnStdError) {
            Object object = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Unit>(this, value2){
                final /* synthetic */ LogHandlerPublisher this$0;
                final /* synthetic */ ProcessFlowEvent $value;
                {
                    this.this$0 = $receiver;
                    this.$value = $value;
                    super(0);
                }

                public final void invoke() {
                    KubernetesLogHandler kubernetesLogHandler = LogHandlerPublisher.access$getLogHandler$p(this.this$0);
                    KubernetesApiModel kubernetesApiModel = this.this$0.getApiModel();
                    String string = ((ProcessFlowEvent.OnProcessOutput.OnStdError)this.$value).getProcessEvent().getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    kubernetesLogHandler.printError(kubernetesApiModel, string);
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (processFlowEvent instanceof ProcessFlowEvent.OnCommandLine) {
            Object object = CoroutinesKt.blockingContext((Function0)((Function0)new Function0<Unit>(this, value2){
                final /* synthetic */ LogHandlerPublisher this$0;
                final /* synthetic */ ProcessFlowEvent $value;
                {
                    this.this$0 = $receiver;
                    this.$value = $value;
                    super(0);
                }

                public final void invoke() {
                    LogHandlerPublisher.access$selectModelInServiceView(this.this$0, this.this$0.getApiModel());
                    LogHandlerPublisher.access$getLogHandler$p(this.this$0).printSystem(this.this$0.getApiModel(), "\n" + ((ProcessFlowEvent.OnCommandLine)this.$value).getCommandLine() + "\n\n");
                }
            }), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object publishIdeProcessLog(@NotNull String message2, @NotNull Continuation<? super Unit> $completion) {
        this.logHandler.printSystem(this.apiModel, message2 + "\n");
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object publishConsoleProcessLog(@NotNull String message2, boolean printErr, @NotNull Continuation<? super Unit> $completion) {
        if (printErr) {
            this.logHandler.printError(this.apiModel, message2 + "\n");
        } else {
            this.logHandler.printNormal(this.apiModel, message2 + "\n");
        }
        return Unit.INSTANCE;
    }

    private final void selectModelInServiceView(KubernetesApiModel apiModel2) {
        Object v1;
        block3: {
            KubernetesServiceViewContributor kubernetesServiceViewContributor = (KubernetesServiceViewContributor)ServiceViewContributor.findRootContributor(KubernetesServiceViewContributor.class);
            if (kubernetesServiceViewContributor == null) {
                return;
            }
            KubernetesServiceViewContributor kubernetesServiceViewContributor2 = kubernetesServiceViewContributor;
            Iterable iterable = kubernetesServiceViewContributor2.getServices(apiModel2.getProject());
            for (Object t : iterable) {
                ServiceViewContributor svc = (ServiceViewContributor)t;
                boolean bl = false;
                if (!(svc instanceof KubernetesContextServiceViewContributor && ((KubernetesContextServiceViewContributor)svc).getApiModel$intellij_clouds_kubernetes() == apiModel2)) continue;
                v1 = t;
                break block3;
            }
            v1 = null;
        }
        ServiceViewContributor serviceViewContributor = v1;
        if (serviceViewContributor == null) {
            return;
        }
        ServiceViewContributor serviceViewContributor2 = serviceViewContributor;
        KubernetesServiceViewContributorKt.selectKubernetesService(apiModel2.getProject(), serviceViewContributor2);
    }

    public static final /* synthetic */ KubernetesLogHandler access$getLogHandler$p(LogHandlerPublisher $this) {
        return $this.logHandler;
    }

    public static final /* synthetic */ void access$selectModelInServiceView(LogHandlerPublisher $this, KubernetesApiModel apiModel2) {
        $this.selectModelInServiceView(apiModel2);
    }
}

