/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.api;

import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.ContextsConfiguration;
import com.intellij.kubernetes.api.KubeConfigEntity;
import com.intellij.kubernetes.api.KubeConfigEx;
import com.intellij.kubernetes.api.KubePlugin;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesApiProviderKt;
import com.intellij.kubernetes.api.KubernetesConflictingContextsFoundException;
import com.intellij.kubernetes.api.KubernetesContextNotFoundException;
import com.intellij.kubernetes.api.KubernetesIllegalKindException;
import com.intellij.kubernetes.api.KubernetesKubeConfigParsingException;
import com.intellij.kubernetes.api.settings.KubeConfigPathProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAndWriteScope;
import com.intellij.openapi.application.ReadConstraint;
import com.intellij.openapi.application.ReadResult;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import io.kubernetes.client.util.KubeConfig;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.representer.Representer;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0090\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001e\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\f2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u001a.\u0010\u000f\u001a\u0002H\u0010\"\u0006\b\u0000\u0010\u0010\u0018\u00012\b\u0010\n\u001a\u0004\u0018\u00010\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012H\u0082\b\u00a2\u0006\u0002\u0010\u0013\u001a=\u0010\u0014\u001a\u001f\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00150\u00152\u000e\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0082@\u00a2\u0006\u0002\u0010\u001e\u001a\b\u0010\u001f\u001a\u00020 H\u0002\u001a\u001c\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\t0\"H\u0000\u001a\u001e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010(\u001a\"\u0010)\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010&\u001a\u00020\u001b2\b\b\u0002\u0010*\u001a\u00020 H\u0003\u001a*\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040,2\u0006\u0010-\u001a\u00020.2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00040,H\u0080@\u00a2\u0006\u0002\u00100\u001a\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u001bH\u0003\u001a%\u00104\u001a\u0002022\u000e\u0010\u0017\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u000b\u00105\u001a\u00070\u0006\u00a2\u0006\u0002\b6H\u0003\u001a\"\u00107\u001a\b\u0012\u0004\u0012\u00020\t0\b*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a(\u00108\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\f*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001e\u00109\u001a\u0004\u0018\u00010\u0006*\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0006\u0010:\u001a\u00020\u0006H\u0002\u001a\u0015\u0010;\u001a\u00020<*\u00020=2\u0006\u0010>\u001a\u00020=H\u0081\u0002\u001a\u0018\u0010?\u001a\t\u0018\u00010\u0006\u00a2\u0006\u0002\b6*\u00070\u0006\u00a2\u0006\u0002\b6H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "contextComparator", "Ljava/util/Comparator;", "Lcom/intellij/kubernetes/api/Context;", "defaultConfig", "", "asListSafely", "", "", "yamlNode", "asMapSafely", "", "asNonBlankStringSafely", "asStringSafely", "asTypeSafely", "T", "typeConstructor", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "associateByName", "", "Lcom/intellij/openapi/util/NlsSafe;", "configuration", "entity", "Lcom/intellij/kubernetes/api/KubeConfigEntity;", "createEmptyConfig", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createYaml", "Lorg/yaml/snakeyaml/Yaml;", "detectNotInstalledAuthPluginsInConfig", "", "Lcom/intellij/kubernetes/api/KubePlugin;", "users", "fillEmptyConfigFileByDefaultConfig", "file", "requestor", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadConfiguration", "yaml", "mergeKubeConfigFile", "", "project", "Lcom/intellij/openapi/project/Project;", "contexts", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseAndValidateKubeConfiguration", "Lcom/intellij/kubernetes/api/ContextsConfiguration;", "kubeConfigFile", "parseKubeConfiguration", "kubeConfigUrl", "Lorg/jetbrains/annotations/NonNls;", "getAsListSafely", "getAsMapSafely", "getAsNonBlankStringSafely", "key", "plus", "Lcom/intellij/kubernetes/api/KubeConfigEx;", "Lio/kubernetes/client/util/KubeConfig;", "other", "toPath", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesApiProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesApiProvider.kt\ncom/intellij/kubernetes/api/KubernetesApiProviderKt\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,964:1\n880#1,8:974\n880#1,8:982\n880#1,8:990\n453#2:965\n403#2:966\n1238#3,2:967\n1241#3:970\n1726#3,3:971\n1#4:969\n13#5:998\n*S KotlinDebug\n*F\n+ 1 KubernetesApiProvider.kt\ncom/intellij/kubernetes/api/KubernetesApiProviderKt\n*L\n871#1:974,8\n873#1:982,8\n875#1:990,8\n645#1:965\n645#1:966\n645#1:967,2\n645#1:970\n667#1:971,3\n53#1:998\n*E\n"})
public final class KubernetesApiProviderKt {
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Comparator<Context> contextComparator;
    @NotNull
    private static final String defaultConfig;

    private static final Yaml createYaml() {
        LoaderOptions loaderOptions = new LoaderOptions();
        loaderOptions.setCodePointLimit(AdvancedSettings.Companion.getInt("kubernetes.config.maxFileSizeMb") * 1024 * 1024);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        return new Yaml((BaseConstructor)new SafeConstructor(loaderOptions), new Representer(dumperOptions));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresReadLock
    @RequiresBackgroundThread
    private static final Map<?, ?> loadConfiguration(VirtualFile file2, Yaml yaml) {
        Map map2;
        try {
            Map map3;
            Closeable closeable = file2.getInputStream();
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl = false;
                map3 = (Map)yaml.load(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            map2 = map3;
            Intrinsics.checkNotNull((Object)map2);
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable t) {
            String string = file2.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            throw new KubernetesKubeConfigParsingException(string, t);
        }
        return map2;
    }

    static /* synthetic */ Map loadConfiguration$default(VirtualFile virtualFile, Yaml yaml, int n, Object object) {
        if ((n & 2) != 0) {
            yaml = KubernetesApiProviderKt.createYaml();
        }
        return KubernetesApiProviderKt.loadConfiguration(virtualFile, yaml);
    }

    @RequiresReadLock
    @RequiresBackgroundThread
    private static final ContextsConfiguration parseAndValidateKubeConfiguration(VirtualFile kubeConfigFile) {
        ContextsConfiguration contextsConfiguration;
        try {
            Map map2 = KubernetesApiProviderKt.loadConfiguration$default(kubeConfigFile, null, 2, null);
            String string = kubeConfigFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            contextsConfiguration = KubernetesApiProviderKt.parseKubeConfiguration(map2, string);
        }
        catch (Throwable e) {
            Throwable throwable = e;
            if (throwable instanceof CancellationException) {
                throw e;
            }
            if (throwable instanceof KubernetesContextNotFoundException) {
                throw e;
            }
            if (throwable instanceof KubernetesIllegalKindException) {
                throw e;
            }
            String string = kubeConfigFile.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            throw new KubernetesKubeConfigParsingException(string, e);
        }
        return contextsConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    private static final ContextsConfiguration parseKubeConfiguration(Map<?, ?> configuration, String kubeConfigUrl) {
        KubeConfigEx kubeConfigEx;
        void $this$mapValuesTo$iv$iv;
        Map<String, Map<Object, Object>> map2;
        List<Object> clustersList = KubernetesApiProviderKt.getAsListSafely(configuration, KubeConfigEntity.Clusters);
        List<Object> contextsList = KubernetesApiProviderKt.getAsListSafely(configuration, KubeConfigEntity.Contexts);
        List<Object> usersList = KubernetesApiProviderKt.getAsListSafely(configuration, KubeConfigEntity.Users);
        Map clusterPaths = new LinkedHashMap();
        for (Object clusterNode : clustersList) {
            String clusterName;
            String clusterServer;
            Map<Object, Object> clusterDefinition;
            Map<Object, Object> clusterMap = KubernetesApiProviderKt.asMapSafely(clusterNode);
            if (KubernetesApiProviderKt.getAsNonBlankStringSafely(clusterMap, "name") == null || KubernetesApiProviderKt.getAsNonBlankStringSafely(clusterDefinition = KubernetesApiProviderKt.getAsMapSafely(clusterMap, KubeConfigEntity.Clusters), "server") == null) continue;
            Map map3 = clusterPaths;
            if (KubernetesApiProviderKt.toPath(clusterServer) == null) continue;
            map3.put(clusterName, map2);
        }
        String kind = KubernetesApiProviderKt.getAsNonBlankStringSafely(configuration, "kind");
        if (!Intrinsics.areEqual((Object)kind, (Object)"Config")) {
            throw new KubernetesIllegalKindException(kind, kubeConfigUrl);
        }
        Map<String, Map<Object, Object>> clusterDefinitions = KubernetesApiProviderKt.associateByName(configuration, KubeConfigEntity.Clusters);
        Map<String, Map<Object, Object>> contextDefinitions = KubernetesApiProviderKt.associateByName(configuration, KubeConfigEntity.Contexts);
        Map<String, Map<Object, Object>> userDefinitions = KubernetesApiProviderKt.associateByName(configuration, KubeConfigEntity.Users);
        Map<String, Map<Object, Object>> $this$mapValues$iv = contextDefinitions;
        boolean $i$f$mapValues = false;
        map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Map<Object, Object> map4;
            Map<Object, Object> map5;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map6 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map7 = map6;
            boolean bl2 = false;
            String contextName = (String)entry2.getKey();
            Map contextDefinition = (Map)entry2.getValue();
            String string = KubernetesApiProviderKt.getAsNonBlankStringSafely(contextDefinition, KubeConfigEntity.Clusters.getSingularKey());
            if (string != null) {
                String it = string;
                boolean bl3 = false;
                map5 = clusterDefinitions.get(it);
            } else {
                map5 = null;
            }
            Map<Object, Object> clusterDefinition = map5;
            String string2 = KubernetesApiProviderKt.getAsNonBlankStringSafely(contextDefinition, KubeConfigEntity.Users.getSingularKey());
            if (string2 != null) {
                String it = string2;
                boolean bl4 = false;
                map4 = userDefinitions.get(it);
            } else {
                map4 = null;
            }
            Map<Object, Object> userDefinition = map4;
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)KubeConfigEntity.Clusters), clusterDefinition), TuplesKt.to((Object)((Object)KubeConfigEntity.Contexts), (Object)contextDefinition), TuplesKt.to((Object)((Object)KubeConfigEntity.Users), userDefinition)};
            Map definitions = MapsKt.mapOf((Pair[])pairArray);
            Context context = new Context(contextName, kubeConfigUrl, new EnumMap<KubeConfigEntity, Map<Object, Object>>(definitions));
            map7.put(k, context);
        }
        Map existingContexts = destination$iv$iv;
        String currentContextName = KubernetesApiProviderKt.getAsNonBlankStringSafely(configuration, "current-context");
        Set<String> contextNames = existingContexts.keySet();
        if (currentContextName != null) {
            boolean bl;
            block12: {
                Iterable $this$all$iv = contextNames;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String it = (String)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it, (Object)currentContextName)) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                throw new KubernetesContextNotFoundException(currentContextName, contextNames, kubeConfigUrl);
            }
        }
        KubeConfigEx $this$parseKubeConfiguration_u24lambda_u247 = kubeConfigEx = new KubeConfigEx(contextsList, clustersList, usersList);
        boolean bl = false;
        $this$parseKubeConfiguration_u24lambda_u247.setContext(currentContextName);
        $this$parseKubeConfiguration_u24lambda_u247.setPreferences(configuration.get("preferences"));
        $this$parseKubeConfiguration_u24lambda_u247.setFile(new File(kubeConfigUrl));
        KubeConfigEx kubeConfig = kubeConfigEx;
        return new ContextsConfiguration(existingContexts, kubeConfig);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object mergeKubeConfigFile(@NotNull Project var0, @NotNull Collection<Context> var1_1, @NotNull Continuation<? super Collection<Context>> var2_2) {
        block12: {
            block13: {
                if (!(var2_2 instanceof mergeKubeConfigFile.1)) ** GOTO lbl-1000
                var9_3 = var2_2;
                if ((var9_3.label & -2147483648) != 0) {
                    var9_3.label -= -2147483648;
                } else lbl-1000:
                // 2 sources

                {
                    $continuation = new ContinuationImpl(var2_2){
                        Object L$0;
                        Object L$1;
                        /* synthetic */ Object result;
                        int label;

                        @Nullable
                        public final Object invokeSuspend(@NotNull Object $result) {
                            this.result = $result;
                            this.label |= Integer.MIN_VALUE;
                            return KubernetesApiProviderKt.mergeKubeConfigFile(null, null, (Continuation<? super Collection<Context>>)((Continuation)this));
                        }
                    };
                }
                $result = $continuation.result;
                var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch ($continuation.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var4_6 = VirtualFileManager.getInstance().findFileByNioPath(KubeConfigPathProvider.Companion.getDefaultKubeConfigFilePath());
                        if (var4_6 == null) break block12;
                        it = var4_6;
                        $i$a$-let-KubernetesApiProviderKt$mergeKubeConfigFile$kubeConfigFile$1 = false;
                        if (!(((CharSequence)VirtualFileUtil.readText((VirtualFile)it)).length() == 0)) break;
                        $continuation.L$0 = project;
                        $continuation.L$1 = contexts;
                        $continuation.label = 1;
                        v0 = KubernetesApiProviderKt.fillEmptyConfigFileByDefaultConfig((VirtualFile)it, (Object)KubernetesApiProvider.Companion.getInstance(project), (Continuation<? super VirtualFile>)$continuation);
                        if (v0 == var10_5) {
                            return var10_5;
                        }
                        ** GOTO lbl30
                    }
                    case 1: {
                        $i$a$-let-KubernetesApiProviderKt$mergeKubeConfigFile$kubeConfigFile$1 = false;
                        contexts = (Collection)$continuation.L$1;
                        project = (Project)$continuation.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl30:
                        // 2 sources

                        v1 = (ReadConstraint[])v0;
                        break block13;
                    }
                }
                v1 = it;
            }
            if ((var5_10 = v1) == null) break block12;
            v2 = var5_10;
            ** GOTO lbl53
        }
        $continuation.L$0 = project;
        $continuation.L$1 = contexts;
        $continuation.label = 2;
        v3 = KubernetesApiProviderKt.createEmptyConfig(KubeConfigPathProvider.Companion.getDefaultKubeConfigFilePath(), (Continuation<? super VirtualFile>)$continuation);
        if (v3 == var10_5) {
            return var10_5;
        }
        ** GOTO lbl51
        {
            case 2: {
                contexts = (Collection)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl51:
                // 2 sources

                if ((v2 = (VirtualFile)v3) == null) {
                    throw new IllegalStateException("Cannot create default kubeconfig file");
                }
lbl53:
                // 3 sources

                kubeConfigFile = v2;
                var4_6 = new ReadConstraint[]{ReadConstraint.Companion.withDocumentsCommitted(project)};
                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 3;
                v4 = CoroutinesKt.constrainedReadAndWriteAction((ReadConstraint[])var4_6, (Function1)((Function1)new Function1<ReadAndWriteScope, ReadResult<? extends Collection<? extends Context>>>(kubeConfigFile, (Collection<Context>)contexts){
                    final /* synthetic */ VirtualFile $kubeConfigFile;
                    final /* synthetic */ Collection<Context> $contexts;
                    {
                        this.$kubeConfigFile = $kubeConfigFile;
                        this.$contexts = $contexts;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @NotNull
                    public final ReadResult<Collection<Context>> invoke(@NotNull ReadAndWriteScope $this$constrainedReadAndWriteAction) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$constrainedReadAndWriteAction, (String)"$this$constrainedReadAndWriteAction");
                        Yaml yaml = KubernetesApiProviderKt.access$createYaml();
                        Map configuration = MapsKt.toMutableMap((Map)KubernetesApiProviderKt.access$loadConfiguration(this.$kubeConfigFile, yaml));
                        Iterable iterable = (Iterable)KubeConfigEntity.getEntries();
                        Collection<Context> collection = this.$contexts;
                        VirtualFile virtualFile = this.$kubeConfigFile;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            KubeConfigEntity it = (KubeConfigEntity)((Object)element$iv);
                            boolean bl = false;
                            mergeKubeConfigFile.2.invoke$updateConfiguration(configuration, collection, virtualFile, it);
                        }
                        Object $this$asSafely$iv = configuration.get("current-context");
                        boolean $i$f$asSafely = false;
                        Object object = $this$asSafely$iv;
                        if (!(object instanceof CharSequence)) {
                            object = null;
                        }
                        if ((($this$asSafely$iv = (CharSequence)object) == null || $this$asSafely$iv.length() == 0) && ($this$asSafely$iv = SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)KubernetesApiProviderKt.access$getAsListSafely(configuration, KubeConfigEntity.Contexts)), (Function1)mergeKubeConfigFile.2.INSTANCE))) != null) {
                            Object it = $this$asSafely$iv;
                            boolean bl = false;
                            configuration.put("current-context", it);
                        }
                        String string = this.$kubeConfigFile.getUrl();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                        ContextsConfiguration contextsConfiguration = KubernetesApiProviderKt.access$parseKubeConfiguration(configuration, string);
                        return $this$constrainedReadAndWriteAction.writeAction((Function0)new Function0<Collection<? extends Context>>(this.$kubeConfigFile, $this$constrainedReadAndWriteAction, contextsConfiguration, yaml, (Map<Object, Object>)configuration){
                            final /* synthetic */ VirtualFile $kubeConfigFile;
                            final /* synthetic */ ReadAndWriteScope $this_constrainedReadAndWriteAction;
                            final /* synthetic */ ContextsConfiguration $contextsConfiguration;
                            final /* synthetic */ Yaml $yaml;
                            final /* synthetic */ Map<Object, Object> $configuration;
                            {
                                this.$kubeConfigFile = $kubeConfigFile;
                                this.$this_constrainedReadAndWriteAction = $this_constrainedReadAndWriteAction;
                                this.$contextsConfiguration = $contextsConfiguration;
                                this.$yaml = $yaml;
                                this.$configuration = $configuration;
                                super(0);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @NotNull
                            public final Collection<Context> invoke() {
                                Closeable closeable = this.$kubeConfigFile.getOutputStream((Object)this.$this_constrainedReadAndWriteAction);
                                Yaml yaml = this.$yaml;
                                Map<Object, Object> map2 = this.$configuration;
                                Throwable throwable = null;
                                try {
                                    OutputStream stream = (OutputStream)closeable;
                                    boolean bl = false;
                                    Intrinsics.checkNotNull((Object)stream);
                                    Closeable closeable2 = stream;
                                    Object object = Charsets.UTF_8;
                                    Writer writer = new OutputStreamWriter((OutputStream)closeable2, (Charset)object);
                                    int n = 8192;
                                    closeable2 = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
                                    object = null;
                                    try {
                                        BufferedWriter writer2 = (BufferedWriter)closeable2;
                                        boolean bl2 = false;
                                        yaml.dump(map2, (Writer)writer2);
                                        writer = Unit.INSTANCE;
                                    }
                                    catch (Throwable throwable2) {
                                        object = throwable2;
                                        throw throwable2;
                                    }
                                    finally {
                                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable3) {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                                return this.$contextsConfiguration.getContexts().values();
                            }
                        });
                    }

                    private static final void invoke$updateConfiguration(Map<Object, Object> configuration, Collection<Context> $contexts, VirtualFile kubeConfigFile, KubeConfigEntity entity) {
                        Map entityDefinitions = KubernetesApiProviderKt.access$associateByName(configuration, entity);
                        List entityNodes = KubernetesApiProviderKt.access$getAsListSafely(configuration, entity);
                        for (Context context : $contexts) {
                            String contextName = context.getName();
                            Map map2 = (Map)entityDefinitions.get(contextName);
                            if (map2 != null) {
                                Map it = map2;
                                boolean bl = false;
                                String string = kubeConfigFile.getUrl();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                                throw new KubernetesConflictingContextsFoundException(contextName, string, context.getKubeConfigUrl());
                            }
                            Map map3 = context.getDefinitions().getOrDefault((Object)((Object)entity), MapsKt.emptyMap());
                            if (map3 == null) {
                                map3 = MapsKt.emptyMap();
                            }
                            Map newEntityDefinitions = MapsKt.toMutableMap(map3);
                            Map map4 = new LinkedHashMap<K, V>();
                            if (entity.getNameFirst()) {
                                Map map5 = map4;
                                String string = "name";
                                Map<Object, Object> map6 = context.getDefinitions().get((Object)((Object)KubeConfigEntity.Contexts));
                                if (map6 == null || (map6 = map6.get("user")) == null) {
                                    map6 = contextName;
                                }
                                Map<Object, Object> map7 = map6;
                                map5.put(string, map7);
                            }
                            map4.put(entity.getSingularKey(), newEntityDefinitions);
                            if (!entity.getNameFirst()) {
                                map4.put("name", contextName);
                            }
                            ((Collection)entityNodes).add(map4);
                        }
                    }
                }), (Continuation)$continuation);
                if (v4 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl65
            }
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl65:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Object createEmptyConfig(Path path, Continuation<? super VirtualFile> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super VirtualFile>, Object>(path, null){
            int label;
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Path newConfigFile = Files.createFile(NioFiles.createParentDirectories((Path)this.$path), new FileAttribute[0]);
                        Files.writeString(newConfigFile, (CharSequence)KubernetesApiProviderKt.access$getDefaultConfig$p(), new OpenOption[0]);
                        this.label = 1;
                        Object object3 = CoroutinesKt.writeAction((Function0)((Function0)new Function0<VirtualFile>(newConfigFile){
                            final /* synthetic */ Path $newConfigFile;
                            {
                                this.$newConfigFile = $newConfigFile;
                                super(0);
                            }

                            @Nullable
                            public final VirtualFile invoke() {
                                return VirtualFileManager.getInstance().refreshAndFindFileByNioPath(this.$newConfigFile);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super VirtualFile> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private static final Object fillEmptyConfigFileByDefaultConfig(VirtualFile var0, Object var1_1, Continuation<? super VirtualFile> var2_2) {
        if (!(var2_2 instanceof fillEmptyConfigFileByDefaultConfig.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var2_2){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return KubernetesApiProviderKt.access$fillEmptyConfigFileByDefaultConfig(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = file;
                $continuation.label = 1;
                v0 = CoroutinesKt.writeAction((Function0)((Function0)new Function0<Unit>(file, (Object)requestor){
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ Object $requestor;
                    {
                        this.$file = $file;
                        this.$requestor = $requestor;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke() {
                        Closeable closeable = this.$file.getOutputStream(this.$requestor);
                        Throwable throwable = null;
                        try {
                            OutputStream stream = (OutputStream)closeable;
                            boolean bl = false;
                            Intrinsics.checkNotNull((Object)stream);
                            Closeable closeable2 = stream;
                            Object object = Charsets.UTF_8;
                            Writer writer = new OutputStreamWriter((OutputStream)closeable2, (Charset)object);
                            int n = 8192;
                            closeable2 = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
                            object = null;
                            try {
                                BufferedWriter writer2 = (BufferedWriter)closeable2;
                                boolean bl2 = false;
                                writer2.write(KubernetesApiProviderKt.access$getDefaultConfig$p());
                                writer = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                object = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        }
                    }
                }), (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                file = (VirtualFile)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                return file;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Map<String, Map<Object, Object>> associateByName(Map<?, ?> configuration, KubeConfigEntity entity) {
        Map entities = new LinkedHashMap();
        for (Object entityNode : KubernetesApiProviderKt.getAsListSafely(configuration, entity)) {
            String entityName;
            Map<Object, Object> entityMap = KubernetesApiProviderKt.asMapSafely(entityNode);
            if (KubernetesApiProviderKt.getAsNonBlankStringSafely(entityMap, "name") == null) continue;
            entities.put(entityName, KubernetesApiProviderKt.getAsMapSafely(entityMap, entity));
        }
        return MapsKt.toMap((Map)entities);
    }

    @NotNull
    public static final List<KubePlugin> detectNotInstalledAuthPluginsInConfig(@NotNull List<? extends Object> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        Object[] objectArray = new KubePlugin[5];
        objectArray[0] = new KubePlugin("aws-iam-authenticator", "aws-iam-authenticator", CollectionsKt.emptyList(), null, "aws-iam-authenticator", 8, null);
        Object object = new String[]{"auth", "print-access-token"};
        objectArray[1] = new KubePlugin("gcloud", "gcloud", CollectionsKt.listOf((Object[])object), null, "google-cloud-sdk", 8, null);
        object = new String[]{"account", "get-access-token"};
        objectArray[2] = new KubePlugin("az", "az", CollectionsKt.listOf((Object[])object), null, "az", 8, null);
        object = new String[]{"oidc-login", "get-token"};
        objectArray[3] = new KubePlugin("kubelogin", "kubectl", CollectionsKt.listOf((Object[])object), null, "kubectl-oidc_login", 8, null);
        objectArray[4] = new KubePlugin("dex-k8s-authenticator", "dex-k8s-authenticator", CollectionsKt.emptyList(), null, "dex-k8s-authenticator", 8, null);
        List knownPlugins = CollectionsKt.listOf((Object[])objectArray);
        List installedPlugins = new ArrayList();
        for (Object e : users) {
            List args;
            String command;
            Map exec;
            Object object2;
            Map map2 = e instanceof Map ? (Map)e : null;
            if (map2 == null) continue;
            Map userMap = map2;
            Object v = userMap.get("user");
            Map map3 = v instanceof Map ? (Map)v : null;
            if (map3 == null) continue;
            Map userExec = map3;
            Object v2 = userExec.get("exec");
            Map v4 = v2 instanceof Map ? (Map)v2 : null;
            if (v4 == null || ((object2 = (exec = v4).get("command")) instanceof String ? (String)object2 : null) == null) continue;
            command = command;
            Object v3 = exec.get("args");
            if ((v3 instanceof List ? (List)v3 : null) == null) continue;
            args = args;
            object2 = knownPlugins.iterator();
            while (object2.hasNext()) {
                KubePlugin plugin = (KubePlugin)object2.next();
                if (!Intrinsics.areEqual((Object)command, (Object)plugin.getCommand()) || !((Collection)args).containsAll((Collection)plugin.getArgs())) continue;
                installedPlugins.add(plugin);
            }
        }
        return installedPlugins;
    }

    private static final String toPath(String $this$toPath) {
        CharSequence charSequence;
        try {
            CharSequence charSequence2;
            charSequence = new URL($this$toPath).getPath();
            if (StringsKt.isBlank((CharSequence)charSequence)) {
                boolean bl = false;
                charSequence2 = null;
            } else {
                charSequence2 = charSequence;
            }
            charSequence = (String)charSequence2;
        }
        catch (MalformedURLException e) {
            LOG.warnWithDebug("Unable to parse cluster server URL: " + $this$toPath, (Throwable)e);
            charSequence = null;
        }
        return charSequence;
    }

    private static final String getAsNonBlankStringSafely(Map<?, ?> $this$getAsNonBlankStringSafely, String key2) {
        return KubernetesApiProviderKt.asNonBlankStringSafely($this$getAsNonBlankStringSafely.get(key2));
    }

    private static final Map<Object, Object> getAsMapSafely(Map<?, ?> $this$getAsMapSafely, KubeConfigEntity entity) {
        return KubernetesApiProviderKt.asMapSafely($this$getAsMapSafely.get(entity.getSingularKey()));
    }

    private static final List<Object> getAsListSafely(Map<?, ?> $this$getAsListSafely, KubeConfigEntity entity) {
        return KubernetesApiProviderKt.asListSafely($this$getAsListSafely.get(entity.getPluralKey()));
    }

    private static final String asNonBlankStringSafely(Object yamlNode) {
        String string;
        String string2 = KubernetesApiProviderKt.asStringSafely(yamlNode);
        if (string2 != null) {
            CharSequence charSequence;
            CharSequence charSequence2 = string2;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        } else {
            string = null;
        }
        return string;
    }

    private static final String asStringSafely(Object yamlNode) {
        Object object;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode;
        if (object2 == null) {
            boolean bl = false;
            object = null;
        } else if (object2 instanceof String) {
            object = yamlNode;
        } else {
            LOG.warn("Unable to parse kubeconfig node. Expected: " + String.class + ", Actual: " + yamlNode.getClass() + " \n\t" + yamlNode);
            boolean bl = false;
            object = null;
        }
        return (String)object;
    }

    private static final Map<Object, Object> asMapSafely(Object yamlNode) {
        Object object;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode;
        if (object2 == null) {
            boolean bl = false;
            object = new LinkedHashMap();
        } else if (TypeIntrinsics.isMutableMap((Object)object2)) {
            object = yamlNode;
        } else {
            LOG.warn("Unable to parse kubeconfig node. Expected: " + Map.class + ", Actual: " + yamlNode.getClass() + " \n\t" + yamlNode);
            boolean bl = false;
            object = new LinkedHashMap();
        }
        return (Map)object;
    }

    private static final List<Object> asListSafely(Object yamlNode) {
        Object object;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode;
        if (object2 == null) {
            boolean bl = false;
            object = new ArrayList();
        } else if (TypeIntrinsics.isMutableList((Object)object2)) {
            object = yamlNode;
        } else {
            LOG.warn("Unable to parse kubeconfig node. Expected: " + List.class + ", Actual: " + yamlNode.getClass() + " \n\t" + yamlNode);
            boolean bl = false;
            object = new ArrayList();
        }
        return (List)object;
    }

    private static final /* synthetic */ <T> T asTypeSafely(Object yamlNode, Function0<? extends T> typeConstructor) {
        Object object;
        boolean $i$f$asTypeSafely = false;
        Object object2 = yamlNode;
        if (object2 == null) {
            object = typeConstructor.invoke();
        } else {
            Intrinsics.reifiedOperationMarker((int)3, (String)"T");
            if (object2 instanceof Object) {
                object = yamlNode;
            } else {
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                LOG.warn("Unable to parse kubeconfig node. Expected: " + Object.class + ", Actual: " + yamlNode.getClass() + " \n\t" + yamlNode);
                object = typeConstructor.invoke();
            }
        }
        return (T)object;
    }

    @VisibleForTesting
    @NotNull
    public static final KubeConfigEx plus(@NotNull KubeConfig $this$plus, @NotNull KubeConfig other) {
        KubeConfigEx kubeConfigEx;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String currentContext = $this$plus.getCurrentContext() != null && other.getCurrentContext() == null ? $this$plus.getCurrentContext() : ($this$plus.getCurrentContext() == null && other.getCurrentContext() != null ? other.getCurrentContext() : null);
        KubeConfigEx $this$plus_u24lambda_u2416 = kubeConfigEx = new KubeConfigEx((List<? extends Object>)KubernetesApiProviderKt.plus$join($this$plus, other, (Function1<? super KubeConfig, ? extends ArrayList<Object>>)((Function1)plus.1.INSTANCE)), (List<? extends Object>)KubernetesApiProviderKt.plus$join($this$plus, other, (Function1<? super KubeConfig, ? extends ArrayList<Object>>)((Function1)plus.2.INSTANCE)), (List<? extends Object>)KubernetesApiProviderKt.plus$join($this$plus, other, (Function1<? super KubeConfig, ? extends ArrayList<Object>>)((Function1)plus.3.INSTANCE)));
        boolean bl = false;
        $this$plus_u24lambda_u2416.setContext(currentContext);
        return kubeConfigEx;
    }

    private static final String contextComparator$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final String contextComparator$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    private static final ArrayList<Object> plus$join(KubeConfig $this_plus, KubeConfig $other, Function1<? super KubeConfig, ? extends ArrayList<Object>> keySelector) {
        ArrayList<Object> result2;
        block1: {
            ArrayList it;
            result2 = new ArrayList<Object>();
            ArrayList arrayList = (ArrayList)keySelector.invoke((Object)$this_plus);
            if (arrayList != null) {
                it = arrayList;
                boolean bl = false;
                result2.addAll(it);
            }
            ArrayList arrayList2 = (ArrayList)keySelector.invoke((Object)$other);
            if (arrayList2 == null) break block1;
            it = arrayList2;
            boolean bl = false;
            result2.addAll(it);
        }
        return result2;
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ ContextsConfiguration access$parseAndValidateKubeConfiguration(VirtualFile kubeConfigFile) {
        return KubernetesApiProviderKt.parseAndValidateKubeConfiguration(kubeConfigFile);
    }

    public static final /* synthetic */ String access$getAsNonBlankStringSafely(Map $receiver, String key2) {
        return KubernetesApiProviderKt.getAsNonBlankStringSafely($receiver, key2);
    }

    public static final /* synthetic */ String access$toPath(String $receiver) {
        return KubernetesApiProviderKt.toPath($receiver);
    }

    public static final /* synthetic */ Comparator access$getContextComparator$p() {
        return contextComparator;
    }

    public static final /* synthetic */ Yaml access$createYaml() {
        return KubernetesApiProviderKt.createYaml();
    }

    public static final /* synthetic */ Map access$loadConfiguration(VirtualFile file2, Yaml yaml) {
        return KubernetesApiProviderKt.loadConfiguration(file2, yaml);
    }

    public static final /* synthetic */ List access$getAsListSafely(Map $receiver, KubeConfigEntity entity) {
        return KubernetesApiProviderKt.getAsListSafely($receiver, entity);
    }

    public static final /* synthetic */ ContextsConfiguration access$parseKubeConfiguration(Map configuration, String kubeConfigUrl) {
        return KubernetesApiProviderKt.parseKubeConfiguration(configuration, kubeConfigUrl);
    }

    public static final /* synthetic */ Map access$associateByName(Map configuration, KubeConfigEntity entity) {
        return KubernetesApiProviderKt.associateByName(configuration, entity);
    }

    public static final /* synthetic */ Object access$createEmptyConfig(Path path, Continuation $completion) {
        return KubernetesApiProviderKt.createEmptyConfig(path, (Continuation<? super VirtualFile>)$completion);
    }

    public static final /* synthetic */ String access$getDefaultConfig$p() {
        return defaultConfig;
    }

    public static final /* synthetic */ Object access$fillEmptyConfigFileByDefaultConfig(VirtualFile file2, Object requestor, Continuation $completion) {
        return KubernetesApiProviderKt.fillEmptyConfigFileByDefaultConfig(file2, requestor, (Continuation<? super VirtualFile>)$completion);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesApiProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Comparator<Object> comparator2 = Comparator.comparing(arg_0 -> KubernetesApiProviderKt.contextComparator$lambda$0(contextComparator.1.INSTANCE, arg_0)).thenComparing(arg_0 -> KubernetesApiProviderKt.contextComparator$lambda$1(contextComparator.2.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"thenComparing(...)");
        contextComparator = comparator2;
        defaultConfig = "apiVersion: v1\nkind: Config\nclusters: []\ncontexts: []\nusers: []\ncurrent-context: \"\"\npreferences: {}";
    }
}

