/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.kubernetes.KubernetesModelAccessor;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import java.util.Collection;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u001aH\u0002J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020'H\u0016J\u0014\u0010(\u001a\u00020\u00132\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0*R4\u0010\u0006\u001a(\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t \u000b*\u0012\u0012\t\u0012\u00070\b\u00a2\u0006\u0002\b\t0\n\u00a2\u0006\u0002\b\t0\u0007\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/kubernetes/SpecModificationListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "crdPaths", "", "", "Lorg/jetbrains/annotations/NotNull;", "", "kotlin.jvm.PlatformType", "modelAccessor", "Lcom/intellij/kubernetes/KubernetesModelAccessor;", "getModelAccessor", "()Lcom/intellij/kubernetes/KubernetesModelAccessor;", "modelAccessor$delegate", "Lkotlin/Lazy;", "beforeFileDeletion", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "checkFile", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "childAdded", "Lcom/intellij/psi/PsiTreeChangeEvent;", "childMoved", "childRemoved", "childReplaced", "childrenChanged", "contentsChanged", "fileCreated", "fileMoved", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "isCrdSpec", "", "processPsiTreeChange", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "update", "localSpecPaths", "", "intellij.clouds.kubernetes"})
public final class SpecModificationListener
extends PsiTreeChangeAdapter
implements VirtualFileListener {
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy modelAccessor$delegate;
    @NotNull
    private final Set<String> crdPaths;

    public SpecModificationListener(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.modelAccessor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<KubernetesModelAccessor>(this){
            final /* synthetic */ SpecModificationListener this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final KubernetesModelAccessor invoke() {
                return KubernetesModelAccessor.Companion.getInstance(SpecModificationListener.access$getProject$p(this.this$0));
            }
        }));
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this.crdPaths = set;
    }

    private final KubernetesModelAccessor getModelAccessor() {
        Lazy lazy = this.modelAccessor$delegate;
        return (KubernetesModelAccessor)lazy.getValue();
    }

    public final void update(@NotNull Collection<String> localSpecPaths) {
        Intrinsics.checkNotNullParameter(localSpecPaths, (String)"localSpecPaths");
        this.crdPaths.clear();
        this.crdPaths.addAll(localSpecPaths);
    }

    private final boolean isCrdSpec(VirtualFile file2) {
        return !file2.isDirectory() && this.crdPaths.contains(file2.getPath());
    }

    private final void checkFile(VirtualFile file2) {
        if (this.isCrdSpec(file2)) {
            this.getModelAccessor().markOutdated();
        }
    }

    public void fileCreated(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (!Intrinsics.areEqual((Object)event2.getPropertyName(), (Object)"name") || Intrinsics.areEqual((Object)event2.getOldValue(), (Object)event2.getNewValue())) {
            return;
        }
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void contentsChanged(@NotNull VirtualFileEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        VirtualFile virtualFile = event2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.checkFile(virtualFile);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        this.processPsiTreeChange(event2);
    }

    private final void processPsiTreeChange(PsiTreeChangeEvent event2) {
        PsiFile psiFile = event2.getFile();
        if (psiFile == null || (psiFile = YamlUtilKt.getVfsFile((PsiElement)psiFile)) == null) {
            return;
        }
        this.checkFile((VirtualFile)psiFile);
    }

    public static final /* synthetic */ Project access$getProject$p(SpecModificationListener $this) {
        return $this.project;
    }
}

