/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.json.JsonFileType;
import com.intellij.kubernetes.K8sYamlMappings;
import com.intellij.kubernetes.KubernetesLabelUtilKt;
import com.intellij.kubernetes.KubernetesModelAccessor;
import com.intellij.kubernetes.KubernetesResolver;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.api.settings.KubeConfig;
import com.intellij.kubernetes.model.InlinePatchType;
import com.intellij.kubernetes.model.KubernetesBasicDefinitionsKt;
import com.intellij.kubernetes.model.KubernetesLabelContainer;
import com.intellij.kubernetes.model.KubernetesModel;
import com.intellij.kubernetes.model.KubernetesModelDefinition;
import com.intellij.kubernetes.model.KustomizeInlinePatchMixin;
import com.intellij.kubernetes.model.ResourceIdentity;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Plow;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.meta.impl.YamlMetaTypeProvider;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLValue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00a8\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\tH\u0002\u001a\u0012\u0010/\u001a\u0004\u0018\u00010\u00172\b\u00100\u001a\u0004\u0018\u000101\u001a\u0012\u0010/\u001a\u0004\u0018\u00010\u00172\b\u00102\u001a\u0004\u0018\u00010\u0018\u001a\u0010\u00103\u001a\u00020-2\u0006\u00104\u001a\u000205H\u0002\u001a\u0010\u00106\u001a\u00020-2\b\u00104\u001a\u0004\u0018\u00010\t\u001a\u0010\u00107\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0002\u001a\u0010\u00108\u001a\u00020-2\b\u00104\u001a\u0004\u0018\u00010\t\u001a\u0010\u00109\u001a\u00020-2\b\u00104\u001a\u0004\u0018\u00010\t\u001a\u0010\u0010:\u001a\u00020-2\b\u0010;\u001a\u0004\u0018\u00010<\u001a\u000e\u0010=\u001a\u00020-2\u0006\u0010;\u001a\u00020<\u001a\u0012\u0010>\u001a\u00020-2\b\u00104\u001a\u0004\u0018\u00010\tH\u0007\u001a\u000e\u0010?\u001a\u00020-2\u0006\u0010@\u001a\u00020A\u001a\u0010\u0010B\u001a\u00020-2\b\u0010C\u001a\u0004\u0018\u00010D\u001a\u000e\u0010E\u001a\u00020-2\u0006\u0010@\u001a\u00020A\u001a\u0014\u0010F\u001a\u0004\u0018\u000101*\u0002052\u0006\u0010@\u001a\u00020A\u001a\u0018\u0010G\u001a\b\u0012\u0004\u0012\u0002010H*\u0002052\u0006\u0010@\u001a\u00020A\u001a\f\u0010I\u001a\u0004\u0018\u00010 *\u00020\u0018\u001a\f\u0010J\u001a\u0004\u0018\u00010 *\u000201\u001a\f\u0010J\u001a\u0004\u0018\u00010 *\u00020\u0018\u001a\u0010\u0010K\u001a\b\u0012\u0004\u0012\u00020M0L*\u000205\u001a\n\u0010N\u001a\u00020-*\u00020\u0003\u001a\n\u0010O\u001a\u00020-*\u00020\u0003\u001a \u0010\u0002\u001a\u0004\u0018\u0001HP\"\n\b\u0000\u0010P\u0018\u0001*\u00020\u0003*\u00020\u0004H\u0086\b\u00a2\u0006\u0002\u0010\u0006\u001a \u0010\u001f\u001a\u0004\u0018\u0001HP\"\n\b\u0000\u0010P\u0018\u0001*\u00020\u0003*\u00020 H\u0086\b\u00a2\u0006\u0002\u0010\"\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u001c\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u0017\u0010\u001b\u001a\u0004\u0018\u00010\b*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u0017\u0010\u001f\u001a\u0004\u0018\u00010\u0003*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u001c\u0010#\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e*\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u001a\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(*\u00020)8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010+\u00a8\u0006Q"}, d2={"resourceNameRegex", "Lkotlin/text/Regex;", "k8sMetaType", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "Lorg/jetbrains/yaml/psi/YAMLPsiElement;", "getK8sMetaType", "(Lorg/jetbrains/yaml/psi/YAMLPsiElement;)Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "k8sMetaTypeProvider", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "Lcom/intellij/psi/PsiFile;", "getK8sMetaTypeProvider", "(Lcom/intellij/psi/PsiFile;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "k8sMetaTypeProxy", "Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "Lorg/jetbrains/annotations/Nullable;", "getK8sMetaTypeProxy", "(Lorg/jetbrains/yaml/psi/YAMLPsiElement;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "k8sModel", "Lcom/intellij/kubernetes/model/KubernetesModel;", "Lcom/intellij/openapi/project/Project;", "getK8sModel", "(Lcom/intellij/openapi/project/Project;)Lcom/intellij/kubernetes/model/KubernetesModel;", "k8sResourceId", "Lcom/intellij/kubernetes/model/ResourceIdentity;", "Lorg/jetbrains/yaml/psi/YAMLMapping;", "getK8sResourceId", "(Lorg/jetbrains/yaml/psi/YAMLMapping;)Lcom/intellij/kubernetes/model/ResourceIdentity;", "metaTypeProvider", "Lcom/intellij/codeInspection/ProblemsHolder;", "getMetaTypeProvider", "(Lcom/intellij/codeInspection/ProblemsHolder;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider;", "valueK8sMetaType", "Lorg/jetbrains/yaml/psi/YAMLKeyValue;", "getValueK8sMetaType", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "valueK8sMetaTypeProxy", "getValueK8sMetaTypeProxy", "(Lorg/jetbrains/yaml/psi/YAMLKeyValue;)Lorg/jetbrains/yaml/meta/impl/YamlMetaTypeProvider$MetaTypeProxy;", "yamlPsiModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/psi/PsiManager;", "getYamlPsiModificationTracker", "(Lcom/intellij/psi/PsiManager;)Lcom/intellij/openapi/util/ModificationTracker;", "computeIsKustomization", "", "psiFile", "getDeclaredResourceId", "document", "Lorg/jetbrains/yaml/psi/YAMLDocument;", "mapping", "hasNoK8sDirective", "file", "Lorg/jetbrains/yaml/psi/YAMLFile;", "isJsonOrNonK8sFile", "isKubernetesDocument", "isKubernetesYaml", "isKustomizationPsiFile", "isKustomizationVirtualFile", "vfsFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isKustomizationYamlName", "isKustomizeStrategicMergePatch", "isMapResourceEntryNameValid", "name", "", "isNonKustomizationK8sFile", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "isResourceNameValid", "findDocumentByK8sResourceName", "findDocumentsByK8sResourceName", "", "findK8sResourceKind", "findK8sResourceObjectName", "findKustomizeStrategicMergePatchReferences", "Lcom/intellij/util/Plow;", "Lcom/intellij/psi/PsiReference;", "isKubernetesLabelContainer", "isObjectMeta", "T", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesUtil.kt\ncom/intellij/kubernetes/KubernetesUtilKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 YamlUtil.kt\ncom/intellij/kubernetes/YamlUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,278:1\n153#1:281\n162#1:282\n31#2,2:279\n31#2,2:283\n54#3:285\n56#3:286\n766#4:287\n857#4,2:288\n1#5:290\n*S KotlinDebug\n*F\n+ 1 KubernetesUtil.kt\ncom/intellij/kubernetes/KubernetesUtilKt\n*L\n155#1:281\n164#1:282\n140#1:279,2\n172#1:283,2\n212#1:285\n215#1:286\n215#1:287\n215#1:288,2\n*E\n"})
public final class KubernetesUtilKt {
    @NotNull
    private static final Regex resourceNameRegex = new Regex("[a-z0-9\\-.]*");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKubernetesYaml(@Nullable PsiFile file2) {
        if (!(file2 instanceof YAMLFile)) return false;
        if (KubeConfig.isKubeConfig(file2)) return false;
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file2), () -> KubernetesUtilKt.isKubernetesYaml$lambda$1(file2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        if ((Boolean)object == false) return false;
        return true;
    }

    private static final boolean isKubernetesDocument(YAMLDocument document) {
        return KubernetesUtilKt.getDeclaredResourceId(document) != null || KubernetesUtilKt.isKustomizationVirtualFile(YamlUtilKt.getVfsFile((PsiElement)document)) || KustomizeInlinePatchMixin.Companion.getInlinePatchTypeByInjectedPsi(document.getContainingFile()) == InlinePatchType.STRATEGIC_MERGE;
    }

    @Nullable
    public static final ResourceIdentity getDeclaredResourceId(@Nullable YAMLDocument document) {
        YAMLDocument yAMLDocument = document;
        YAMLValue yAMLValue = yAMLDocument != null ? yAMLDocument.getTopLevelValue() : null;
        YAMLMapping yAMLMapping = yAMLValue instanceof YAMLMapping ? (YAMLMapping)yAMLValue : null;
        if (yAMLMapping == null) {
            return null;
        }
        YAMLMapping topMapping = yAMLMapping;
        return KubernetesUtilKt.getDeclaredResourceId(topMapping);
    }

    @Nullable
    public static final ResourceIdentity getDeclaredResourceId(@Nullable YAMLMapping mapping) {
        if (mapping == null) {
            return null;
        }
        YAMLKeyValue yAMLKeyValue = YamlUtilKt.getKeyValueByKeyIgnoreSpaces(mapping, "kind");
        if (yAMLKeyValue == null) {
            return null;
        }
        YAMLKeyValue kindKeyVal = yAMLKeyValue;
        YAMLKeyValue yAMLKeyValue2 = YamlUtilKt.getKeyValueByKeyIgnoreSpaces(mapping, "apiVersion");
        if (yAMLKeyValue2 == null) {
            return null;
        }
        YAMLKeyValue apiVersionKeyVal = yAMLKeyValue2;
        return ResourceIdentity.Companion.create(YamlUtilKt.getEffectiveValueText(apiVersionKeyVal), YamlUtilKt.getEffectiveValueText(kindKeyVal));
    }

    public static final boolean isKustomizationPsiFile(@Nullable PsiFile file2) {
        PsiFile psiFile = file2;
        Object object = psiFile != null ? psiFile.getManager() : null;
        if (object == null) {
            return false;
        }
        PsiManager psiManager = object;
        Object object2 = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file2), () -> KubernetesUtilKt.isKustomizationPsiFile$lambda$2(file2, psiManager));
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getCachedValue(...)");
        return (Boolean)object2;
    }

    private static final boolean computeIsKustomization(PsiFile psiFile) {
        if (!(psiFile instanceof YAMLFile)) {
            return false;
        }
        if (KubernetesUtilKt.isKustomizationVirtualFile(YamlUtilKt.getVfsFile((PsiElement)psiFile))) {
            return true;
        }
        List list2 = ((YAMLFile)psiFile).getDocuments();
        ResourceIdentity resourceIdentity = KubernetesUtilKt.getDeclaredResourceId((YAMLDocument)(list2 != null ? (YAMLDocument)CollectionsKt.firstOrNull((List)list2) : null));
        if (resourceIdentity == null) {
            return false;
        }
        ResourceIdentity declaredResourceId = resourceIdentity;
        Project project2 = ((YAMLFile)psiFile).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return KubernetesModelAccessor.Companion.getInstance(project2).getModel().isKustomizeResource(declaredResourceId);
    }

    public static final boolean isKustomizationVirtualFile(@Nullable VirtualFile vfsFile) {
        return vfsFile != null && !(vfsFile instanceof VirtualFileWindow) && KubernetesUtilKt.isKustomizationYamlName(vfsFile);
    }

    public static final boolean isKustomizationYamlName(@NotNull VirtualFile vfsFile) {
        Intrinsics.checkNotNullParameter((Object)vfsFile, (String)"vfsFile");
        return StringUtil.equals((CharSequence)FileUtilRt.getNameWithoutExtension((CharSequence)vfsFile.getNameSequence()), (CharSequence)"kustomization") && FileTypeManager.getInstance().isFileOfType(vfsFile, (FileType)YAMLFileType.YML);
    }

    public static final boolean isNonKustomizationK8sFile(@Nullable PsiFileSystemItem item) {
        if (!(item instanceof YAMLFile)) {
            return false;
        }
        List list2 = ((YAMLFile)item).getDocuments();
        ResourceIdentity resourceIdentity = KubernetesUtilKt.getDeclaredResourceId((YAMLDocument)(list2 != null ? (YAMLDocument)CollectionsKt.firstOrNull((List)list2) : null));
        if (resourceIdentity == null) {
            return false;
        }
        ResourceIdentity declaredResourceId = resourceIdentity;
        Project project2 = ((YAMLFile)item).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        return !KubernetesModelAccessor.Companion.getInstance(project2).getModel().isKustomizeResource(declaredResourceId);
    }

    public static final boolean isJsonOrNonK8sFile(@Nullable PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)file2);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vfile = virtualFile;
        FileTypeManager fileTypeManager = FileTypeManagerEx.getInstance();
        return fileTypeManager.isFileOfType(vfile, (FileType)JsonFileType.INSTANCE) || YamlUtilKt.isYamlFile(vfile) && !KubernetesUtilKt.isKubernetesYaml((PsiFile)(file2 instanceof YAMLFile ? (YAMLFile)file2 : null));
    }

    @RequiresReadLock
    public static final boolean isKustomizeStrategicMergePatch(@Nullable PsiFile file2) {
        if (file2 == null) {
            return false;
        }
        if (!(file2 instanceof YAMLFile)) {
            return false;
        }
        PsiManager psiManager = ((YAMLFile)file2).getManager();
        VirtualFile vfsFile = YamlUtilKt.getVfsFile((PsiElement)file2);
        if (vfsFile instanceof VirtualFileWindow) {
            PsiFile psiFile = psiManager.findFile(((VirtualFileWindow)vfsFile).getDelegate());
            YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
            if (yAMLFile == null) {
                return false;
            }
            YAMLFile hostPsiFile = yAMLFile;
            return KubernetesUtilKt.isKustomizationPsiFile((PsiFile)hostPsiFile);
        }
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)file2), () -> KubernetesUtilKt.isKustomizeStrategicMergePatch$lambda$3(file2, psiManager));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Boolean)object;
    }

    @NotNull
    public static final Plow<PsiReference> findKustomizeStrategicMergePatchReferences(@NotNull YAMLFile $this$findKustomizeStrategicMergePatchReferences) {
        Intrinsics.checkNotNullParameter((Object)$this$findKustomizeStrategicMergePatchReferences, (String)"<this>");
        Project project2 = $this$findKustomizeStrategicMergePatchReferences.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<KubernetesResolver> serviceClass$iv = KubernetesResolver.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((KubernetesResolver)object).findKustomizeStrategicMergePatchReferences($this$findKustomizeStrategicMergePatchReferences);
    }

    public static final boolean isKubernetesLabelContainer(@NotNull YamlMetaType $this$isKubernetesLabelContainer) {
        Intrinsics.checkNotNullParameter((Object)$this$isKubernetesLabelContainer, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isKubernetesLabelContainer, (Object)KubernetesLabelContainer.INSTANCE);
    }

    public static final boolean isObjectMeta(@NotNull YamlMetaType $this$isObjectMeta) {
        Intrinsics.checkNotNullParameter((Object)$this$isObjectMeta, (String)"<this>");
        return $this$isObjectMeta instanceof KubernetesModelDefinition && Intrinsics.areEqual((Object)KubernetesBasicDefinitionsKt.getShortTypeName((KubernetesModelDefinition)$this$isObjectMeta), (Object)"ObjectMeta");
    }

    @Nullable
    public static final YamlMetaTypeProvider getMetaTypeProvider(@NotNull ProblemsHolder $this$metaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$metaTypeProvider, (String)"<this>");
        PsiFile psiFile = $this$metaTypeProvider.getFile().getViewProvider().getPsi((Language)YAMLLanguage.INSTANCE);
        return psiFile != null ? KubernetesUtilKt.getK8sMetaTypeProvider(psiFile) : null;
    }

    @Nullable
    public static final YamlMetaTypeProvider.MetaTypeProxy getK8sMetaTypeProxy(@NotNull YAMLPsiElement $this$k8sMetaTypeProxy) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sMetaTypeProxy, (String)"<this>");
        PsiFile psiFile = $this$k8sMetaTypeProxy.getContainingFile();
        return psiFile != null && (psiFile = psiFile.getOriginalFile()) != null && (psiFile = KubernetesUtilKt.getK8sMetaTypeProvider(psiFile)) != null ? psiFile.getMetaTypeProxy((PsiElement)$this$k8sMetaTypeProxy) : null;
    }

    public static final /* synthetic */ <T extends YamlMetaType> T k8sMetaType(YAMLPsiElement $this$k8sMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sMetaType, (String)"<this>");
        boolean $i$f$k8sMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getK8sMetaTypeProxy($this$k8sMetaType);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    @Nullable
    public static final YamlMetaType getK8sMetaType(@NotNull YAMLPsiElement $this$k8sMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sMetaType, (String)"<this>");
        YAMLPsiElement $this$k8sMetaType$iv = $this$k8sMetaType;
        boolean $i$f$k8sMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getK8sMetaTypeProxy($this$k8sMetaType$iv);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        if (!(object instanceof YamlMetaType)) {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final YamlMetaTypeProvider.MetaTypeProxy getValueK8sMetaTypeProxy(@NotNull YAMLKeyValue $this$valueK8sMetaTypeProxy) {
        Intrinsics.checkNotNullParameter((Object)$this$valueK8sMetaTypeProxy, (String)"<this>");
        PsiFile psiFile = $this$valueK8sMetaTypeProxy.getContainingFile();
        return psiFile != null && (psiFile = psiFile.getOriginalFile()) != null && (psiFile = KubernetesUtilKt.getK8sMetaTypeProvider(psiFile)) != null ? psiFile.getKeyValueMetaType($this$valueK8sMetaTypeProxy) : null;
    }

    public static final /* synthetic */ <T extends YamlMetaType> T valueK8sMetaType(YAMLKeyValue $this$valueK8sMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$valueK8sMetaType, (String)"<this>");
        boolean $i$f$valueK8sMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getValueK8sMetaTypeProxy($this$valueK8sMetaType);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)object;
    }

    @Nullable
    public static final YamlMetaType getValueK8sMetaType(@NotNull YAMLKeyValue $this$valueK8sMetaType) {
        Intrinsics.checkNotNullParameter((Object)$this$valueK8sMetaType, (String)"<this>");
        YAMLKeyValue $this$valueK8sMetaType$iv = $this$valueK8sMetaType;
        boolean $i$f$valueK8sMetaType = false;
        YamlMetaTypeProvider.MetaTypeProxy metaTypeProxy = KubernetesUtilKt.getValueK8sMetaTypeProxy($this$valueK8sMetaType$iv);
        Object object = metaTypeProxy != null ? metaTypeProxy.getMetaType() : null;
        if (!(object instanceof YamlMetaType)) {
            object = null;
        }
        return object;
    }

    @Nullable
    public static final YamlMetaTypeProvider getK8sMetaTypeProvider(@NotNull PsiFile $this$k8sMetaTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sMetaTypeProvider, (String)"<this>");
        if (!KubernetesUtilKt.isKubernetesYaml($this$k8sMetaTypeProvider)) {
            return null;
        }
        Project project2 = $this$k8sMetaTypeProvider.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<KubernetesModelAccessor> serviceClass$iv = KubernetesModelAccessor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((KubernetesModelAccessor)object).getMetaTypeProvider($this$k8sMetaTypeProvider);
    }

    @NotNull
    public static final KubernetesModel getK8sModel(@NotNull Project $this$k8sModel) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sModel, (String)"<this>");
        return KubernetesModelAccessor.Companion.getInstance($this$k8sModel).getModel();
    }

    @Nullable
    public static final YAMLDocument findDocumentByK8sResourceName(@NotNull YAMLFile $this$findDocumentByK8sResourceName, @NotNull String name2) {
        Object v2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findDocumentByK8sResourceName, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
            YAMLFile $this$findDocument$iv = $this$findDocumentByK8sResourceName;
            boolean $i$f$findDocument = false;
            List list2 = $this$findDocument$iv.getDocuments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDocuments(...)");
            Iterable iterable = list2;
            for (Object t : iterable) {
                YAMLDocument it = (YAMLDocument)t;
                boolean bl = false;
                YAMLKeyValue yAMLKeyValue = KubernetesUtilKt.findK8sResourceObjectName(it);
                if (!Intrinsics.areEqual((Object)(yAMLKeyValue != null ? YamlUtilKt.getEffectiveValueText(yAMLKeyValue) : null), (Object)name2)) continue;
                v2 = t;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<YAMLDocument> findDocumentsByK8sResourceName(@NotNull YAMLFile $this$findDocumentsByK8sResourceName, @NotNull String name2) {
        void $this$filterTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$findDocumentsByK8sResourceName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        YAMLFile $this$findDocuments$iv = $this$findDocumentsByK8sResourceName;
        boolean $i$f$findDocuments = false;
        List list2 = $this$findDocuments$iv.getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDocuments(...)");
        Iterable $this$filter$iv$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            YAMLDocument it = (YAMLDocument)element$iv$iv$iv;
            boolean bl = false;
            YAMLKeyValue yAMLKeyValue = KubernetesUtilKt.findK8sResourceObjectName(it);
            if (!Intrinsics.areEqual((Object)(yAMLKeyValue != null ? YamlUtilKt.getEffectiveValueText(yAMLKeyValue) : null), (Object)name2)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        return (List)destination$iv$iv$iv;
    }

    @Nullable
    public static final YAMLKeyValue findK8sResourceObjectName(@NotNull YAMLDocument $this$findK8sResourceObjectName) {
        Intrinsics.checkNotNullParameter((Object)$this$findK8sResourceObjectName, (String)"<this>");
        YAMLMapping yAMLMapping = YamlUtilKt.getTopLevelMapping($this$findK8sResourceObjectName);
        return yAMLMapping != null ? KubernetesUtilKt.findK8sResourceObjectName(yAMLMapping) : null;
    }

    @Nullable
    public static final YAMLKeyValue findK8sResourceObjectName(@NotNull YAMLMapping $this$findK8sResourceObjectName) {
        Intrinsics.checkNotNullParameter((Object)$this$findK8sResourceObjectName, (String)"<this>");
        String[] stringArray = new String[]{"metadata", "name"};
        return YamlUtilKt.findKeyValue($this$findK8sResourceObjectName, stringArray);
    }

    @Nullable
    public static final YAMLKeyValue findK8sResourceKind(@NotNull YAMLMapping $this$findK8sResourceKind) {
        Intrinsics.checkNotNullParameter((Object)$this$findK8sResourceKind, (String)"<this>");
        String[] stringArray = new String[]{"kind"};
        return YamlUtilKt.findKeyValue($this$findK8sResourceKind, stringArray);
    }

    @Nullable
    public static final ResourceIdentity getK8sResourceId(@NotNull YAMLMapping $this$k8sResourceId) {
        Intrinsics.checkNotNullParameter((Object)$this$k8sResourceId, (String)"<this>");
        return KubernetesUtilKt.getDeclaredResourceId($this$k8sResourceId);
    }

    public static final boolean isMapResourceEntryNameValid(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        return KubernetesLabelUtilKt.isLabelTextValid(name2, true);
    }

    @NotNull
    public static final ModificationTracker getYamlPsiModificationTracker(@NotNull PsiManager $this$yamlPsiModificationTracker) {
        Intrinsics.checkNotNullParameter((Object)$this$yamlPsiModificationTracker, (String)"<this>");
        ModificationTracker modificationTracker = $this$yamlPsiModificationTracker.getModificationTracker().forLanguage((Language)YAMLLanguage.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"forLanguage(...)");
        return modificationTracker;
    }

    public static final boolean isResourceNameValid(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        int n = name2.length();
        if (!(1 <= n ? n < 254 : false)) {
            return false;
        }
        if (!resourceNameRegex.matches((CharSequence)name2)) {
            return false;
        }
        return Character.isLetterOrDigit(StringsKt.first((CharSequence)name2)) && Character.isLetterOrDigit(StringsKt.last((CharSequence)name2));
    }

    private static final boolean hasNoK8sDirective(YAMLFile file2) {
        Ref.BooleanRef found2 = new Ref.BooleanRef();
        PsiTreeUtil.processElements((PsiElement)((PsiElement)file2), LeafPsiElement.class, (PsiElementProcessor)new PsiElementProcessor(found2){
            final /* synthetic */ Ref.BooleanRef $found;
            {
                this.$found = $found;
            }

            public final boolean execute(@NotNull LeafPsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (!CollectionsKt.contains((Iterable)K8sYamlMappings.INSTANCE.getNO_K8S_ANALYZED_TOKENS(), (Object)it.getNode().getElementType())) {
                    return false;
                }
                if (it instanceof PsiComment) {
                    String string = ((PsiComment)it).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                    CharSequence charSequence = string;
                    if (K8sYamlMappings.INSTANCE.getNO_K8S_DIRECTIVE_REGEX().containsMatchIn(charSequence)) {
                        this.$found.element = true;
                        return false;
                    }
                }
                return true;
            }
        });
        return found2.element;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final CachedValueProvider.Result isKubernetesYaml$lambda$1(PsiFile $file) {
        if (KubernetesUtilKt.hasNoK8sDirective((YAMLFile)$file)) ** GOTO lbl-1000
        v0 = ((YAMLFile)$file).getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getDocuments(...)");
        v1 = (YAMLDocument)CollectionsKt.firstOrNull((List)v0);
        if (v1 != null) {
            it = var3_1 = v1;
            $i$a$-takeIf-KubernetesUtilKt$isKubernetesYaml$1$value$1 = false;
            v2 /* !! */  = KubernetesUtilKt.isKubernetesDocument(it) ? var3_1 : null;
        } else {
            v2 /* !! */  = null;
        }
        if (v2 /* !! */  != null) {
            v3 = true;
        } else lbl-1000:
        // 2 sources

        {
            v3 = false;
        }
        value = v3;
        var2_5 = new Object[]{$file};
        return new CachedValueProvider.Result((Object)value, var2_5);
    }

    private static final CachedValueProvider.Result isKustomizationPsiFile$lambda$2(PsiFile $file, PsiManager $psiManager) {
        Intrinsics.checkNotNullParameter((Object)$psiManager, (String)"$psiManager");
        Object[] objectArray = new Object[]{KubernetesUtilKt.getYamlPsiModificationTracker($psiManager)};
        return new CachedValueProvider.Result((Object)KubernetesUtilKt.computeIsKustomization($file), objectArray);
    }

    private static final CachedValueProvider.Result isKustomizeStrategicMergePatch$lambda$3(PsiFile $file, PsiManager $psiManager) {
        Boolean bl = KubernetesUtilKt.findKustomizeStrategicMergePatchReferences((YAMLFile)$file).findAny() != null;
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNull((Object)$psiManager);
        objectArray[0] = KubernetesUtilKt.getYamlPsiModificationTracker($psiManager);
        return new CachedValueProvider.Result((Object)bl, objectArray);
    }
}

