/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.settings.KubernetesApiProjectSettings;
import com.intellij.kubernetes.api.settings.KubernetesApiSettings;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\tH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/kubernetes/KubernetesProjectMetricsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "AVAILABLE_CONTEXTS", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "CONFIG_FILES", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "MODELS_COUNT", "NAMESPACES_STAT", "", "WATCH_INFO", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "getGroup", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesFeatureUsagesCollectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesFeatureUsagesCollectors.kt\ncom/intellij/kubernetes/KubernetesProjectMetricsCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1549#2:113\n1620#2,3:114\n1549#2:117\n1620#2,3:118\n1#3:121\n*S KotlinDebug\n*F\n+ 1 KubernetesFeatureUsagesCollectors.kt\ncom/intellij/kubernetes/KubernetesProjectMetricsCollector\n*L\n80#1:113\n80#1:114,3\n84#1:117\n84#1:118,3\n*E\n"})
public final class KubernetesProjectMetricsCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kubernetes.project.metrics", 3, null, 4, null);
    @NotNull
    private final EventId1<Integer> MODELS_COUNT = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"apiModels.size.used", (EventField)((EventField)EventFields.RoundedInt((String)"count")), null, (int)4, null);
    @NotNull
    private final EventId1<Integer> AVAILABLE_CONTEXTS = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"available.contexts.used", (EventField)((EventField)EventFields.RoundedInt((String)"count")), null, (int)4, null);
    @NotNull
    private final EventId2<Integer, Integer> CONFIG_FILES = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"config.files.used", (EventField)((EventField)EventFields.RoundedInt((String)"settings")), (EventField)((EventField)EventFields.RoundedInt((String)"attached")), null, (int)8, null);
    @NotNull
    private final EventId2<Integer, Double> NAMESPACES_STAT = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"namespaces.count.used", (EventField)((EventField)EventFields.RoundedInt((String)"max")), (EventField)((EventField)EventFields.Double((String)"avr")), null, (int)8, null);
    @NotNull
    private final EventId3<Integer, Integer, Integer> WATCH_INFO = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"watch.info", (EventField)((EventField)EventFields.RoundedInt((String)"starts")), (EventField)((EventField)EventFields.RoundedInt((String)"stops")), (EventField)((EventField)EventFields.RoundedInt((String)"startFails")), null, (int)16, null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Set set;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Set $this$getMetrics_u24lambda_u245 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        KubernetesApiProvider apiProvider = KubernetesApiProvider.Companion.getInstance(project2);
        $this$getMetrics_u24lambda_u245.add(this.MODELS_COUNT.metric((Object)apiProvider.getApiModels$intellij_clouds_kubernetes().size()));
        $this$getMetrics_u24lambda_u245.add(this.AVAILABLE_CONTEXTS.metric((Object)apiProvider.getActualState$intellij_clouds_kubernetes().getAvailableContexts().size()));
        $this$getMetrics_u24lambda_u245.add(this.CONFIG_FILES.metric((Object)((KubernetesApiSettings.State)KubernetesApiProjectSettings.Companion.getInstance(project2).getState()).getConfigPaths().size(), (Object)((KubernetesApiProvider.PersistentState)apiProvider.getState()).getConfiguredContexts().size()));
        Iterable $this$map$iv = apiProvider.getApiModels$intellij_clouds_kubernetes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            KubernetesApiModel kubernetesApiModel = (KubernetesApiModel)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getKnownNamespaces$intellij_clouds_kubernetes().size());
        }
        List namespacesCount = (List)destination$iv$iv;
        if (!((Collection)namespacesCount).isEmpty()) {
            $this$getMetrics_u24lambda_u245.add(this.NAMESPACES_STAT.metric((Object)CollectionsKt.maxOrThrow((Iterable)namespacesCount), (Object)CollectionsKt.averageOfInt((Iterable)namespacesCount)));
        }
        Iterable $this$map$iv2 = apiProvider.getApiModels$intellij_clouds_kubernetes();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KubernetesApiModel bl2 = (KubernetesApiModel)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            collection.add(it.getWatchApiUsageStatistic$intellij_clouds_kubernetes().getRoundedSnapShot());
        }
        List watchesCount = (List)destination$iv$iv2;
        if (!((Collection)watchesCount).isEmpty()) {
            int n;
            int n2;
            int n3;
            Iterable iterable2 = watchesCount;
            EventId3<Integer, Integer, Integer> eventId3 = this.WATCH_INFO;
            collection = $this$getMetrics_u24lambda_u245;
            int n4 = 0;
            for (Object t : iterable2) {
                void it;
                List $i$f$mapTo22 = (List)t;
                n3 = n4;
                boolean bl4 = false;
                n2 = ((Number)it.get(0)).intValue();
                n4 = n3 + n2;
            }
            n3 = n4;
            iterable2 = watchesCount;
            Integer n5 = n3;
            n4 = 0;
            for (Object t : iterable2) {
                List it = (List)t;
                n2 = n4;
                boolean bl5 = false;
                n = ((Number)it.get(1)).intValue();
                n4 = n2 + n;
            }
            n2 = n4;
            iterable2 = watchesCount;
            Integer n6 = n2;
            n4 = 0;
            for (Object t : iterable2) {
                List it = (List)t;
                n = n4;
                boolean bl6 = false;
                int n7 = ((Number)it.get(2)).intValue();
                n4 = n + n7;
            }
            n = n4;
            collection.add(eventId3.metric((Object)n5, (Object)n6, (Object)n));
        }
        return SetsKt.build((Set)set);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }
}

