/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.db;

import com.intellij.clouds.kubernetes.db.KubernetesDBPortForwardingConfig;
import com.intellij.clouds.kubernetes.db.KubernetesPortForwardingDataSourceOptionProvider;
import com.intellij.clouds.kubernetes.db.KubernetesProviderForDB;
import com.intellij.database.console.JdbcDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubectlExecutor;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.view.execution.PortForwarding;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineExceptionHandler;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\nH\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesProviderForDB;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "config2Process", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/clouds/kubernetes/db/KubernetesDBPortForwardingConfig;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/execution/process/ProcessHandler;", "startPortForwardingOrGetExistingProcess", "config", "stopProcess", "", "wiseCheckForForwardingStart", "Lcom/intellij/execution/process/ProcessListener;", "future", "Companion", "intellij.clouds.kubernetes.db"})
@SourceDebugExtension(value={"SMAP\nKubernetesProviderForDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesProviderForDB.kt\ncom/intellij/clouds/kubernetes/db/KubernetesProviderForDB\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CoroutineExceptionHandler.kt\nkotlinx/coroutines/CoroutineExceptionHandlerKt\n*L\n1#1,168:1\n1#2:169\n44#3,4:170\n*S KotlinDebug\n*F\n+ 1 KubernetesProviderForDB.kt\ncom/intellij/clouds/kubernetes/db/KubernetesProviderForDB\n*L\n91#1:170,4\n*E\n"})
public final class KubernetesProviderForDB {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final ConcurrentHashMap<KubernetesDBPortForwardingConfig, CompletableFuture<ProcessHandler>> config2Process;

    public KubernetesProviderForDB(@NotNull Project project2, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project2;
        this.coroutineScope = coroutineScope;
        this.config2Process = new ConcurrentHashMap();
        SimpleMessageBusConnection mbConnection = this.project.getMessageBus().connect(this.coroutineScope);
        Topic topic = JdbcDriverManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        mbConnection.subscribe(topic, (Object)new JdbcDriverManager.Listener(){

            public void onTerminated(@NotNull LocalDataSource dataSource, @Nullable ConsoleRunConfiguration configuration) {
                Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
                KubernetesDBPortForwardingConfig config2 = KubernetesPortForwardingDataSourceOptionProvider.Companion.loadConfig(dataSource);
                this.stopProcess(config2);
            }
        });
    }

    @NotNull
    public final CompletableFuture<ProcessHandler> startPortForwardingOrGetExistingProcess(@NotNull KubernetesDBPortForwardingConfig config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        CompletableFuture<ProcessHandler> newProcessFuture = new CompletableFuture<ProcessHandler>();
        int attemptCount = 0;
        boolean initNewProcess = false;
        while (!initNewProcess && attemptCount < 2) {
            block7: {
                ++attemptCount;
                CompletableFuture<ProcessHandler> existingProcessFuture = this.config2Process.putIfAbsent(config2, newProcessFuture);
                if (existingProcessFuture != null) {
                    try {
                        ProcessHandler process;
                        ProcessHandler processHandler = process = (ProcessHandler)existingProcessFuture.getNow(null);
                        boolean bl = processHandler != null ? processHandler.isProcessTerminated() : false;
                        if (bl) {
                            if (!this.config2Process.replace(config2, existingProcessFuture, newProcessFuture)) {
                                CompletableFuture<ProcessHandler> completableFuture = this.config2Process.get(config2);
                                if (completableFuture == null) continue;
                                return completableFuture;
                            }
                            break block7;
                        }
                        return existingProcessFuture;
                    }
                    catch (Throwable e) {
                        if (this.config2Process.replace(config2, existingProcessFuture, newProcessFuture)) break block7;
                        CompletableFuture<ProcessHandler> completableFuture = this.config2Process.get(config2);
                        if (completableFuture == null) continue;
                        return completableFuture;
                    }
                }
            }
            initNewProcess = true;
        }
        if (!initNewProcess) {
            throw new RuntimeException("Can't create new process db connection: " + config2);
        }
        KubernetesDBPortForwardingConfig $this$startPortForwardingOrGetExistingProcess_u24lambda_u240 = config2;
        boolean bl = false;
        Context context = $this$startPortForwardingOrGetExistingProcess_u24lambda_u240.getContext(KubernetesApiProvider.Companion.getInstance(this.project));
        Intrinsics.checkNotNull((Object)context);
        Context context2 = context;
        String string = config2.getNamespace();
        Intrinsics.checkNotNull((Object)string);
        String namespace = string;
        KubernetesEntity<?, ?> kubernetesEntity = config2.getEntity();
        Intrinsics.checkNotNull(kubernetesEntity);
        KubernetesEntity<?, ?> entity = kubernetesEntity;
        String string2 = config2.getResource();
        Intrinsics.checkNotNull((Object)string2);
        String resource = string2;
        String string3 = config2.getHostPort();
        Intrinsics.checkNotNull((Object)string3);
        String string4 = config2.getContainerPort();
        Intrinsics.checkNotNull((Object)string4);
        String mapping = string3 + ":" + string4;
        boolean $i$f$CoroutineExceptionHandler = false;
        CoroutineExceptionHandler.Key key2 = CoroutineExceptionHandler.Key;
        CoroutineExceptionHandler handler = new CoroutineExceptionHandler(key2, newProcessFuture){
            final /* synthetic */ CompletableFuture $newProcessFuture$inlined;
            {
                this.$newProcessFuture$inlined = completableFuture;
                super((CoroutineContext.Key)$super_call_param$1);
            }

            public void handleException(@NotNull CoroutineContext context, @NotNull Throwable exception) {
                Throwable exception2 = exception;
                boolean bl = false;
                this.$newProcessFuture$inlined.completeExceptionally(exception2);
            }
        };
        CompletableFuture<Unit> connectionEstablishedForNewProcess = new CompletableFuture<Unit>();
        ProcessListener listener = this.wiseCheckForForwardingStart(connectionEstablishedForNewProcess);
        BuildersKt.async$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)handler), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Integer>, Object>(this, context2, entity, namespace, resource, mapping, listener, connectionEstablishedForNewProcess, newProcessFuture, null){
            int label;
            final /* synthetic */ KubernetesProviderForDB this$0;
            final /* synthetic */ Context $context;
            final /* synthetic */ KubernetesEntity<?, ?> $entity;
            final /* synthetic */ String $namespace;
            final /* synthetic */ String $resource;
            final /* synthetic */ String $mapping;
            final /* synthetic */ ProcessListener $listener;
            final /* synthetic */ CompletableFuture<Unit> $connectionEstablishedForNewProcess;
            final /* synthetic */ CompletableFuture<ProcessHandler> $newProcessFuture;
            {
                this.this$0 = $receiver;
                this.$context = $context;
                this.$entity = $entity;
                this.$namespace = $namespace;
                this.$resource = $resource;
                this.$mapping = $mapping;
                this.$listener = $listener;
                this.$connectionEstablishedForNewProcess = $connectionEstablishedForNewProcess;
                this.$newProcessFuture = $newProcessFuture;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = KubectlExecutor.Companion.getInstanceAsync(KubernetesProviderForDB.access$getProject$p(this.this$0), (Continuation<? super KubectlExecutor>)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((KubectlExecutor)v0).forwardPortsToPod(this.$context, this.$entity, this.$namespace, this.$resource, new PortForwarding(CollectionsKt.listOf((Object)"localhost"), CollectionsKt.listOf((Object)this.$mapping)), (Function1<? super ProcessHandler, Unit>)((Function1)new Function1<ProcessHandler, Unit>(this.$listener, this.$connectionEstablishedForNewProcess, this.$newProcessFuture){
                            final /* synthetic */ ProcessListener $listener;
                            final /* synthetic */ CompletableFuture<Unit> $connectionEstablishedForNewProcess;
                            final /* synthetic */ CompletableFuture<ProcessHandler> $newProcessFuture;
                            {
                                this.$listener = $listener;
                                this.$connectionEstablishedForNewProcess = $connectionEstablishedForNewProcess;
                                this.$newProcessFuture = $newProcessFuture;
                                super(1);
                            }

                            public final void invoke(@NotNull ProcessHandler process) {
                                Intrinsics.checkNotNullParameter((Object)process, (String)"process");
                                process.addProcessListener(this.$listener);
                                this.$connectionEstablishedForNewProcess.orTimeout(5L, TimeUnit.SECONDS).handle((arg_0, arg_1) -> startPortForwardingOrGetExistingProcess.1.invoke$lambda$0((Function2)new Function2<Unit, Throwable, Boolean>(this.$newProcessFuture, process){
                                    final /* synthetic */ CompletableFuture<ProcessHandler> $newProcessFuture;
                                    final /* synthetic */ ProcessHandler $process;
                                    {
                                        this.$newProcessFuture = $newProcessFuture;
                                        this.$process = $process;
                                        super(2);
                                    }

                                    public final Boolean invoke(Unit unit, Throwable throwable) {
                                        return throwable == null ? this.$newProcessFuture.complete(this.$process) : this.$newProcessFuture.completeExceptionally(throwable);
                                    }
                                }, arg_0, arg_1));
                            }

                            private static final Boolean invoke$lambda$0(Function2 $tmp0, Object p0, Throwable p1) {
                                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                                return (Boolean)$tmp0.invoke(p0, (Object)p1);
                            }
                        }), (Continuation<? super Integer>)((Continuation)this));
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Integer> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        return newProcessFuture;
    }

    private final void stopProcess(KubernetesDBPortForwardingConfig config2) {
        block0: {
            CompletableFuture<ProcessHandler> completableFuture = this.config2Process.remove(config2);
            if (completableFuture == null) break block0;
            completableFuture.thenAccept(arg_0 -> KubernetesProviderForDB.stopProcess$lambda$2(stopProcess.1.INSTANCE, arg_0));
        }
    }

    private final ProcessListener wiseCheckForForwardingStart(CompletableFuture<Unit> future) {
        return new ProcessListener(future){
            @NotNull
            private final StringBuilder output;
            @NotNull
            private final StringBuilder error;
            final /* synthetic */ CompletableFuture<Unit> $future;
            {
                this.$future = $future;
                this.output = new StringBuilder();
                this.error = new StringBuilder();
            }

            @NotNull
            public final StringBuilder getOutput() {
                return this.output;
            }

            @NotNull
            public final StringBuilder getError() {
                return this.error;
            }

            private final void completeFutureWithError() {
                CharSequence charSequence;
                CharSequence charSequence2;
                CompletableFuture<Unit> completableFuture;
                CompletableFuture<Unit> completableFuture2 = this.$future;
                CharSequence charSequence3 = this.error;
                if (StringsKt.isBlank((CharSequence)charSequence3)) {
                    completableFuture = completableFuture2;
                    boolean bl = false;
                    charSequence2 = "empty output";
                    completableFuture2 = completableFuture;
                } else {
                    charSequence2 = charSequence3;
                }
                charSequence3 = this.output;
                if (StringsKt.isBlank((CharSequence)charSequence3)) {
                    CharSequence charSequence4 = charSequence2;
                    completableFuture = completableFuture2;
                    boolean bl = false;
                    String string = "empty output";
                    completableFuture2 = completableFuture;
                    charSequence2 = charSequence4;
                    charSequence = string;
                } else {
                    charSequence = charSequence3;
                }
                String string = "Problem during starting port forwarding process. \nError output: " + charSequence2 + ". \nGeneral output: " + charSequence;
                completableFuture2.completeExceptionally(new RuntimeException(string));
            }

            public void processTerminated(@NotNull ProcessEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                this.completeFutureWithError();
            }

            public void processWillTerminate(@NotNull ProcessEvent event2, boolean willBeDestroyed) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                this.completeFutureWithError();
            }

            public void onTextAvailable(@NotNull ProcessEvent event2, @NotNull Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (Intrinsics.areEqual(outputType, (Object)ProcessOutputType.STDERR)) {
                    this.error.append(event2.getText());
                } else {
                    this.output.append(event2.getText());
                    if (StringsKt.contains$default((CharSequence)this.output, (CharSequence)"Forwarding", (boolean)false, (int)2, null)) {
                        this.$future.complete(Unit.INSTANCE);
                    }
                }
            }

            public void processNotStarted() {
                this.completeFutureWithError();
            }
        };
    }

    private static final void stopProcess$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(KubernetesProviderForDB $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/clouds/kubernetes/db/KubernetesProviderForDB$Companion;", "", "()V", "getInstance", "Lcom/intellij/clouds/kubernetes/db/KubernetesProviderForDB;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.kubernetes.db"})
    @SourceDebugExtension(value={"SMAP\nKubernetesProviderForDB.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesProviderForDB.kt\ncom/intellij/clouds/kubernetes/db/KubernetesProviderForDB$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,168:1\n31#2,2:169\n*S KotlinDebug\n*F\n+ 1 KubernetesProviderForDB.kt\ncom/intellij/clouds/kubernetes/db/KubernetesProviderForDB$Companion\n*L\n32#1:169,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KubernetesProviderForDB getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<KubernetesProviderForDB> serviceClass$iv = KubernetesProviderForDB.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (KubernetesProviderForDB)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

