/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.suggesters;

import com.intellij.lang.Language;
import com.intellij.xdebugger.XSourcePosition;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.NoSuggestion;
import training.featuresSuggester.Suggestion;
import training.featuresSuggester.actions.Action;
import training.featuresSuggester.actions.BreakpointAddedAction;
import training.featuresSuggester.actions.BreakpointRemovedAction;
import training.featuresSuggester.actions.DebugSessionPausedAction;
import training.featuresSuggester.suggesters.AbstractFeatureSuggester;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R$\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f0\u0004\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006\u001f"}, d2={"Ltraining/featuresSuggester/suggesters/RunToCursorSuggester;", "Ltraining/featuresSuggester/suggesters/AbstractFeatureSuggester;", "()V", "id", "", "getId", "()Ljava/lang/String;", "languages", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/util/NlsSafe;", "getLanguages", "()Ljava/util/List;", "message", "getMessage", "minSuggestingIntervalDays", "", "getMinSuggestingIntervalDays", "()I", "suggestingActionDisplayName", "getSuggestingActionDisplayName", "suggestingActionId", "getSuggestingActionId", "suggestingDocUrl", "getSuggestingDocUrl", "getSuggestion", "Ltraining/featuresSuggester/Suggestion;", "action", "Ltraining/featuresSuggester/actions/Action;", "Companion", "State", "intellij.featuresTrainer"})
public final class RunToCursorSuggester
extends AbstractFeatureSuggester {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String suggestingActionDisplayName = FeatureSuggesterBundle.INSTANCE.message("run.to.cursor.name", new Object[0]);
    @NotNull
    private final String message = FeatureSuggesterBundle.INSTANCE.message("run.to.cursor.message", new Object[0]);
    @NotNull
    private final String suggestingActionId;
    @NotNull
    private final String suggestingDocUrl;
    private final int minSuggestingIntervalDays;
    @NotNull
    private final List<String> languages = CollectionsKt.listOf((Object)Language.ANY.getID());
    public static final long MAX_TIME_MILLIS_BETWEEN_ACTIONS = 5000L;

    public RunToCursorSuggester() {
        this.id = "Run to cursor";
        this.suggestingActionId = "RunToCursor";
        this.suggestingDocUrl = "https://www.jetbrains.com/help/idea/stepping-through-the-program.html#run-to-cursor";
        this.minSuggestingIntervalDays = 30;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getSuggestingActionDisplayName() {
        return this.suggestingActionDisplayName;
    }

    @Override
    @NotNull
    protected String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    protected String getSuggestingActionId() {
        return this.suggestingActionId;
    }

    @Override
    @NotNull
    protected String getSuggestingDocUrl() {
        return this.suggestingDocUrl;
    }

    @Override
    public int getMinSuggestingIntervalDays() {
        return this.minSuggestingIntervalDays;
    }

    @Override
    @NotNull
    public List<String> getLanguages() {
        return this.languages;
    }

    @Override
    @NotNull
    public Suggestion getSuggestion(@NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Action action3 = action2;
        if (action3 instanceof DebugSessionPausedAction) {
            if (State.INSTANCE.getDebugSessionPaused() && XSourcePosition.isOnTheSameLine((XSourcePosition)((DebugSessionPausedAction)action2).getPosition(), (XSourcePosition)State.INSTANCE.getAddedBreakpointPosition())) {
                State.INSTANCE.setPausedOnBreakpoint(true);
            } else {
                State.INSTANCE.reset();
                State.INSTANCE.setDebugSessionPaused(true);
            }
        } else if (action3 instanceof BreakpointAddedAction) {
            if (!State.INSTANCE.isBreakpointAdded()) {
                State state;
                State $this$getSuggestion_u24lambda_u240 = state = State.INSTANCE;
                boolean bl = false;
                $this$getSuggestion_u24lambda_u240.setAddedBreakpointPosition(((BreakpointAddedAction)action2).getPosition());
                $this$getSuggestion_u24lambda_u240.setBreakpointAddedTimeMillis(action2.getTimeMillis());
            } else {
                State.INSTANCE.reset();
            }
        } else if (action3 instanceof BreakpointRemovedAction) {
            if (State.INSTANCE.isPausedOnBreakpoint() && XSourcePosition.isOnTheSameLine((XSourcePosition)((BreakpointRemovedAction)action2).getPosition(), (XSourcePosition)State.INSTANCE.getAddedBreakpointPosition()) && !State.INSTANCE.isOutOfDate(action2.getTimeMillis())) {
                State.INSTANCE.reset();
                return this.createSuggestion();
            }
            State.INSTANCE.reset();
        }
        return NoSuggestion.INSTANCE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ltraining/featuresSuggester/suggesters/RunToCursorSuggester$Companion;", "", "()V", "MAX_TIME_MILLIS_BETWEEN_ACTIONS", "", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\nJ\u0006\u0010\u001a\u001a\u00020\u001bR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014\u00a8\u0006\u001c"}, d2={"Ltraining/featuresSuggester/suggesters/RunToCursorSuggester$State;", "", "()V", "addedBreakpointPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getAddedBreakpointPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "setAddedBreakpointPosition", "(Lcom/intellij/xdebugger/XSourcePosition;)V", "breakpointAddedTimeMillis", "", "getBreakpointAddedTimeMillis", "()J", "setBreakpointAddedTimeMillis", "(J)V", "debugSessionPaused", "", "getDebugSessionPaused", "()Z", "setDebugSessionPaused", "(Z)V", "isBreakpointAdded", "isPausedOnBreakpoint", "setPausedOnBreakpoint", "isOutOfDate", "breakpointRemovedTimeMillis", "reset", "", "intellij.featuresTrainer"})
    private static final class State {
        @NotNull
        public static final State INSTANCE = new State();
        private static boolean debugSessionPaused;
        @Nullable
        private static XSourcePosition addedBreakpointPosition;
        private static long breakpointAddedTimeMillis;
        private static boolean isPausedOnBreakpoint;

        private State() {
        }

        public final boolean getDebugSessionPaused() {
            return debugSessionPaused;
        }

        public final void setDebugSessionPaused(boolean bl) {
            debugSessionPaused = bl;
        }

        @Nullable
        public final XSourcePosition getAddedBreakpointPosition() {
            return addedBreakpointPosition;
        }

        public final void setAddedBreakpointPosition(@Nullable XSourcePosition xSourcePosition) {
            addedBreakpointPosition = xSourcePosition;
        }

        public final long getBreakpointAddedTimeMillis() {
            return breakpointAddedTimeMillis;
        }

        public final void setBreakpointAddedTimeMillis(long l) {
            breakpointAddedTimeMillis = l;
        }

        public final boolean isPausedOnBreakpoint() {
            return isPausedOnBreakpoint;
        }

        public final void setPausedOnBreakpoint(boolean bl) {
            isPausedOnBreakpoint = bl;
        }

        public final boolean isBreakpointAdded() {
            return addedBreakpointPosition != null;
        }

        public final boolean isOutOfDate(long breakpointRemovedTimeMillis) {
            return breakpointRemovedTimeMillis - breakpointAddedTimeMillis > 5000L;
        }

        public final void reset() {
            debugSessionPaused = false;
            addedBreakpointPosition = null;
            breakpointAddedTimeMillis = 0L;
            isPausedOnBreakpoint = false;
        }
    }
}

