/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.fixture;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.ComponentFinder;
import org.assertj.swing.core.ComponentFoundCondition;
import org.assertj.swing.core.ComponentLookupScope;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.GenericTypeMatcher;
import org.assertj.swing.core.NameMatcher;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.TypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.ComponentDriver;
import org.assertj.swing.fixture.AbstractComponentFixture;
import org.assertj.swing.fixture.ComponentContainerFixture;
import org.assertj.swing.fixture.ComponentFixtureExtension;
import org.assertj.swing.fixture.DialogFixture;
import org.assertj.swing.fixture.JButtonFixture;
import org.assertj.swing.fixture.JCheckBoxFixture;
import org.assertj.swing.fixture.JComboBoxFixture;
import org.assertj.swing.fixture.JFileChooserFixture;
import org.assertj.swing.fixture.JInternalFrameFixture;
import org.assertj.swing.fixture.JLabelFixture;
import org.assertj.swing.fixture.JListFixture;
import org.assertj.swing.fixture.JMenuItemFinder;
import org.assertj.swing.fixture.JMenuItemFixture;
import org.assertj.swing.fixture.JOptionPaneFixture;
import org.assertj.swing.fixture.JPanelFixture;
import org.assertj.swing.fixture.JProgressBarFixture;
import org.assertj.swing.fixture.JRadioButtonFixture;
import org.assertj.swing.fixture.JScrollBarFixture;
import org.assertj.swing.fixture.JScrollPaneFixture;
import org.assertj.swing.fixture.JSliderFixture;
import org.assertj.swing.fixture.JSpinnerFixture;
import org.assertj.swing.fixture.JSplitPaneFixture;
import org.assertj.swing.fixture.JTabbedPaneFixture;
import org.assertj.swing.fixture.JTableFixture;
import org.assertj.swing.fixture.JTextComponentFixture;
import org.assertj.swing.fixture.JToggleButtonFixture;
import org.assertj.swing.fixture.JToolBarFixture;
import org.assertj.swing.fixture.JTreeFixture;
import org.assertj.swing.timing.Condition;
import org.assertj.swing.timing.Pause;
import org.assertj.swing.timing.Timeout;

public abstract class AbstractContainerFixture<S, C extends Container, D extends ComponentDriver>
extends AbstractComponentFixture<S, C, D>
implements ComponentContainerFixture {
    private static final Timeout DEFAULT_DIALOG_LOOKUP_TIMEOUT = Timeout.timeout();
    private final JMenuItemFinder menuItemFinder;

    public AbstractContainerFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull Class<? extends C> type2) {
        super(selfType, robot, type2);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target());
    }

    public AbstractContainerFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nullable String name, @Nonnull Class<? extends C> type2) {
        super(selfType, robot, name, type2);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target());
    }

    public AbstractContainerFixture(@Nonnull Class<S> selfType, @Nonnull Robot robot, @Nonnull C target) {
        super(selfType, robot, target);
        this.menuItemFinder = new JMenuItemFinder(robot, (Container)this.target());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JButtonFixture button() {
        return new JButtonFixture(this.robot(), this.findByType(JButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JButtonFixture button(@Nonnull GenericTypeMatcher<? extends JButton> matcher2) {
        return new JButtonFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JButtonFixture button(@Nullable String name) {
        return new JButtonFixture(this.robot(), this.findByName(name, JButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JCheckBoxFixture checkBox() {
        return new JCheckBoxFixture(this.robot(), this.findByType(JCheckBox.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JCheckBoxFixture checkBox(@Nonnull GenericTypeMatcher<? extends JCheckBox> matcher2) {
        return new JCheckBoxFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JCheckBoxFixture checkBox(@Nullable String name) {
        return new JCheckBoxFixture(this.robot(), this.findByName(name, JCheckBox.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JComboBoxFixture comboBox() {
        return new JComboBoxFixture(this.robot(), this.findByType(JComboBox.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JComboBoxFixture comboBox(@Nonnull GenericTypeMatcher<? extends JComboBox> matcher2) {
        return new JComboBoxFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JComboBoxFixture comboBox(@Nullable String name) {
        return new JComboBoxFixture(this.robot(), this.findByName(name, JComboBox.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog() {
        return this.dialog(this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nonnull Timeout timeout) {
        TypeMatcher matcher2 = new TypeMatcher(Dialog.class, this.requireShowing());
        return this.findDialog(matcher2, timeout);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nonnull GenericTypeMatcher<? extends Dialog> matcher2) {
        return this.dialog(matcher2, this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nonnull GenericTypeMatcher<? extends Dialog> matcher2, @Nonnull Timeout timeout) {
        return this.findDialog(matcher2, timeout);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nullable String name) {
        return this.dialog(name, this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public DialogFixture dialog(@Nullable String name, @Nonnull Timeout timeout) {
        NameMatcher matcher2 = new NameMatcher(name, Dialog.class, this.requireShowing());
        return this.findDialog(matcher2, timeout);
    }

    @Nonnull
    private DialogFixture findDialog(@Nonnull ComponentMatcher matcher2, @Nonnull Timeout timeout) {
        String description = "dialog to be found using matcher " + matcher2;
        ComponentFoundCondition condition = new ComponentFoundCondition(description, this.robot().finder(), matcher2);
        Pause.pause((Condition)condition, timeout);
        Dialog dialog2 = (Dialog)condition.found();
        return new DialogFixture(this.robot(), Preconditions.checkNotNull(dialog2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser() {
        return this.fileChooser(this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nonnull Timeout timeout) {
        TypeMatcher matcher2 = new TypeMatcher(JFileChooser.class, this.requireShowing());
        return this.findFileChooser(matcher2, timeout);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nonnull GenericTypeMatcher<? extends JFileChooser> matcher2) {
        return this.fileChooser(matcher2, this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nonnull GenericTypeMatcher<? extends JFileChooser> matcher2, @Nonnull Timeout timeout) {
        return this.findFileChooser(matcher2, timeout);
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nullable String name) {
        return new JFileChooserFixture(this.robot(), this.findByName(name, JFileChooser.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JFileChooserFixture fileChooser(@Nullable String name, @Nonnull Timeout timeout) {
        NameMatcher matcher2 = new NameMatcher(name, JFileChooser.class, this.requireShowing());
        return this.findFileChooser(matcher2, timeout);
    }

    @Nonnull
    private JFileChooserFixture findFileChooser(@Nonnull ComponentMatcher matcher2, @Nonnull Timeout timeout) {
        String description = "file chooser to be found using matcher " + matcher2;
        ComponentFoundCondition condition = new ComponentFoundCondition(description, this.robot().finder(), matcher2);
        Pause.pause((Condition)condition, timeout);
        JFileChooser fileChooser = (JFileChooser)condition.found();
        return new JFileChooserFixture(this.robot(), Preconditions.checkNotNull(fileChooser));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JInternalFrameFixture internalFrame() {
        return new JInternalFrameFixture(this.robot(), this.findByType(JInternalFrame.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JInternalFrameFixture internalFrame(@Nonnull GenericTypeMatcher<? extends JInternalFrame> matcher2) {
        return new JInternalFrameFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JInternalFrameFixture internalFrame(@Nullable String name) {
        return new JInternalFrameFixture(this.robot(), this.findByName(name, JInternalFrame.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JLabelFixture label() {
        return new JLabelFixture(this.robot(), this.findByType(JLabel.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JLabelFixture label(@Nonnull GenericTypeMatcher<? extends JLabel> matcher2) {
        return new JLabelFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JLabelFixture label(@Nullable String name) {
        return new JLabelFixture(this.robot(), this.findByName(name, JLabel.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JListFixture list() {
        return new JListFixture(this.robot(), this.findByType(JList.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JListFixture list(@Nonnull GenericTypeMatcher<? extends JList> matcher2) {
        return new JListFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JListFixture list(@Nullable String name) {
        return new JListFixture(this.robot(), this.findByName(name, JList.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JMenuItemFixture menuItemWithPath(String ... path) {
        return new JMenuItemFixture(this.robot(), this.menuItemFinder.menuItemWithPath(path));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JMenuItemFixture menuItem(@Nullable String name) {
        boolean requireShowing = ComponentLookupScope.SHOWING_ONLY.equals((Object)this.robot().settings().componentLookupScope());
        return new JMenuItemFixture(this.robot(), this.finder().findByName((Container)this.target(), name, JMenuItem.class, requireShowing));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JMenuItemFixture menuItem(@Nonnull GenericTypeMatcher<? extends JMenuItem> matcher2) {
        return new JMenuItemFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JOptionPaneFixture optionPane() {
        return this.optionPane(this.defaultDialogLookupTimeout());
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JOptionPaneFixture optionPane(@Nonnull Timeout timeout) {
        TypeMatcher matcher2 = new TypeMatcher(JOptionPane.class, this.requireShowing());
        String description = "option pane to be found using matcher " + matcher2;
        ComponentFoundCondition condition = new ComponentFoundCondition(description, this.robot().finder(), (ComponentMatcher)matcher2);
        Pause.pause((Condition)condition, timeout);
        JOptionPane optionPane = (JOptionPane)condition.found();
        return new JOptionPaneFixture(this.robot(), Preconditions.checkNotNull(optionPane));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPanelFixture panel() {
        return new JPanelFixture(this.robot(), this.findByType(JPanel.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPanelFixture panel(@Nonnull GenericTypeMatcher<? extends JPanel> matcher2) {
        return new JPanelFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JPanelFixture panel(@Nullable String name) {
        return new JPanelFixture(this.robot(), this.findByName(name, JPanel.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JProgressBarFixture progressBar() {
        return new JProgressBarFixture(this.robot(), this.findByType(JProgressBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JProgressBarFixture progressBar(@Nonnull GenericTypeMatcher<? extends JProgressBar> matcher2) {
        return new JProgressBarFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JProgressBarFixture progressBar(@Nullable String name) {
        return new JProgressBarFixture(this.robot(), this.findByName(name, JProgressBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JRadioButtonFixture radioButton() {
        return new JRadioButtonFixture(this.robot(), this.findByType(JRadioButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JRadioButtonFixture radioButton(@Nonnull GenericTypeMatcher<? extends JRadioButton> matcher2) {
        return new JRadioButtonFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JRadioButtonFixture radioButton(@Nullable String name) {
        return new JRadioButtonFixture(this.robot(), this.findByName(name, JRadioButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollBarFixture scrollBar() {
        return new JScrollBarFixture(this.robot(), this.findByType(JScrollBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollBarFixture scrollBar(@Nonnull GenericTypeMatcher<? extends JScrollBar> matcher2) {
        return new JScrollBarFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollBarFixture scrollBar(@Nullable String name) {
        return new JScrollBarFixture(this.robot(), this.findByName(name, JScrollBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollPaneFixture scrollPane() {
        return new JScrollPaneFixture(this.robot(), this.findByType(JScrollPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollPaneFixture scrollPane(@Nonnull GenericTypeMatcher<? extends JScrollPane> matcher2) {
        return new JScrollPaneFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JScrollPaneFixture scrollPane(@Nullable String name) {
        return new JScrollPaneFixture(this.robot(), this.findByName(name, JScrollPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSliderFixture slider() {
        return new JSliderFixture(this.robot(), this.findByType(JSlider.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSliderFixture slider(@Nonnull GenericTypeMatcher<? extends JSlider> matcher2) {
        return new JSliderFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSliderFixture slider(@Nullable String name) {
        return new JSliderFixture(this.robot(), this.findByName(name, JSlider.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSpinnerFixture spinner() {
        return new JSpinnerFixture(this.robot(), this.findByType(JSpinner.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSpinnerFixture spinner(@Nonnull GenericTypeMatcher<? extends JSpinner> matcher2) {
        return new JSpinnerFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSpinnerFixture spinner(@Nullable String name) {
        return new JSpinnerFixture(this.robot(), this.findByName(name, JSpinner.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSplitPaneFixture splitPane() {
        return new JSplitPaneFixture(this.robot(), this.findByType(JSplitPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSplitPaneFixture splitPane(@Nonnull GenericTypeMatcher<? extends JSplitPane> matcher2) {
        return new JSplitPaneFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JSplitPaneFixture splitPane(@Nullable String name) {
        return new JSplitPaneFixture(this.robot(), this.findByName(name, JSplitPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTabbedPaneFixture tabbedPane() {
        return new JTabbedPaneFixture(this.robot(), this.findByType(JTabbedPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTabbedPaneFixture tabbedPane(@Nonnull GenericTypeMatcher<? extends JTabbedPane> matcher2) {
        return new JTabbedPaneFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTabbedPaneFixture tabbedPane(@Nullable String name) {
        return new JTabbedPaneFixture(this.robot(), this.findByName(name, JTabbedPane.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTableFixture table() {
        return new JTableFixture(this.robot(), this.findByType(JTable.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTableFixture table(@Nonnull GenericTypeMatcher<? extends JTable> matcher2) {
        return new JTableFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTableFixture table(@Nullable String name) {
        return new JTableFixture(this.robot(), this.findByName(name, JTable.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTextComponentFixture textBox() {
        return new JTextComponentFixture(this.robot(), this.findByType(JTextComponent.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTextComponentFixture textBox(@Nonnull GenericTypeMatcher<? extends JTextComponent> matcher2) {
        return new JTextComponentFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTextComponentFixture textBox(@Nullable String name) {
        return new JTextComponentFixture(this.robot(), this.findByName(name, JTextComponent.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToggleButtonFixture toggleButton() {
        return new JToggleButtonFixture(this.robot(), this.findByType(JToggleButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToggleButtonFixture toggleButton(@Nonnull GenericTypeMatcher<? extends JToggleButton> matcher2) {
        return new JToggleButtonFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToggleButtonFixture toggleButton(@Nullable String name) {
        return new JToggleButtonFixture(this.robot(), this.findByName(name, JToggleButton.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToolBarFixture toolBar() {
        return new JToolBarFixture(this.robot(), this.findByType(JToolBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToolBarFixture toolBar(@Nonnull GenericTypeMatcher<? extends JToolBar> matcher2) {
        return new JToolBarFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JToolBarFixture toolBar(@Nullable String name) {
        return new JToolBarFixture(this.robot(), this.findByName(name, JToolBar.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTreeFixture tree() {
        return new JTreeFixture(this.robot(), this.findByType(JTree.class));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTreeFixture tree(@Nonnull GenericTypeMatcher<? extends JTree> matcher2) {
        return new JTreeFixture(this.robot(), this.find(matcher2));
    }

    @Override
    @Nonnull
    @RunsInEDT
    public JTreeFixture tree(@Nullable String name) {
        return new JTreeFixture(this.robot(), this.findByName(name, JTree.class));
    }

    @Nonnull
    protected final <T extends Component> T findByType(@Nonnull Class<T> type2) {
        return this.finder().findByType((Container)this.target(), type2, this.requireShowing());
    }

    @Nonnull
    protected final <T extends Component> T findByName(@Nullable String name, @Nonnull Class<T> type2) {
        return this.finder().findByName((Container)this.target(), name, type2, this.requireShowing());
    }

    @Nonnull
    protected final <T extends Component> T find(@Nonnull GenericTypeMatcher<? extends T> matcher2) {
        return this.finder().find((Container)this.target(), matcher2);
    }

    @Nonnull
    @RunsInEDT
    public <T extends Component, F extends AbstractComponentFixture<?, T, ?>> F with(@Nonnull ComponentFixtureExtension<T, F> extension) {
        return extension.createFixture(this.robot(), (Container)this.target());
    }

    @Nonnull
    protected final ComponentFinder finder() {
        return this.robot().finder();
    }

    @Override
    @Nonnull
    public Timeout defaultDialogLookupTimeout() {
        return DEFAULT_DIALOG_LOOKUP_TIMEOUT;
    }
}

