/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.function.Consumer;
import org.assertj.core.api.Assert;
import org.assertj.core.api.AssertionErrorCollector;

public interface SoftAssertionsProvider
extends AssertionErrorCollector {
    public <SELF extends Assert<? extends SELF, ? extends ACTUAL>, ACTUAL> SELF proxy(Class<SELF> var1, Class<ACTUAL> var2, ACTUAL var3);

    public void assertAll();

    default public void assertAlso(AssertionErrorCollector collector) {
        collector.assertionErrorsCollected().forEach(this::collectAssertionError);
    }

    default public void check(ThrowingRunnable assertion) {
        try {
            assertion.run();
            this.succeeded();
        }
        catch (AssertionError error) {
            this.collectAssertionError(error);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static <S extends SoftAssertionsProvider> void assertSoftly(Class<S> type2, Consumer<S> softly) {
        SoftAssertionsProvider assertions;
        try {
            assertions = (SoftAssertionsProvider)type2.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        softly.accept(assertions);
        assertions.assertAll();
    }

    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

