/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.microservices.endpoints.EndpointsModuleEntity;
import com.intellij.microservices.endpoints.EndpointsProjectModel;
import com.intellij.microservices.endpoints.EndpointsProvider;
import com.intellij.microservices.ui.flat.EndpointsCursorKt;
import com.intellij.microservices.ui.flat.EndpointsSearchPopupController;
import com.intellij.microservices.ui.flat.EndpointsToolWindowFactoryKt;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.ui.filterField.FilterSearchTextField;
import com.intellij.ui.filterField.SearchPopupControllerBase;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0011\u001a\u00020\u000fH\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsSearchPopupController;", "Lcom/intellij/ui/filterField/SearchPopupControllerBase;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "model", "Lcom/intellij/microservices/endpoints/EndpointsProjectModel;", "searchTextField", "Lcom/intellij/ui/filterField/FilterSearchTextField;", "endpointsList", "Ljavax/swing/JList;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/microservices/endpoints/EndpointsProjectModel;Lcom/intellij/ui/filterField/FilterSearchTextField;Ljavax/swing/JList;)V", "getAttributes", "", "", "getCompletionValues", "attribute", "intellij.microservices.ui"})
public final class EndpointsSearchPopupController
extends SearchPopupControllerBase {
    @NotNull
    private final Project project;
    @NotNull
    private final EndpointsProjectModel model;

    public EndpointsSearchPopupController(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull EndpointsProjectModel model, @NotNull FilterSearchTextField searchTextField2, @NotNull JList<?> endpointsList) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)searchTextField2, (String)"searchTextField");
        Intrinsics.checkNotNullParameter(endpointsList, (String)"endpointsList");
        super(project, coroutineScope, searchTextField2, endpointsList);
        this.project = project;
        this.model = model;
    }

    @NotNull
    protected List<String> getAttributes() {
        Object[] objectArray = new String[]{EndpointsCursorKt.getModuleAttribute(this.model), "type:", "framework:", "http-method:"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<String> getCompletionValues(@NotNull String attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (DumbService.Companion.isDumb(this.project)) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)EndpointsCursorKt.getModuleAttribute(this.model), (Object)attribute)) {
            List<EndpointsModuleEntity> modules = EndpointsCursorKt.getModulesOrdered(this.model, this.project);
            ArrayList<String> moduleNames = new ArrayList<String>(modules.size() + 1);
            moduleNames.add("#external");
            for (EndpointsModuleEntity module : modules) {
                moduleNames.add(module.getName());
            }
            return moduleNames;
        }
        if (Intrinsics.areEqual((Object)"framework:", (Object)attribute)) {
            return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map((Sequence)EndpointsProvider.Companion.getAvailableProviders(this.project), (Function1)getCompletionValues.1.INSTANCE)));
        }
        if (Intrinsics.areEqual((Object)"type:", (Object)attribute)) {
            return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map(EndpointsToolWindowFactoryKt.getAvailableEndpointTypes(this.project), (Function1)getCompletionValues.2.INSTANCE)));
        }
        if (Intrinsics.areEqual((Object)"http-method:", (Object)attribute)) {
            return UrlConstants.HTTP_METHODS;
        }
        return CollectionsKt.emptyList();
    }
}

