/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.flat;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.SearchEverywherePsiRenderer;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.microservices.endpoints.EndpointsListItem;
import com.intellij.microservices.ui.MicroservicesUiBundle;
import com.intellij.microservices.ui.flat.FlatEndpointItem;
import com.intellij.microservices.ui.flat.LoadingMoreItem;
import com.intellij.microservices.ui.flat.ModuleItem;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0015\u001a\u00020\u0004H\u0002J8\u0010\u0016\u001a\u00020\u00172\u000e\u0010\u0018\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsListRenderer;", "Ljavax/swing/ListCellRenderer;", "Lcom/intellij/microservices/endpoints/EndpointsListItem;", "isCompact", "", "(Z)V", "frameworkLabel", "Lcom/intellij/ui/components/JBLabel;", "itemRootPanel", "Lcom/intellij/microservices/ui/flat/EndpointsListRenderer$MyPanel;", "loadingRootPanel", "Ljavax/swing/JPanel;", "locationLabel", "moduleLabel", "Lcom/intellij/ui/SimpleColoredComponent;", "moduleRootPanel", "presentableTextLabel", "typeLabel", "applyDeprecatedStyle", "Lcom/intellij/ui/SimpleTextAttributes;", "textAttributes", "deprecated", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "cellHasFocus", "MyPanel", "intellij.microservices.ui"})
@SourceDebugExtension(value={"SMAP\nEndpointsListRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointsListRenderer.kt\ncom/intellij/microservices/ui/flat/EndpointsListRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1#2:140\n*E\n"})
public final class EndpointsListRenderer
implements ListCellRenderer<EndpointsListItem> {
    @NotNull
    private final MyPanel itemRootPanel = new MyPanel();
    @NotNull
    private final SimpleColoredComponent presentableTextLabel = new SimpleColoredComponent();
    @NotNull
    private final JBLabel locationLabel = new JBLabel();
    @NotNull
    private final JBLabel typeLabel = new JBLabel();
    @NotNull
    private final JBLabel frameworkLabel = new JBLabel();
    @NotNull
    private final JPanel moduleRootPanel = new JPanel(new FlowLayout(0, 0, 0));
    @NotNull
    private final SimpleColoredComponent moduleLabel = new SimpleColoredComponent();
    @NotNull
    private final JPanel loadingRootPanel = new JPanel(new FlowLayout(0, 0, 0));

    public EndpointsListRenderer(boolean isCompact) {
        this.itemRootPanel.setBorder(JBUI.Borders.empty((int)4));
        this.presentableTextLabel.setTransparentIconBackground(true);
        this.itemRootPanel.addToLeft((Component)this.presentableTextLabel);
        this.itemRootPanel.addToRight((Component)this.locationLabel);
        if (!isCompact) {
            NonOpaquePanel bottomPanel = new NonOpaquePanel((LayoutManager)new FlowLayout(0, 0, 0));
            bottomPanel.add((Component)this.typeLabel);
            bottomPanel.add((Component)this.frameworkLabel);
            this.itemRootPanel.addToBottom((Component)bottomPanel);
        }
        Color grayedFgColor = SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
        this.typeLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        this.typeLabel.setForeground(grayedFgColor);
        this.locationLabel.setForeground(grayedFgColor);
        this.frameworkLabel.setForeground(grayedFgColor);
        this.frameworkLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        this.moduleLabel.setTransparentIconBackground(true);
        this.moduleRootPanel.setBorder(JBUI.Borders.empty((int)4));
        this.moduleRootPanel.add((Component)this.moduleLabel);
        JBLabel loadingMoreLabel = new JBLabel(MicroservicesUiBundle.message("endpoints.loading.text", new Object[0]));
        loadingMoreLabel.setForeground(grayedFgColor);
        loadingMoreLabel.setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        this.loadingRootPanel.setBorder(JBUI.Borders.empty((int)4));
        this.loadingRootPanel.setBackground(ListUiUtil.WithTallRow.INSTANCE.alternativeBackground(false, false));
        this.loadingRootPanel.add((Component)loadingMoreLabel);
    }

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends EndpointsListItem> list, @NotNull EndpointsListItem value, int index, boolean isSelected, boolean cellHasFocus) {
        EndpointsListItem endpointsListItem;
        block8: {
            block10: {
                Color color;
                MyPanel myPanel;
                block12: {
                    Color rowColor;
                    block11: {
                        block9: {
                            Intrinsics.checkNotNullParameter(list, (String)"list");
                            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                            endpointsListItem = value;
                            if (!(endpointsListItem instanceof FlatEndpointItem)) break block8;
                            this.presentableTextLabel.clear();
                            this.presentableTextLabel.setIcon(((FlatEndpointItem)value).getIcon());
                            String string = ((FlatEndpointItem)value).getPresentableText();
                            SimpleTextAttributes simpleTextAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes, (String)"REGULAR_ATTRIBUTES");
                            this.presentableTextLabel.append(string, this.applyDeprecatedStyle(simpleTextAttributes, ((FlatEndpointItem)value).isDeprecated()), true);
                            String method = ((FlatEndpointItem)value).getMethodPresentation();
                            if (method != null) {
                                String string2 = " " + method;
                                SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.GRAYED_BOLD_ATTRIBUTES;
                                Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"GRAYED_BOLD_ATTRIBUTES");
                                this.presentableTextLabel.append(string2, this.applyDeprecatedStyle(simpleTextAttributes2, ((FlatEndpointItem)value).isDeprecated()));
                            }
                            this.locationLabel.setText(((FlatEndpointItem)value).getLocationString());
                            this.typeLabel.setText((String)((FlatEndpointItem)value).getProvider().getEndpointType().getLocalizedMessage().get());
                            this.frameworkLabel.setText(((FlatEndpointItem)value).getFrameworkPresentation().getTitle());
                            if (!isSelected) break block9;
                            this.itemRootPanel.setBackground(ListUiUtil.WithTallRow.INSTANCE.background(list, true, true));
                            break block10;
                        }
                        Color bgColor = ((FlatEndpointItem)value).getFileBgColor();
                        rowColor = ListUiUtil.WithTallRow.INSTANCE.alternativeBackground(false, cellHasFocus);
                        myPanel = this.itemRootPanel;
                        color = bgColor;
                        if (color == null) break block11;
                        Color color2 = color;
                        MyPanel myPanel2 = myPanel;
                        boolean bl = false;
                        Color color3 = ColorUtil.mix((Color)bgColor, (Color)rowColor, (double)0.5);
                        myPanel = myPanel2;
                        color = color3;
                        if (color3 != null) break block12;
                    }
                    color = rowColor;
                }
                myPanel.setBackground(color);
            }
            this.presentableTextLabel.setBackground(this.itemRootPanel.getBackground());
            return (Component)((Object)this.itemRootPanel);
        }
        if (endpointsListItem instanceof ModuleItem) {
            this.moduleLabel.clear();
            Object object = ((ModuleItem)value).getModule();
            if (object == null || (object = object.getIcon()) == null) {
                object = AllIcons.Nodes.Module;
            }
            this.moduleLabel.setIcon((Icon)object);
            Object object2 = ((ModuleItem)value).getModule();
            if (object2 == null || (object2 = object2.getName()) == null) {
                object2 = MicroservicesBundle.message((String)"frameworks.filters.module.external", (Object[])new Object[0]);
            }
            this.moduleLabel.append((String)object2);
            this.moduleRootPanel.setBackground(isSelected ? ListUiUtil.WithTallRow.INSTANCE.background(list, true, true) : JBColor.PanelBackground);
            this.moduleLabel.setBackground(this.moduleRootPanel.getBackground());
            return this.moduleRootPanel;
        }
        if (endpointsListItem instanceof LoadingMoreItem) {
            return this.loadingRootPanel;
        }
        throw new UnsupportedOperationException("Unknown list element");
    }

    private final SimpleTextAttributes applyDeprecatedStyle(SimpleTextAttributes textAttributes, boolean deprecated) {
        return deprecated ? new SimpleTextAttributes(textAttributes.getStyle() | 4, textAttributes.getFgColor()) : textAttributes;
    }

    static /* synthetic */ SimpleTextAttributes applyDeprecatedStyle$default(EndpointsListRenderer endpointsListRenderer, SimpleTextAttributes simpleTextAttributes, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            SimpleTextAttributes simpleTextAttributes2 = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            Intrinsics.checkNotNullExpressionValue((Object)simpleTextAttributes2, (String)"REGULAR_ATTRIBUTES");
            simpleTextAttributes = simpleTextAttributes2;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return endpointsListRenderer.applyDeprecatedStyle(simpleTextAttributes, bl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lcom/intellij/microservices/ui/flat/EndpointsListRenderer$MyPanel;", "Lcom/intellij/ui/components/JBPanel;", "()V", "addToBottom", "", "comp", "Ljava/awt/Component;", "addToLeft", "addToRight", "intellij.microservices.ui"})
    private static final class MyPanel
    extends JBPanel<MyPanel> {
        public MyPanel() {
            super((LayoutManager)new SearchEverywherePsiRenderer.SELayout());
        }

        public final void addToLeft(@NotNull Component comp) {
            Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
            this.add(comp, "West");
        }

        public final void addToRight(@NotNull Component comp) {
            Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
            this.add(comp, "East");
        }

        public final void addToBottom(@NotNull Component comp) {
            Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
            this.add(comp, "South");
        }
    }
}

