/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.ui.diagrams.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.microservices.mq.DestinationMQType;
import com.intellij.microservices.mq.DestinationType;
import com.intellij.microservices.mq.MQProviderType;
import com.intellij.microservices.mq.MQType;
import com.intellij.microservices.mq.MQTypes;
import com.intellij.microservices.mq.NamedMQType;
import com.intellij.microservices.mq.UnknownMQProviderType;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u0004\u0018\u00010\u00022\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J&\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/microservices/ui/diagrams/serialization/MQTypeJsonConverter;", "Lcom/google/gson/JsonSerializer;", "Lcom/intellij/microservices/mq/MQType;", "Lcom/google/gson/JsonDeserializer;", "()V", "deserialize", "json", "Lcom/google/gson/JsonElement;", "typeOfT", "Ljava/lang/reflect/Type;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "src", "typeOfSrc", "Lcom/google/gson/JsonSerializationContext;", "Companion", "intellij.microservices.ui"})
@SourceDebugExtension(value={"SMAP\nMQTypeJsonConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MQTypeJsonConverter.kt\ncom/intellij/microservices/ui/diagrams/serialization/MQTypeJsonConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n288#2,2:72\n*S KotlinDebug\n*F\n+ 1 MQTypeJsonConverter.kt\ncom/intellij/microservices/ui/diagrams/serialization/MQTypeJsonConverter\n*L\n41#1:72,2\n*E\n"})
public final class MQTypeJsonConverter
implements JsonSerializer<MQType>,
JsonDeserializer<MQType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TYPE_TAG_PROPERTY = "typeTag";
    @NotNull
    private static final String DESTINATION_MQTYPE_DESTINATION_TYPE_PROPERTY = "destinationType";
    @NotNull
    private static final String DESTINATION_MQTYPE_LOCALIZED_NAME_GETTER_PROPERTY = "localizedTypeNameGetter";
    @NotNull
    private static final String NAMED_MQTYPE_NAME_PROPERTY = "name";
    @NotNull
    private static final List<NamedMQType> ALL_KNOWN_MQ_TYPES;

    @NotNull
    public JsonElement serialize(@Nullable MQType src, @Nullable Type typeOfSrc, @Nullable JsonSerializationContext context) {
        JsonObject jsonObject;
        Intrinsics.checkNotNull((Object)src);
        JsonObject $this$serialize_u24lambda_u240 = jsonObject = new JsonObject();
        boolean bl = false;
        $this$serialize_u24lambda_u240.addProperty(TYPE_TAG_PROPERTY, src.getClass().getName());
        MQType mQType = src;
        if (mQType instanceof DestinationMQType) {
            JsonSerializationContext jsonSerializationContext = context;
            Intrinsics.checkNotNull((Object)jsonSerializationContext);
            $this$serialize_u24lambda_u240.add(DESTINATION_MQTYPE_DESTINATION_TYPE_PROPERTY, jsonSerializationContext.serialize((Object)((DestinationMQType)src).getDestinationType()));
            $this$serialize_u24lambda_u240.addProperty(DESTINATION_MQTYPE_LOCALIZED_NAME_GETTER_PROPERTY, ((DestinationMQType)src).getLocalizedTypeName());
        } else if (mQType instanceof NamedMQType) {
            $this$serialize_u24lambda_u240.addProperty(NAMED_MQTYPE_NAME_PROPERTY, ((NamedMQType)src).getName());
        } else if (!(mQType instanceof UnknownMQProviderType)) {
            throw new NotImplementedError("Unsupported MQType subtype: " + src.getClass().getName());
        }
        return (JsonElement)jsonObject;
    }

    @Nullable
    public MQType deserialize(@Nullable JsonElement json, @Nullable Type typeOfT, @Nullable JsonDeserializationContext context) {
        MQType mQType;
        JsonElement jsonElement = json;
        Intrinsics.checkNotNull((Object)jsonElement);
        JsonObject obj = jsonElement.getAsJsonObject();
        String string = obj.get(TYPE_TAG_PROPERTY).getAsString();
        if (Intrinsics.areEqual((Object)string, (Object)DestinationMQType.class.getName())) {
            JsonDeserializationContext jsonDeserializationContext = context;
            Intrinsics.checkNotNull((Object)jsonDeserializationContext);
            DestinationType destinationType = (DestinationType)jsonDeserializationContext.deserialize((JsonElement)obj.get(DESTINATION_MQTYPE_DESTINATION_TYPE_PROPERTY).getAsJsonObject(), (Type)((Object)DestinationType.class));
            String localizedName = obj.get(DESTINATION_MQTYPE_DESTINATION_TYPE_PROPERTY).getAsString();
            Intrinsics.checkNotNull((Object)destinationType);
            mQType = (MQType)new DestinationMQType(destinationType, () -> MQTypeJsonConverter.deserialize$lambda$1(localizedName));
        } else if (Intrinsics.areEqual((Object)string, (Object)NamedMQType.class.getName())) {
            Object v3;
            block5: {
                String name = obj.get(NAMED_MQTYPE_NAME_PROPERTY).getAsString();
                Iterable $this$firstOrNull$iv = ALL_KNOWN_MQ_TYPES;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    NamedMQType it = (NamedMQType)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            NamedMQType namedMQType = v3;
            mQType = (MQType)(namedMQType != null ? (MQProviderType)namedMQType : (MQProviderType)UnknownMQProviderType.INSTANCE);
        } else {
            mQType = Intrinsics.areEqual((Object)string, (Object)UnknownMQProviderType.class.getName()) ? (MQType)UnknownMQProviderType.INSTANCE : null;
        }
        return mQType;
    }

    private static final String deserialize$lambda$1(String $localizedName) {
        return $localizedName;
    }

    static {
        Object[] objectArray = new NamedMQType[]{MQTypes.ACTIVE_MQ_TYPE, MQTypes.ACTIVE_MQ_QUEUE_TYPE, MQTypes.ACTIVE_MQ_TOPIC_TYPE, MQTypes.RABBIT_MQ_TYPE, MQTypes.RABBIT_MQ_QUEUE_TYPE, MQTypes.RABBIT_MQ_TOPIC_TYPE, MQTypes.RABBIT_MQ_FANOUT_TYPE, MQTypes.RABBIT_MQ_DIRECT_TYPE, MQTypes.RABBIT_MQ_HEADERS_TYPE, MQTypes.RABBIT_MQ_EXCHANGE_TYPE, MQTypes.AMAZON_SQS_QUEUE_TYPE, MQTypes.KAFKA_TOPIC_TYPE};
        ALL_KNOWN_MQ_TYPES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/microservices/ui/diagrams/serialization/MQTypeJsonConverter$Companion;", "", "()V", "ALL_KNOWN_MQ_TYPES", "", "Lcom/intellij/microservices/mq/NamedMQType;", "DESTINATION_MQTYPE_DESTINATION_TYPE_PROPERTY", "", "DESTINATION_MQTYPE_LOCALIZED_NAME_GETTER_PROPERTY", "NAMED_MQTYPE_NAME_PROPERTY", "TYPE_TAG_PROPERTY", "intellij.microservices.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

