/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.run.configurations.publishing;

import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.CollectionBean;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rider.RiderPublishCustomServerBundle;
import com.jetbrains.rider.model.CustomTargetExtraPropertyBase;
import com.jetbrains.rider.model.PublishableProjectModel;
import com.jetbrains.rider.run.configurations.publishing.PublishAndUploadRunConfigurationType;
import com.jetbrains.rider.run.configurations.publishing.PublishRuntimeSettingsCoreHelper;
import com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfiguration;
import com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfigurationOnFilesTypeBase;
import com.jetbrains.rider.run.configurations.publishing.base.PublishRunConfigurationTypeBase;
import icons.RiderIcons;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J6\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015H\u0016J\u001e\u0010\u0017\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/run/configurations/publishing/PublishAndUploadRunConfigurationType;", "Lcom/jetbrains/rider/run/configurations/publishing/base/PublishRunConfigurationOnFilesTypeBase;", "Lcom/jetbrains/rider/run/configurations/publishing/PublishAndUploadRunConfigurationType$Settings;", "()V", "settingsClass", "Ljava/lang/Class;", "getSettingsClass", "()Ljava/lang/Class;", "actionsAfterBuild", "", "publishRunConfiguration", "Lcom/jetbrains/rider/run/configurations/publishing/base/PublishRunConfiguration;", "addExtraConfigurationItemsToMainTab", "Lcom/jetbrains/rider/run/configurations/publishing/base/PublishRunConfigurationTypeBase$ConfigurationListener;", "project", "Lcom/intellij/openapi/project/Project;", "panel", "Ljavax/swing/JPanel;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "projectProperty", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "Lcom/jetbrains/rider/model/PublishableProjectModel;", "checkConfiguration", "configuration", "extraMsBuildParameters", "", "Lcom/jetbrains/rider/model/CustomTargetExtraPropertyBase;", "getHelpTopic", "", "restoreBeforePublish", "", "Settings", "intellij.rider.plugins.publish.custom.server"})
@SourceDebugExtension(value={"SMAP\nPublishAndUploadRunConfigurationType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PublishAndUploadRunConfigurationType.kt\ncom/jetbrains/rider/run/configurations/publishing/PublishAndUploadRunConfigurationType\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,238:1\n766#2:239\n857#2,2:240\n766#2:242\n857#2,2:243\n766#2:245\n857#2,2:246\n288#2,2:248\n*S KotlinDebug\n*F\n+ 1 PublishAndUploadRunConfigurationType.kt\ncom/jetbrains/rider/run/configurations/publishing/PublishAndUploadRunConfigurationType\n*L\n149#1:239\n149#1:240,2\n152#1:242\n152#1:243,2\n154#1:245\n154#1:246,2\n159#1:248,2\n*E\n"})
public final class PublishAndUploadRunConfigurationType
extends PublishRunConfigurationOnFilesTypeBase<Settings> {
    @NotNull
    private final Class<Settings> settingsClass = Settings.class;

    public PublishAndUploadRunConfigurationType() {
        super("DotNetPublishAndUpload", "Publish to custom server", RiderPublishCustomServerBundle.Companion.message("PublishAndUploadRunConfigurationType.display.name.publish.to.custom.server", new Object[0]), RiderPublishCustomServerBundle.Companion.message("PublishAndUploadRunConfigurationType.description.publishes.msbuild.provided.files", new Object[0]), RiderIcons.Publish.PublishCustomServer);
    }

    @NotNull
    public Class<Settings> getSettingsClass() {
        return this.settingsClass;
    }

    public void checkConfiguration(@NotNull Project project, @NotNull PublishRunConfiguration<Settings> configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        super.checkConfiguration(project, configuration);
        Settings settings = (Settings)configuration.getSettings();
        GroupedServersConfigManager groupedServersConfigManager = GroupedServersConfigManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)groupedServersConfigManager, (String)"getInstance(...)");
        GroupedServersConfigManager webConfigManager = groupedServersConfigManager;
        if (webConfigManager.findServer(settings.getServerId()) == null && webConfigManager.findByName(settings.getServerName()) == null) {
            throw new RuntimeConfigurationError(RiderPublishCustomServerBundle.Companion.message("PublishAndUploadRunConfigurationType.dialog.message.no.server.specified", new Object[0]));
        }
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.dialogs.rundebug.DotNetPublishAndUpload";
    }

    @NotNull
    public List<CustomTargetExtraPropertyBase> extraMsBuildParameters(@NotNull PublishRunConfiguration<Settings> publishRunConfiguration) {
        Intrinsics.checkNotNullParameter(publishRunConfiguration, (String)"publishRunConfiguration");
        List parentParams = super.extraMsBuildParameters(publishRunConfiguration);
        PublishableProjectModel publishableProjectModel = this.getPublishableProjectModel(publishRunConfiguration);
        boolean bl = publishableProjectModel != null ? !publishableProjectModel.isDotNetCore() : false;
        if (bl) {
            return parentParams;
        }
        return CollectionsKt.plus((Collection)parentParams, (Iterable)PublishRuntimeSettingsCoreHelper.INSTANCE.getExtraParameters(publishRunConfiguration));
    }

    public void actionsAfterBuild(@NotNull PublishRunConfiguration<Settings> publishRunConfiguration) {
        Intrinsics.checkNotNullParameter(publishRunConfiguration, (String)"publishRunConfiguration");
        Path tempDir = ((Settings)publishRunConfiguration.getSettings()).getTempDir();
        Project project = publishRunConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PublishConfig publishConfig = PublishConfig.getInstance((Project)project2);
        GroupedServersConfigManager groupedServersConfigManager = GroupedServersConfigManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)groupedServersConfigManager, (String)"getInstance(...)");
        GroupedServersConfigManager configManager = groupedServersConfigManager;
        WebServerConfig webServerConfig = configManager.findServer(((Settings)publishRunConfiguration.getSettings()).getServerId(), true);
        if (webServerConfig == null) {
            PublishAndUploadRunConfigurationType $this$actionsAfterBuild_u24lambda_u240 = this;
            boolean bl = false;
            PathKt.delete$default((Path)tempDir, (boolean)false, (int)1, null);
            return;
        }
        WebServerConfig webServer = webServerConfig;
        Deployable deployable = Deployable.create((WebServerConfig)webServer, (Project)project2);
        String string = publishRunConfiguration.getName();
        DeploymentRevisionTracker deploymentRevisionTracker = DeploymentRevisionTracker.DEAF;
        var transferTask2 = new TransferTask.ListBased(project2, publishConfig, tempDir, deployable, string, deploymentRevisionTracker){
            @NotNull
            private CompletableFuture<Unit> done;
            final /* synthetic */ Path $tempDir;
            {
                this.$tempDir = $tempDir;
                super($project, true, $publishConfig, $super_call_param$1, $super_call_param$2, false, true, true, $super_call_param$3);
                this.done = new CompletableFuture<T>();
            }

            @NotNull
            public final CompletableFuture<Unit> getDone() {
                return this.done;
            }

            public final void setDone(@NotNull CompletableFuture<Unit> completableFuture) {
                Intrinsics.checkNotNullParameter(completableFuture, (String)"<set-?>");
                this.done = completableFuture;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(@NotNull ExecutionContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                ArrayList<TransferOperation> operations = new ArrayList<TransferOperation>();
                AutoCloseable autoCloseable = Files.list(this.$tempDir);
                Path path = this.$tempDir;
                Throwable throwable = null;
                try {
                    Stream it = (Stream)autoCloseable;
                    boolean bl = false;
                    it.forEach(arg_0 -> actionsAfterBuild.transferTask.1.buildOperationsList$lambda$3$lambda$2((Function1)new Function1<Path, Unit>(operations, path){
                        final /* synthetic */ ArrayList<TransferOperation> $operations;
                        final /* synthetic */ Path $tempDir;
                        {
                            this.$operations = $operations;
                            this.$tempDir = $tempDir;
                            super(1, Intrinsics.Kotlin.class, "processPath", "buildOperationsList$processPath(Ljava/util/ArrayList;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", 0);
                        }

                        public final void invoke(@NotNull Path p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            actionsAfterBuild.transferTask.1.access$buildOperationsList$processPath(this.$operations, this.$tempDir, p0);
                        }
                    }, arg_0));
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return new TransferTask.ListBased.ResultWithErrors((List)operations, new DeploymentPathUtils.ErrorsAndExclusions());
            }

            public void onFinished() {
                super.onFinished();
                this.done.complete(Unit.INSTANCE);
                PathKt.delete$default((Path)this.$tempDir, (boolean)false, (int)1, null);
            }

            private static final void buildOperationsList$processPath$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static final void buildOperationsList$processPath(ArrayList<TransferOperation> operations, Path tempDir, Path path) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (Files.isDirectory(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                    operations.add((TransferOperation)new TransferOperation.CreateFolder(new WebServerConfig.RemotePath(((Object)tempDir.relativize(path)).toString())));
                    AutoCloseable autoCloseable = Files.list(path);
                    Throwable throwable = null;
                    try {
                        Stream it = (Stream)autoCloseable;
                        boolean bl = false;
                        it.forEach(arg_0 -> actionsAfterBuild.transferTask.1.buildOperationsList$processPath$lambda$1$lambda$0((Function1)new Function1<Path, Unit>(operations, tempDir){
                            final /* synthetic */ ArrayList<TransferOperation> $operations;
                            final /* synthetic */ Path $tempDir;
                            {
                                this.$operations = $operations;
                                this.$tempDir = $tempDir;
                                super(1, Intrinsics.Kotlin.class, "processPath", "buildOperationsList$processPath(Ljava/util/ArrayList;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", 0);
                            }

                            public final void invoke(@NotNull Path p0) {
                                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                                actionsAfterBuild.transferTask.1.access$buildOperationsList$processPath(this.$operations, this.$tempDir, p0);
                            }
                        }, arg_0));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                    }
                } else {
                    operations.add((TransferOperation)new TransferOperation.Copy(DeploymentPathUtils.getLocalFile((String)((Object)path).toString()), new WebServerConfig.RemotePath(((Object)tempDir.relativize(path)).toString())));
                }
            }

            private static final void buildOperationsList$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                $tmp0.invoke(p0);
            }

            public static final /* synthetic */ void access$buildOperationsList$processPath(ArrayList operations, Path tempDir, Path path) {
                actionsAfterBuild.transferTask.1.buildOperationsList$processPath(operations, tempDir, path);
            }
        };
        ProgressManager.getInstance().run((Task)transferTask2);
        ApplicationKt.getApplication().assertIsNonDispatchThread();
        transferTask2.getDone().get();
    }

    public boolean restoreBeforePublish(@NotNull Project project, @NotNull PublishRunConfiguration<Settings> configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        return ((Settings)configuration.getSettings()).getSelfContained();
    }

    @NotNull
    public PublishRunConfigurationTypeBase.ConfigurationListener<Settings> addExtraConfigurationItemsToMainTab(@NotNull Project project, @NotNull JPanel panel, @NotNull Lifetime lifetime, @NotNull IPropertyView<PublishableProjectModel> projectProperty) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter(projectProperty, (String)"projectProperty");
        GroupedServersConfigManager groupedServersConfigManager = GroupedServersConfigManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)groupedServersConfigManager, (String)"getInstance(...)");
        GroupedServersConfigManager webConfigOptions = groupedServersConfigManager;
        ComboBox serversComboBox = new ComboBox();
        serversComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @NotNull
            public Component getListCellRendererComponent(@Nullable JList<?> p0, @Nullable Object p1, int p2, boolean p3, boolean p4) {
                super.getListCellRendererComponent(p0, p1, p2, p3, p4);
                WebServerConfig server = (WebServerConfig)p1;
                if (server == null) {
                    this.setText(RiderPublishCustomServerBundle.Companion.message("PublishAndUploadRunConfigurationType.no.remote.server.selected", new Object[0]));
                    this.setIcon(null);
                } else {
                    this.setText(server.getName());
                    this.setIcon(server.getIcon());
                }
                return this;
            }
        });
        FixedSizeButton serverSettingsButton = new FixedSizeButton();
        serverSettingsButton.setIcon(AllIcons.General.Ellipsis);
        serverSettingsButton.addActionListener(arg_0 -> PublishAndUploadRunConfigurationType.addExtraConfigurationItemsToMainTab$lambda$5(webConfigOptions, serversComboBox, project, arg_0));
        panel.add(new JLabel(RiderPublishCustomServerBundle.Companion.message("PublishAndUploadRunConfigurationType.label.remote.server", new Object[0])));
        panel.add((Component)serversComboBox, "growx, split 2");
        panel.add((Component)serverSettingsButton);
        PublishRunConfigurationTypeBase.ConfigurationListener coreListener = PublishRuntimeSettingsCoreHelper.INSTANCE.getSettingsControls(lifetime, projectProperty, panel, project);
        this.createInvalidator(panel).invoke();
        return (PublishRunConfigurationTypeBase.ConfigurationListener)new PublishRunConfigurationTypeBase.ConfigurationListener<Settings>(webConfigOptions, (ComboBox<WebServerConfig>)serversComboBox, (PublishRunConfigurationTypeBase.ConfigurationListener<Settings>)coreListener){
            final /* synthetic */ GroupedServersConfigManager $webConfigOptions;
            final /* synthetic */ ComboBox<WebServerConfig> $serversComboBox;
            final /* synthetic */ PublishRunConfigurationTypeBase.ConfigurationListener<Settings> $coreListener;
            {
                this.$webConfigOptions = $webConfigOptions;
                this.$serversComboBox = $serversComboBox;
                this.$coreListener = $coreListener;
            }

            /*
             * WARNING - void declaration
             */
            public void resetFromConfiguration(@NotNull PublishRunConfiguration<Settings> configuration) {
                Object v1;
                ComboBox<WebServerConfig> comboBox;
                block2: {
                    void $this$firstOrNull$iv;
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
                    Settings settings = (Settings)configuration.getSettings();
                    List list = this.$webConfigOptions.getFlattenedServers();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFlattenedServers(...)");
                    Iterable $this$filter$iv = list;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        WebServerConfig it = (WebServerConfig)element$iv$iv;
                        boolean bl = false;
                        if (!it.getAccessType().isProtocolBased()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List servers = (List)destination$iv$iv;
                    this.$serversComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(servers));
                    $this$filter$iv = servers;
                    comboBox = this.$serversComboBox;
                    boolean $i$f$firstOrNull = false;
                    for (E element$iv : $this$firstOrNull$iv) {
                        WebServerConfig it = (WebServerConfig)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)settings.getServerId())) continue;
                        v1 = element$iv;
                        break block2;
                    }
                    v1 = null;
                }
                comboBox.setSelectedItem(v1);
                this.$coreListener.resetFromConfiguration(configuration);
            }

            public void applyToConfiguration(@NotNull PublishRunConfiguration<Settings> configuration) {
                Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
                Settings settings = (Settings)configuration.getSettings();
                Object object = (WebServerConfig)this.$serversComboBox.getSelectedItem();
                if (object == null || (object = object.getId()) == null) {
                    object = settings.getServerId();
                }
                settings.setServerId((String)object);
                Object object2 = (WebServerConfig)this.$serversComboBox.getSelectedItem();
                if (object2 == null || (object2 = object2.getName()) == null) {
                    object2 = settings.getServerName();
                }
                settings.setServerName((String)object2);
                this.$coreListener.applyToConfiguration(configuration);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static final void addExtraConfigurationItemsToMainTab$lambda$5(GroupedServersConfigManager $webConfigOptions, ComboBox $serversComboBox, Project $project, ActionEvent it) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        WebServerConfig webServerConfig;
        void $this$filterTo$iv$iv3;
        Intrinsics.checkNotNullParameter((Object)$webConfigOptions, (String)"$webConfigOptions");
        Intrinsics.checkNotNullParameter((Object)$serversComboBox, (String)"$serversComboBox");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        List list = $webConfigOptions.getFlattenedServers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFlattenedServers(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo22 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            WebServerConfig it2 = (WebServerConfig)element$iv$iv;
            boolean bl = false;
            if (!it2.getAccessType().isProtocolBased()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingServers = (List)destination$iv$iv;
        if ($serversComboBox.getSelectedItem() != null) {
            Object object = $serversComboBox.getSelectedItem();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.plugins.webDeployment.config.WebServerConfig");
            webServerConfig = (WebServerConfig)object;
        } else {
            webServerConfig = null;
        }
        WebServerConfig currentServer = webServerConfig;
        ShowSettingsUtil.getInstance().editConfigurable($project, (Configurable)new DeploymentConfigurable($project));
        List list2 = $webConfigOptions.getFlattenedServers();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFlattenedServers(...)");
        Iterable $this$filter$iv2 = list2;
        boolean $i$f$filter2 = false;
        Iterable $i$f$filterTo22 = $this$filter$iv2;
        Iterable destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            WebServerConfig it3 = (WebServerConfig)element$iv$iv;
            boolean bl = false;
            if (!it3.getAccessType().isProtocolBased()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List servers = (List)destination$iv$iv2;
        $serversComboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(servers));
        Iterable $this$filter$iv3 = servers;
        boolean $i$f$filter3 = false;
        destination$iv$iv2 = $this$filter$iv3;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WebServerConfig it4 = (WebServerConfig)element$iv$iv;
            boolean bl = false;
            if (!(!existingServers.contains(it4))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List newServers = (List)destination$iv$iv3;
        if (!((Collection)newServers).isEmpty()) {
            $serversComboBox.setItem(CollectionsKt.last((List)newServers));
        } else {
            WebServerConfig selected;
            if (currentServer != null) {
                Object v4;
                block13: {
                    Iterable $this$firstOrNull$iv = servers;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        WebServerConfig it5 = (WebServerConfig)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it5.getId(), (Object)currentServer.getId())) continue;
                        v4 = element$iv;
                        break block13;
                    }
                    v4 = null;
                }
                v5 = v4;
            } else {
                v5 = selected = null;
            }
            if (selected != null) {
                $serversComboBox.setItem(selected);
            } else if (!((Collection)servers).isEmpty()) {
                $serversComboBox.setItem(CollectionsKt.first((List)servers));
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b'\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003R/\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nRC\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\r8W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R+\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00148W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R+\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00148W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\f\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R/\u0010#\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010\f\u001a\u0004\b$\u0010\b\"\u0004\b%\u0010\nR+\u0010'\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00148W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010\f\u001a\u0004\b(\u0010\u0017\"\u0004\b)\u0010\u0019R+\u0010+\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00148W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b.\u0010\f\u001a\u0004\b,\u0010\u0017\"\u0004\b-\u0010\u0019R/\u0010/\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b2\u0010\f\u001a\u0004\b0\u0010\b\"\u0004\b1\u0010\nR+\u00103\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00148W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b6\u0010\f\u001a\u0004\b4\u0010\u0017\"\u0004\b5\u0010\u0019R/\u00107\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b:\u0010\f\u001a\u0004\b8\u0010\b\"\u0004\b9\u0010\nR/\u0010;\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058G@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b>\u0010\f\u001a\u0004\b<\u0010\b\"\u0004\b=\u0010\nR/\u0010?\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bB\u0010\f\u001a\u0004\b@\u0010\b\"\u0004\bA\u0010\nR+\u0010C\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u00148W@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\bF\u0010\f\u001a\u0004\bD\u0010\u0017\"\u0004\bE\u0010\u0019\u00a8\u0006G"}, d2={"Lcom/jetbrains/rider/run/configurations/publishing/PublishAndUploadRunConfigurationType$Settings;", "Lcom/jetbrains/rider/run/configurations/publishing/base/PublishRunConfigurationOnFilesTypeBase$PublishRunConfigurationOnFilesSettingsBase;", "Lcom/jetbrains/rider/run/configurations/publishing/PublishRuntimeSettingsCoreHelper$CoreRuntimeSettings;", "()V", "<set-?>", "", "configuration", "getConfiguration", "()Ljava/lang/String;", "setConfiguration", "(Ljava/lang/String;)V", "configuration$delegate", "Lkotlin/properties/ReadWriteProperty;", "", "extraSettings", "getExtraSettings", "()Ljava/util/Map;", "setExtraSettings", "(Ljava/util/Map;)V", "extraSettings$delegate", "", "includeAllContentForSelfExtract", "getIncludeAllContentForSelfExtract", "()Z", "setIncludeAllContentForSelfExtract", "(Z)V", "includeAllContentForSelfExtract$delegate", "includeNativeLibsForSelfExtract", "getIncludeNativeLibsForSelfExtract", "setIncludeNativeLibsForSelfExtract", "includeNativeLibsForSelfExtract$delegate", "passwordStorage", "Lcom/intellij/credentialStore/CredentialStore;", "getPasswordStorage", "()Lcom/intellij/credentialStore/CredentialStore;", "platform", "getPlatform", "setPlatform", "platform$delegate", "produceSingleFile", "getProduceSingleFile", "setProduceSingleFile", "produceSingleFile$delegate", "readyToRun", "getReadyToRun", "setReadyToRun", "readyToRun$delegate", "runtime", "getRuntime", "setRuntime", "runtime$delegate", "selfContained", "getSelfContained", "setSelfContained", "selfContained$delegate", "serverId", "getServerId", "setServerId", "serverId$delegate", "serverName", "getServerName", "setServerName", "serverName$delegate", "targetFramework", "getTargetFramework", "setTargetFramework", "targetFramework$delegate", "trimUnusedAssemblies", "getTrimUnusedAssemblies", "setTrimUnusedAssemblies", "trimUnusedAssemblies$delegate", "intellij.rider.plugins.publish.custom.server"})
    public static final class Settings
    extends PublishRunConfigurationOnFilesTypeBase.PublishRunConfigurationOnFilesSettingsBase
    implements PublishRuntimeSettingsCoreHelper.CoreRuntimeSettings {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final ReadWriteProperty serverId$delegate = BaseState.string$default((BaseState)((BaseState)this), null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[0]);
        @NotNull
        private final ReadWriteProperty targetFramework$delegate = BaseState.string$default((BaseState)((BaseState)this), null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[1]);
        @NotNull
        private final ReadWriteProperty selfContained$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[2]);
        @NotNull
        private final ReadWriteProperty runtime$delegate = BaseState.string$default((BaseState)((BaseState)this), null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[3]);
        @NotNull
        private final ReadWriteProperty produceSingleFile$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[4]);
        @NotNull
        private final ReadWriteProperty readyToRun$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[5]);
        @NotNull
        private final ReadWriteProperty includeNativeLibsForSelfExtract$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[6]);
        @NotNull
        private final ReadWriteProperty includeAllContentForSelfExtract$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[7]);
        @NotNull
        private final ReadWriteProperty trimUnusedAssemblies$delegate = this.property(false).provideDelegate((Object)this, $$delegatedProperties[8]);
        @NotNull
        private final ReadWriteProperty configuration$delegate = BaseState.string$default((BaseState)((BaseState)this), null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[9]);
        @NotNull
        private final ReadWriteProperty platform$delegate = BaseState.string$default((BaseState)((BaseState)this), null, (int)1, null).provideDelegate((Object)this, $$delegatedProperties[10]);
        @NotNull
        private final ReadWriteProperty serverName$delegate = this.string("").provideDelegate((Object)this, $$delegatedProperties[11]);
        @NotNull
        private final ReadWriteProperty extraSettings$delegate = this.map().provideDelegate((Object)this, $$delegatedProperties[12]);
        @NotNull
        private final transient CredentialStore passwordStorage = (CredentialStore)new InMemoryCredentialStore();

        @Attribute(value="server_id")
        @Nullable
        public final String getServerId() {
            return (String)this.serverId$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public final void setServerId(@Nullable String string) {
            this.serverId$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)string);
        }

        @Attribute(value="target_framework")
        @Nullable
        public String getTargetFramework() {
            return (String)this.targetFramework$delegate.getValue((Object)this, $$delegatedProperties[1]);
        }

        public void setTargetFramework(@Nullable String string) {
            this.targetFramework$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)string);
        }

        @Attribute(value="self_contained")
        public boolean getSelfContained() {
            return (Boolean)this.selfContained$delegate.getValue((Object)this, $$delegatedProperties[2]);
        }

        public void setSelfContained(boolean bl) {
            this.selfContained$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)bl);
        }

        @Attribute(value="runtime")
        @Nullable
        public String getRuntime() {
            return (String)this.runtime$delegate.getValue((Object)this, $$delegatedProperties[3]);
        }

        public void setRuntime(@Nullable String string) {
            this.runtime$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)string);
        }

        @Attribute(value="produce_single_file")
        public boolean getProduceSingleFile() {
            return (Boolean)this.produceSingleFile$delegate.getValue((Object)this, $$delegatedProperties[4]);
        }

        public void setProduceSingleFile(boolean bl) {
            this.produceSingleFile$delegate.setValue((Object)this, $$delegatedProperties[4], (Object)bl);
        }

        @Attribute(value="ready_to_run")
        public boolean getReadyToRun() {
            return (Boolean)this.readyToRun$delegate.getValue((Object)this, $$delegatedProperties[5]);
        }

        public void setReadyToRun(boolean bl) {
            this.readyToRun$delegate.setValue((Object)this, $$delegatedProperties[5], (Object)bl);
        }

        @Attribute(value="include_native_libs_for_self_extract")
        public boolean getIncludeNativeLibsForSelfExtract() {
            return (Boolean)this.includeNativeLibsForSelfExtract$delegate.getValue((Object)this, $$delegatedProperties[6]);
        }

        public void setIncludeNativeLibsForSelfExtract(boolean bl) {
            this.includeNativeLibsForSelfExtract$delegate.setValue((Object)this, $$delegatedProperties[6], (Object)bl);
        }

        @Attribute(value="include_all_content_for_self_extract")
        public boolean getIncludeAllContentForSelfExtract() {
            return (Boolean)this.includeAllContentForSelfExtract$delegate.getValue((Object)this, $$delegatedProperties[7]);
        }

        public void setIncludeAllContentForSelfExtract(boolean bl) {
            this.includeAllContentForSelfExtract$delegate.setValue((Object)this, $$delegatedProperties[7], (Object)bl);
        }

        @Attribute(value="trim_unused_assemblies")
        public boolean getTrimUnusedAssemblies() {
            return (Boolean)this.trimUnusedAssemblies$delegate.getValue((Object)this, $$delegatedProperties[8]);
        }

        public void setTrimUnusedAssemblies(boolean bl) {
            this.trimUnusedAssemblies$delegate.setValue((Object)this, $$delegatedProperties[8], (Object)bl);
        }

        @Attribute(value="configuration")
        @Nullable
        public String getConfiguration() {
            return (String)this.configuration$delegate.getValue((Object)this, $$delegatedProperties[9]);
        }

        public void setConfiguration(@Nullable String string) {
            this.configuration$delegate.setValue((Object)this, $$delegatedProperties[9], (Object)string);
        }

        @Attribute(value="platform")
        @Nullable
        public String getPlatform() {
            return (String)this.platform$delegate.getValue((Object)this, $$delegatedProperties[10]);
        }

        public void setPlatform(@Nullable String string) {
            this.platform$delegate.setValue((Object)this, $$delegatedProperties[10], (Object)string);
        }

        @Attribute(value="serverName")
        @Nullable
        public final String getServerName() {
            return (String)this.serverName$delegate.getValue((Object)this, $$delegatedProperties[11]);
        }

        public final void setServerName(@Nullable String string) {
            this.serverName$delegate.setValue((Object)this, $$delegatedProperties[11], (Object)string);
        }

        @CollectionBean
        @NotNull
        public Map<String, String> getExtraSettings() {
            return (Map)this.extraSettings$delegate.getValue((Object)this, $$delegatedProperties[12]);
        }

        public void setExtraSettings(@NotNull Map<String, String> map) {
            Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
            this.extraSettings$delegate.setValue((Object)this, $$delegatedProperties[12], map);
        }

        @NotNull
        public CredentialStore getPasswordStorage() {
            return this.passwordStorage;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "serverId", "getServerId()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "targetFramework", "getTargetFramework()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "selfContained", "getSelfContained()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "runtime", "getRuntime()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "produceSingleFile", "getProduceSingleFile()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "readyToRun", "getReadyToRun()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "includeNativeLibsForSelfExtract", "getIncludeNativeLibsForSelfExtract()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "includeAllContentForSelfExtract", "getIncludeAllContentForSelfExtract()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "trimUnusedAssemblies", "getTrimUnusedAssemblies()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "configuration", "getConfiguration()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "platform", "getPlatform()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "serverName", "getServerName()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Settings.class, "extraSettings", "getExtraSettings()Ljava/util/Map;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

