/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.python.formatters;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiFilter;
import com.jetbrains.python.psi.PyImportStatementBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.language.CodeFormatter;
import org.jetbrains.completion.full.line.language.ElementFormatter;
import org.jetbrains.completion.full.line.language.formatters.CodeFormatterBase;
import org.jetbrains.completion.full.line.language.formatters.PlainTextFormatter;
import org.jetbrains.completion.full.line.language.formatters.SkippedElementsFormatter;
import org.jetbrains.completion.full.line.python.formatters.PyIntendToScopeFormatter;
import org.jetbrains.completion.full.line.python.formatters.WhitespaceFormatter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/completion/full/line/python/formatters/PythonCodeFormatter;", "Lorg/jetbrains/completion/full/line/language/formatters/CodeFormatterBase;", "()V", "elementFormatters", "", "Lorg/jetbrains/completion/full/line/language/ElementFormatter;", "getElementFormatters", "()Ljava/util/List;", "endOfLineMarkers", "", "getEndOfLineMarkers", "format", "element", "Lcom/intellij/psi/PsiElement;", "range", "Lcom/intellij/openapi/util/TextRange;", "importElements", "Lorg/jetbrains/completion/full/line/language/CodeFormatter$ImportElement;", "file", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.fullLine.python"})
public final class PythonCodeFormatter
extends CodeFormatterBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ElementFormatter> elementFormatters;
    @NotNull
    private final List<String> endOfLineMarkers;
    @NotNull
    public static final String SCOPE_IN = "\u21e5";
    @NotNull
    public static final String SCOPE_OUT = "\u21e4";

    public PythonCodeFormatter() {
        Object[] objectArray = new ElementFormatter[3];
        objectArray[0] = new WhitespaceFormatter();
        Class[] classArray = new Class[]{PsiComment.class, OuterLanguageElement.class};
        objectArray[1] = new SkippedElementsFormatter(classArray);
        objectArray[2] = new PlainTextFormatter();
        this.elementFormatters = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{SCOPE_IN, SCOPE_OUT};
        this.endOfLineMarkers = CollectionsKt.plus((Collection)super.getEndOfLineMarkers(), (Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public List<ElementFormatter> getElementFormatters() {
        return this.elementFormatters;
    }

    @NotNull
    public String format(@NotNull PsiElement element, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        String formatted = ((Object)StringsKt.trimStart((CharSequence)super.format(element, range))).toString();
        return new PyIntendToScopeFormatter(SCOPE_IN, SCOPE_OUT, null, 4, null).formatIntents(formatted);
    }

    @NotNull
    public List<CodeFormatter.ImportElement> importElements(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List list = new ArrayList();
        new PsiFilter(PyImportStatementBase.class).createVisitor(list).visitFile(file);
        return this.asImportElements(list);
    }

    @NotNull
    public List<String> getEndOfLineMarkers() {
        return this.endOfLineMarkers;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/completion/full/line/python/formatters/PythonCodeFormatter$Companion;", "", "()V", "SCOPE_IN", "", "SCOPE_OUT", "intellij.fullLine.python"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

