/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.parsing;

import com.dmarcotte.handlebars.HbBundle;
import com.dmarcotte.handlebars.parsing.HbElementType;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import java.util.Set;

public class HbParsing {
    private final PsiBuilder builder;
    private static final Set<IElementType> RECOVERY_SET = new HashSet<IElementType>();

    public HbParsing(PsiBuilder builder) {
        this.builder = builder;
    }

    public void parse() {
        while (!this.builder.eof()) {
            this.parseRoot(this.builder);
            if (this.builder.eof()) break;
            IElementType tokenType = this.builder.getTokenType();
            int problemOffset = this.builder.getCurrentOffset();
            if (tokenType == HbTokenTypes.OPEN_ENDBLOCK) {
                this.parseCloseBlock(this.builder);
            }
            if (this.builder.getCurrentOffset() != problemOffset) continue;
            PsiBuilder.Marker problemMark = this.builder.mark();
            this.builder.advanceLexer();
            problemMark.error(HbBundle.message("hb.parsing.invalid", new Object[0]));
        }
    }

    private void parseRoot(PsiBuilder builder) {
        this.parseProgram(builder);
    }

    private void parseProgram(PsiBuilder builder) {
        this.parseStatements(builder);
    }

    private void parseStatements(PsiBuilder builder) {
        PsiBuilder.Marker optionalStatementMarker;
        PsiBuilder.Marker statementsMarker = builder.mark();
        while (true) {
            optionalStatementMarker = builder.mark();
            if (!this.parseStatement(builder)) break;
            optionalStatementMarker.drop();
        }
        optionalStatementMarker.rollbackTo();
        statementsMarker.done(HbTokenTypes.STATEMENTS);
    }

    private boolean parseStatement(PsiBuilder builder) {
        IElementType tokenType = builder.getTokenType();
        if (builder.getTokenType() == HbTokenTypes.OPEN_INVERSE) {
            if (builder.lookAhead(1) == HbTokenTypes.CLOSE) {
                return false;
            }
            PsiBuilder.Marker blockMarker = builder.mark();
            if (!this.parseOpenInverse(builder)) {
                return false;
            }
            this.parseProgram(builder);
            this.parseInverseAndProgram(builder);
            this.parseCloseBlock(builder);
            blockMarker.done(HbTokenTypes.BLOCK_WRAPPER);
            return true;
        }
        if (tokenType == HbTokenTypes.OPEN_BLOCK) {
            boolean hasDecorator;
            PsiBuilder.Marker blockMarker = builder.mark();
            boolean bl = hasDecorator = builder.getTokenText() != null && builder.getTokenText().equals("{{#*");
            if (this.parseOpenBlock(builder)) {
                this.parseProgram(builder);
                PsiBuilder.Marker inverseMarker = builder.mark();
                if (this.parseInverseChain(builder) && hasDecorator) {
                    inverseMarker.error(HbBundle.message("hb.parsing.unexpected.decorator.inverse", new Object[0]));
                } else {
                    inverseMarker.drop();
                }
            } else {
                return false;
            }
            this.parseCloseBlock(builder);
            blockMarker.done(HbTokenTypes.BLOCK_WRAPPER);
            return true;
        }
        if (tokenType == HbTokenTypes.OPEN) {
            if (builder.lookAhead(1) == HbTokenTypes.ELSE) {
                return false;
            }
            this.parseMustache(builder, HbTokenTypes.OPEN, HbTokenTypes.CLOSE);
            return true;
        }
        if (tokenType == HbTokenTypes.OPEN_UNESCAPED) {
            this.parseMustache(builder, HbTokenTypes.OPEN_UNESCAPED, HbTokenTypes.CLOSE_UNESCAPED);
            return true;
        }
        if (tokenType == HbTokenTypes.OPEN_RAW_BLOCK) {
            PsiBuilder.Marker blockMarker = builder.mark();
            if (this.parseOpenRawBlock(builder)) {
                if (builder.getTokenType() == HbTokenTypes.CONTENT) {
                    builder.advanceLexer();
                }
            } else {
                return false;
            }
            this.parseCloseRawBlock(builder);
            blockMarker.done(HbTokenTypes.BLOCK_WRAPPER);
            return true;
        }
        if (tokenType == HbTokenTypes.OPEN_PARTIAL) {
            this.parsePartial(builder);
            return true;
        }
        if (tokenType == HbTokenTypes.OPEN_PARTIAL_BLOCK) {
            PsiBuilder.Marker blockMarker = builder.mark();
            if (!this.parseOpenPartialBlock(builder)) {
                return false;
            }
            this.parseProgram(builder);
            this.parseCloseBlock(builder);
            blockMarker.done(HbTokenTypes.BLOCK_WRAPPER);
            return true;
        }
        if (tokenType == HbTokenTypes.ESCAPE_CHAR) {
            builder.advanceLexer();
            return true;
        }
        if (tokenType == HbTokenTypes.CONTENT) {
            builder.advanceLexer();
            return true;
        }
        if (tokenType == HbTokenTypes.COMMENT) {
            HbParsing.parseLeafToken(builder, HbTokenTypes.COMMENT);
            return true;
        }
        if (tokenType == HbTokenTypes.UNCLOSED_COMMENT) {
            PsiBuilder.Marker unclosedCommentMarker = builder.mark();
            HbParsing.parseLeafToken(builder, HbTokenTypes.UNCLOSED_COMMENT);
            unclosedCommentMarker.error(HbBundle.message("hb.parsing.comment.unclosed", new Object[0]));
            return true;
        }
        return false;
    }

    private boolean parseInverseChain(PsiBuilder builder) {
        if (this.parseInverseAndProgram(builder)) {
            return true;
        }
        if (this.parseOpenInverseChain(builder)) {
            this.parseProgram(builder);
            this.parseInverseChain(builder);
            return true;
        }
        return false;
    }

    private boolean parseInverseAndProgram(PsiBuilder builder) {
        if (HbParsing.parseINVERSE(builder)) {
            this.parseProgram(builder);
            return true;
        }
        return false;
    }

    private boolean parseOpenRawBlock(PsiBuilder builder) {
        PsiBuilder.Marker openRawBlockStacheMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN_RAW_BLOCK)) {
            openRawBlockStacheMarker.drop();
            return false;
        }
        if (this.parseHelperName(builder)) {
            this.parseParamsStartHashQuestion(builder);
            this.parseLeafTokenGreedy(builder, HbTokenTypes.CLOSE_RAW_BLOCK);
        }
        openRawBlockStacheMarker.done(HbTokenTypes.OPEN_BLOCK_STACHE);
        return true;
    }

    private boolean parseOpenPartialBlock(PsiBuilder builder) {
        PsiBuilder.Marker openPartialBlockStacheMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN_PARTIAL_BLOCK)) {
            openPartialBlockStacheMarker.rollbackTo();
            return false;
        }
        if (this.parsePartialName(builder)) {
            this.parseParamsStartHashQuestion(builder);
        }
        this.parseLeafTokenGreedy(builder, HbTokenTypes.CLOSE);
        openPartialBlockStacheMarker.done(HbTokenTypes.OPEN_PARTIAL_BLOCK_STACHE);
        return true;
    }

    private boolean parseOpenBlock(PsiBuilder builder) {
        PsiBuilder.Marker openBlockStacheMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN_BLOCK)) {
            openBlockStacheMarker.drop();
            return false;
        }
        if (this.parseHelperName(builder)) {
            this.parseParamsStartHashQuestion(builder);
            HbParsing.parseBlockParams(builder);
            this.parseLeafTokenGreedy(builder, HbTokenTypes.CLOSE);
        }
        openBlockStacheMarker.done(HbTokenTypes.OPEN_BLOCK_STACHE);
        return true;
    }

    private boolean parseOpenInverseChain(PsiBuilder builder) {
        PsiBuilder.Marker openInverseChainMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN) || !HbParsing.parseLeafToken(builder, HbTokenTypes.ELSE)) {
            openInverseChainMarker.rollbackTo();
            return false;
        }
        if (this.parseHelperName(builder)) {
            this.parseParamsStartHashQuestion(builder);
            HbParsing.parseBlockParams(builder);
            this.parseLeafTokenGreedy(builder, HbTokenTypes.CLOSE);
        }
        openInverseChainMarker.done(HbTokenTypes.OPEN_INVERSE_CHAIN);
        return true;
    }

    private boolean parseOpenInverse(PsiBuilder builder) {
        PsiBuilder.Marker openInverseBlockStacheMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN_INVERSE)) {
            return false;
        }
        if (this.parseHelperName(builder)) {
            this.parseParamsStartHashQuestion(builder);
            HbParsing.parseBlockParams(builder);
            this.parseLeafTokenGreedy(builder, HbTokenTypes.CLOSE);
        }
        openInverseBlockStacheMarker.done(HbTokenTypes.OPEN_INVERSE_BLOCK_STACHE);
        return true;
    }

    private boolean parseCloseRawBlock(PsiBuilder builder) {
        PsiBuilder.Marker closeRawBlockMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.END_RAW_BLOCK)) {
            closeRawBlockMarker.drop();
            return false;
        }
        this.parseHelperName(builder);
        this.parseLeafTokenGreedy(builder, HbTokenTypes.CLOSE_RAW_BLOCK);
        closeRawBlockMarker.done(HbTokenTypes.CLOSE_BLOCK_STACHE);
        return true;
    }

    private boolean parseCloseBlock(PsiBuilder builder) {
        PsiBuilder.Marker closeBlockMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN_ENDBLOCK)) {
            closeBlockMarker.drop();
            return false;
        }
        this.parseHelperName(builder);
        this.parseLeafTokenGreedy(builder, HbTokenTypes.CLOSE);
        closeBlockMarker.done(HbTokenTypes.CLOSE_BLOCK_STACHE);
        return true;
    }

    protected void parseMustache(PsiBuilder builder, IElementType openStache, IElementType closeStache) {
        PsiBuilder.Marker mustacheMarker = builder.mark();
        HbParsing.parseLeafToken(builder, openStache);
        if (this.parseSexpr(builder) || this.parseHelperName(builder)) {
            this.parseParamsStartHashQuestion(builder);
        }
        this.parseLeafTokenGreedy(builder, closeStache);
        mustacheMarker.done(HbTokenTypes.MUSTACHE);
    }

    protected void parsePartial(PsiBuilder builder) {
        PsiBuilder.Marker partialMarker = builder.mark();
        HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN_PARTIAL);
        if (this.parsePartialName(builder)) {
            this.parseParamsStartHashQuestion(builder);
        }
        this.parseLeafTokenGreedy(builder, HbTokenTypes.CLOSE);
        partialMarker.done(HbTokenTypes.PARTIAL_STACHE);
    }

    private boolean parsePartialName(PsiBuilder builder) {
        PsiBuilder.Marker partialNameMark = builder.mark();
        if (this.parseSexpr(builder) || this.parseHelperName(builder)) {
            partialNameMark.done(HbTokenTypes.PARTIAL_NAME);
            return true;
        }
        partialNameMark.error(HbBundle.message("hb.parsing.expected.partial.name", new Object[0]));
        return false;
    }

    private static boolean parseINVERSE(PsiBuilder builder) {
        boolean isSimpleInverse;
        PsiBuilder.Marker simpleInverseMarker = builder.mark();
        PsiBuilder.Marker regularInverseMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN_INVERSE) || !HbParsing.parseLeafToken(builder, HbTokenTypes.CLOSE)) {
            regularInverseMarker.rollbackTo();
            isSimpleInverse = false;
        } else {
            regularInverseMarker.drop();
            isSimpleInverse = true;
        }
        PsiBuilder.Marker elseInverseMarker = builder.mark();
        if (!(isSimpleInverse || HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN) && HbParsing.parseLeafToken(builder, HbTokenTypes.ELSE) && HbParsing.parseLeafToken(builder, HbTokenTypes.CLOSE))) {
            elseInverseMarker.rollbackTo();
            isSimpleInverse = false;
        } else {
            elseInverseMarker.drop();
            isSimpleInverse = true;
        }
        if (isSimpleInverse) {
            simpleInverseMarker.done(HbTokenTypes.SIMPLE_INVERSE);
            return true;
        }
        simpleInverseMarker.drop();
        return false;
    }

    protected boolean parseSexpr(PsiBuilder builder) {
        PsiBuilder.Marker sexprMarker = builder.mark();
        if (HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN_SEXPR)) {
            this.parseParamsStartHashQuestion(builder);
            this.parseLeafTokenGreedy(builder, HbTokenTypes.CLOSE_SEXPR);
            sexprMarker.drop();
            return true;
        }
        sexprMarker.rollbackTo();
        return false;
    }

    private void parseParamsStartHashQuestion(PsiBuilder builder) {
        PsiBuilder.Marker helpParamHashMarker = builder.mark();
        PsiBuilder.Marker hashMarker = builder.mark();
        if (this.parseHash(builder)) {
            hashMarker.drop();
        } else {
            hashMarker.rollbackTo();
            PsiBuilder.Marker paramsMarker = builder.mark();
            if (this.parseParams(builder)) {
                PsiBuilder.Marker paramsHashMarker = builder.mark();
                int hashStartPos = builder.getCurrentOffset();
                if (this.parseHash(builder)) {
                    paramsHashMarker.drop();
                } else if (hashStartPos < builder.getCurrentOffset()) {
                    paramsHashMarker.drop();
                } else {
                    paramsHashMarker.rollbackTo();
                }
                paramsMarker.drop();
            } else {
                paramsMarker.rollbackTo();
            }
        }
        helpParamHashMarker.drop();
    }

    private boolean parseParams(PsiBuilder builder) {
        PsiBuilder.Marker optionalParamMarker;
        PsiBuilder.Marker paramsMarker = builder.mark();
        if (!this.parseParam(builder)) {
            paramsMarker.error(HbBundle.message("hb.parsing.expected.parameter", new Object[0]));
            return false;
        }
        while (true) {
            optionalParamMarker = builder.mark();
            if (!this.parseParam(builder)) break;
            optionalParamMarker.drop();
        }
        optionalParamMarker.rollbackTo();
        paramsMarker.drop();
        return true;
    }

    protected boolean parseParam(PsiBuilder builder) {
        PsiBuilder.Marker paramMarker = builder.mark();
        PsiBuilder.Marker helperNameMark = builder.mark();
        if (this.parseHelperName(builder)) {
            helperNameMark.drop();
            paramMarker.done(HbTokenTypes.PARAM);
            return true;
        }
        helperNameMark.rollbackTo();
        PsiBuilder.Marker sexprMarker = builder.mark();
        if (this.parseSexpr(builder)) {
            sexprMarker.drop();
            paramMarker.done(HbTokenTypes.PARAM);
            return true;
        }
        sexprMarker.rollbackTo();
        paramMarker.error(HbBundle.message("hb.parsing.expected.parameter", new Object[0]));
        return false;
    }

    private boolean parseHash(PsiBuilder builder) {
        return this.parseHashSegments(builder);
    }

    private boolean parseHashSegments(PsiBuilder builder) {
        int hashStartPos;
        PsiBuilder.Marker optionalHashMarker;
        PsiBuilder.Marker hashSegmentsMarker = builder.mark();
        if (!this.parseHashSegment(builder)) {
            hashSegmentsMarker.error(HbBundle.message("hb.parsing.expected.hash", new Object[0]));
            return false;
        }
        while (true) {
            optionalHashMarker = builder.mark();
            hashStartPos = builder.getCurrentOffset();
            if (!this.parseHashSegment(builder)) break;
            optionalHashMarker.drop();
        }
        if (hashStartPos < builder.getCurrentOffset()) {
            optionalHashMarker.drop();
            hashSegmentsMarker.drop();
            return false;
        }
        optionalHashMarker.rollbackTo();
        hashSegmentsMarker.drop();
        return true;
    }

    private boolean parseHashSegment(PsiBuilder builder) {
        boolean result;
        PsiBuilder.Marker hash = builder.mark();
        boolean bl = result = HbParsing.parseLeafToken(builder, HbTokenTypes.ID) && HbParsing.parseLeafToken(builder, HbTokenTypes.EQUALS) && this.parseParam(builder);
        if (result) {
            hash.done(HbTokenTypes.HASH);
        } else {
            hash.drop();
        }
        return result;
    }

    private boolean parseHelperName(PsiBuilder builder) {
        PsiBuilder.Marker helperNameMarker = builder.mark();
        PsiBuilder.Marker pathMarker = builder.mark();
        if (this.parsePath(builder)) {
            pathMarker.drop();
            helperNameMarker.done(HbTokenTypes.MUSTACHE_NAME);
            return true;
        }
        pathMarker.rollbackTo();
        PsiBuilder.Marker dataNameMarker = builder.mark();
        if (this.parseDataName(builder)) {
            dataNameMarker.drop();
            helperNameMarker.done(HbTokenTypes.MUSTACHE_NAME);
            return true;
        }
        dataNameMarker.rollbackTo();
        PsiBuilder.Marker stringMarker = builder.mark();
        if (HbParsing.parseLeafToken(builder, HbTokenTypes.STRING)) {
            stringMarker.drop();
            helperNameMarker.done(HbTokenTypes.MUSTACHE_NAME);
            return true;
        }
        stringMarker.rollbackTo();
        PsiBuilder.Marker integerMarker = builder.mark();
        if (HbParsing.parseLeafToken(builder, HbTokenTypes.NUMBER)) {
            integerMarker.drop();
            helperNameMarker.done(HbTokenTypes.MUSTACHE_NAME);
            return true;
        }
        integerMarker.rollbackTo();
        PsiBuilder.Marker booleanMarker = builder.mark();
        if (HbParsing.parseLeafToken(builder, HbTokenTypes.BOOLEAN)) {
            booleanMarker.drop();
            helperNameMarker.done(HbTokenTypes.MUSTACHE_NAME);
            return true;
        }
        booleanMarker.rollbackTo();
        PsiBuilder.Marker nullMarker = builder.mark();
        if (HbParsing.parseLeafToken(builder, HbTokenTypes.NULL)) {
            nullMarker.drop();
            helperNameMarker.done(HbTokenTypes.MUSTACHE_NAME);
            return true;
        }
        nullMarker.rollbackTo();
        PsiBuilder.Marker undefinedMarker = builder.mark();
        if (HbParsing.parseLeafToken(builder, HbTokenTypes.UNDEFINED)) {
            undefinedMarker.drop();
            helperNameMarker.done(HbTokenTypes.MUSTACHE_NAME);
            return true;
        }
        undefinedMarker.rollbackTo();
        helperNameMarker.error(HbBundle.message("hb.parsing.expected.path.or.data", new Object[0]));
        return false;
    }

    private static boolean parseBlockParams(PsiBuilder builder) {
        PsiBuilder.Marker blockParamsMarker = builder.mark();
        if (HbParsing.parseLeafToken(builder, HbTokenTypes.OPEN_BLOCK_PARAMS)) {
            PsiBuilder.Marker optionalIdMarker;
            blockParamsMarker.drop();
            HbParsing.parseLeafToken(builder, HbTokenTypes.ID);
            while (true) {
                optionalIdMarker = builder.mark();
                if (!HbParsing.parseLeafToken(builder, HbTokenTypes.ID)) break;
                optionalIdMarker.drop();
            }
            optionalIdMarker.rollbackTo();
            HbParsing.parseLeafToken(builder, HbTokenTypes.CLOSE_BLOCK_PARAMS);
            return true;
        }
        blockParamsMarker.rollbackTo();
        return false;
    }

    private boolean parseDataName(PsiBuilder builder) {
        PsiBuilder.Marker prefixMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.DATA_PREFIX)) {
            prefixMarker.rollbackTo();
            return false;
        }
        prefixMarker.drop();
        PsiBuilder.Marker dataMarker = builder.mark();
        if (this.parsePathSegments(builder)) {
            dataMarker.done(HbTokenTypes.DATA);
            return true;
        }
        dataMarker.rollbackTo();
        return false;
    }

    protected boolean parsePath(PsiBuilder builder) {
        PsiBuilder.Marker pathMarker = builder.mark();
        if (this.parsePathSegments(builder)) {
            pathMarker.done(HbTokenTypes.PATH);
            return true;
        }
        pathMarker.rollbackTo();
        return false;
    }

    protected boolean parsePathSegments(PsiBuilder builder) {
        PsiBuilder.Marker pathSegmentsMarker = builder.mark();
        if (this.isHashNextLookAhead(builder)) {
            pathSegmentsMarker.rollbackTo();
            return false;
        }
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.ID)) {
            pathSegmentsMarker.drop();
            return false;
        }
        this.parsePathSegmentsPrime(builder);
        pathSegmentsMarker.drop();
        return true;
    }

    protected void parsePathSegmentsPrime(PsiBuilder builder) {
        PsiBuilder.Marker pathSegmentsPrimeMarker = builder.mark();
        if (!HbParsing.parseLeafToken(builder, HbTokenTypes.SEP)) {
            pathSegmentsPrimeMarker.rollbackTo();
            return;
        }
        if (this.isHashNextLookAhead(builder)) {
            pathSegmentsPrimeMarker.rollbackTo();
            return;
        }
        if (HbParsing.parseLeafToken(builder, HbTokenTypes.ID)) {
            this.parsePathSegmentsPrime(builder);
        }
        pathSegmentsPrimeMarker.drop();
    }

    protected boolean isHashNextLookAhead(PsiBuilder builder) {
        PsiBuilder.Marker hashLookAheadMarker = builder.mark();
        boolean isHashUpcoming = this.parseHashSegment(builder);
        hashLookAheadMarker.rollbackTo();
        return isHashUpcoming;
    }

    protected static boolean parseLeafToken(PsiBuilder builder, IElementType leafTokenType) {
        PsiBuilder.Marker leafTokenMark = builder.mark();
        if (builder.getTokenType() == leafTokenType) {
            builder.advanceLexer();
            leafTokenMark.done(leafTokenType);
            return true;
        }
        if (builder.getTokenType() == HbTokenTypes.INVALID) {
            while (!builder.eof() && builder.getTokenType() == HbTokenTypes.INVALID) {
                builder.advanceLexer();
            }
            HbParsing.recordLeafTokenError(HbTokenTypes.INVALID, leafTokenMark);
            return false;
        }
        HbParsing.recordLeafTokenError(leafTokenType, leafTokenMark);
        return false;
    }

    protected void parseLeafTokenGreedy(PsiBuilder builder, IElementType expectedToken) {
        if (builder.getTokenType() != expectedToken) {
            PsiBuilder.Marker unexpectedTokensMarker = builder.mark();
            while (!builder.eof() && builder.getTokenType() != expectedToken && !RECOVERY_SET.contains(builder.getTokenType())) {
                builder.advanceLexer();
            }
            HbParsing.recordLeafTokenError(expectedToken, unexpectedTokensMarker);
        }
        if (!builder.eof() && builder.getTokenType() == expectedToken) {
            HbParsing.parseLeafToken(builder, expectedToken);
        }
    }

    private static void recordLeafTokenError(IElementType expectedToken, PsiBuilder.Marker unexpectedTokensMarker) {
        if (expectedToken instanceof HbElementType) {
            unexpectedTokensMarker.error(((HbElementType)expectedToken).parseExpectedMessage());
        } else {
            unexpectedTokensMarker.error(HbBundle.message("hb.parsing.element.expected.invalid", new Object[0]));
        }
    }

    static {
        RECOVERY_SET.add(HbTokenTypes.OPEN);
        RECOVERY_SET.add(HbTokenTypes.OPEN_BLOCK);
        RECOVERY_SET.add(HbTokenTypes.OPEN_ENDBLOCK);
        RECOVERY_SET.add(HbTokenTypes.OPEN_INVERSE);
        RECOVERY_SET.add(HbTokenTypes.OPEN_PARTIAL);
        RECOVERY_SET.add(HbTokenTypes.OPEN_UNESCAPED);
        RECOVERY_SET.add(HbTokenTypes.CONTENT);
    }
}

