/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.format;

import com.dmarcotte.handlebars.config.HbConfig;
import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.dmarcotte.handlebars.psi.HbPsiUtil;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.formatting.templateLanguages.BlockWithParent;
import com.intellij.formatting.templateLanguages.DataLanguageBlockWrapper;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlock;
import com.intellij.formatting.templateLanguages.TemplateLanguageBlockFactory;
import com.intellij.formatting.templateLanguages.TemplateLanguageFormattingModelBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.DocumentBasedFormattingModel;
import com.intellij.psi.formatter.FormattingDocumentModelImpl;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.formatter.xml.HtmlPolicy;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.templateLanguages.SimpleTemplateLanguageFormattingModelBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HbFormattingModelBuilder
extends TemplateLanguageFormattingModelBuilder {
    public TemplateLanguageBlock createTemplateLanguageBlock(@NotNull ASTNode node, @Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable List<DataLanguageBlockWrapper> foreignChildren, @NotNull CodeStyleSettings codeStyleSettings) {
        if (node == null) {
            HbFormattingModelBuilder.$$$reportNull$$$0(0);
        }
        if (codeStyleSettings == null) {
            HbFormattingModelBuilder.$$$reportNull$$$0(1);
        }
        FormattingDocumentModelImpl documentModel = FormattingDocumentModelImpl.createOn((PsiFile)node.getPsi().getContainingFile());
        HtmlPolicy policy = new HtmlPolicy(codeStyleSettings, (FormattingDocumentModel)documentModel);
        return HbTokenTypes.TAGS.contains(node.getElementType()) ? new HandlebarsTagBlock(node, wrap, alignment, (TemplateLanguageBlockFactory)this, codeStyleSettings, foreignChildren, policy) : new HandlebarsBlock(node, wrap, alignment, (TemplateLanguageBlockFactory)this, codeStyleSettings, foreignChildren, policy);
    }

    @NotNull
    public FormattingModel createModel(@NotNull FormattingContext formattingContext) {
        if (formattingContext == null) {
            HbFormattingModelBuilder.$$$reportNull$$$0(2);
        }
        if (!HbConfig.isFormattingEnabled()) {
            FormattingModel formattingModel = new SimpleTemplateLanguageFormattingModelBuilder().createModel(formattingContext);
            if (formattingModel == null) {
                HbFormattingModelBuilder.$$$reportNull$$$0(3);
            }
            return formattingModel;
        }
        PsiFile file = formattingContext.getContainingFile();
        ASTNode node = formattingContext.getNode();
        if (node.getElementType() == HbTokenTypes.OUTER_ELEMENT_TYPE) {
            FormattingModel formattingModel = new SimpleTemplateLanguageFormattingModelBuilder().createModel(formattingContext);
            if (formattingModel == null) {
                HbFormattingModelBuilder.$$$reportNull$$$0(4);
            }
            return formattingModel;
        }
        Block rootBlock = this.getRootBlock((PsiElement)file, file.getViewProvider(), formattingContext.getCodeStyleSettings());
        return new DocumentBasedFormattingModel(rootBlock, formattingContext.getProject(), formattingContext.getCodeStyleSettings(), file.getFileType(), file);
    }

    public boolean dontFormatMyModel() {
        return false;
    }

    private static boolean isAttribute(ASTNode child) {
        IElementType type = child.getElementType();
        return type == HbTokenTypes.PARAM || type == HbTokenTypes.HASH;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeStyleSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/dmarcotte/handlebars/format/HbFormattingModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/dmarcotte/handlebars/format/HbFormattingModelBuilder";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTemplateLanguageBlock";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModel";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class HandlebarsTagBlock
    extends HandlebarsBlock {
        @NotNull
        private final Alignment myChildAttributeAlignment;

        HandlebarsTagBlock(@NotNull ASTNode node, Wrap wrap, Alignment alignment, @NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @Nullable List<DataLanguageBlockWrapper> foreignChildren, HtmlPolicy htmlPolicy) {
            if (node == null) {
                HandlebarsTagBlock.$$$reportNull$$$0(0);
            }
            if (blockFactory == null) {
                HandlebarsTagBlock.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                HandlebarsTagBlock.$$$reportNull$$$0(2);
            }
            super(node, wrap, alignment, blockFactory, settings, foreignChildren, htmlPolicy);
            this.myChildAttributeAlignment = Alignment.createAlignment();
        }

        @Override
        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            ASTNode node;
            Block prevBlock;
            List blocks;
            if (newChildIndex > 0 && (blocks = this.getSubBlocks()).size() > newChildIndex - 1 && (prevBlock = (Block)blocks.get(newChildIndex - 1)) instanceof AbstractBlock && (HbFormattingModelBuilder.isAttribute(node = ((AbstractBlock)prevBlock).getNode()) || node.getElementType() == HbTokenTypes.MUSTACHE_NAME)) {
                return new ChildAttributes(null, prevBlock.getAlignment());
            }
            ChildAttributes childAttributes = super.getChildAttributes(newChildIndex);
            if (childAttributes == null) {
                HandlebarsTagBlock.$$$reportNull$$$0(3);
            }
            return childAttributes;
        }

        protected Alignment createChildAlignment(ASTNode child) {
            if (HbFormattingModelBuilder.isAttribute(child)) {
                return this.myChildAttributeAlignment;
            }
            return super.createChildAlignment(child);
        }

        protected Wrap createChildWrap(ASTNode child) {
            if (HbFormattingModelBuilder.isAttribute(child)) {
                return Wrap.createWrap((WrapType)WrappingUtil.getWrapType((int)this.myHtmlPolicy.getAttributesWrap()), (boolean)false);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockFactory";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsTagBlock";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsTagBlock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class HandlebarsBlock
    extends TemplateLanguageBlock {
        @NotNull
        protected final HtmlPolicy myHtmlPolicy;

        HandlebarsBlock(@NotNull ASTNode node, Wrap wrap, Alignment alignment, @NotNull TemplateLanguageBlockFactory blockFactory, @NotNull CodeStyleSettings settings, @Nullable List<DataLanguageBlockWrapper> foreignChildren, @NotNull HtmlPolicy htmlPolicy) {
            if (node == null) {
                HandlebarsBlock.$$$reportNull$$$0(0);
            }
            if (blockFactory == null) {
                HandlebarsBlock.$$$reportNull$$$0(1);
            }
            if (settings == null) {
                HandlebarsBlock.$$$reportNull$$$0(2);
            }
            if (htmlPolicy == null) {
                HandlebarsBlock.$$$reportNull$$$0(3);
            }
            super(node, wrap, alignment, blockFactory, settings, foreignChildren);
            this.myHtmlPolicy = htmlPolicy;
        }

        public Indent getIndent() {
            if (this.myNode.getText().trim().length() == 0) {
                return Indent.getNoneIndent();
            }
            if (HbFormattingModelBuilder.isAttribute(this.myNode)) {
                return null;
            }
            if (HbPsiUtil.isNonRootStatementsElement(this.myNode.getPsi())) {
                XmlTag xmlTag;
                DataLanguageBlockWrapper foreignBlockParent = this.getForeignBlockParent(false);
                if (foreignBlockParent == null) {
                    return Indent.getNormalIndent();
                }
                ASTNode aSTNode = foreignBlockParent.getNode();
                if (aSTNode instanceof XmlTag && !this.myHtmlPolicy.indentChildrenOf(xmlTag = (XmlTag)aSTNode)) {
                    return Indent.getNormalIndent();
                }
                return Indent.getNoneIndent();
            }
            if (this.myNode.getTreeParent() != null && HbPsiUtil.isNonRootStatementsElement(this.myNode.getTreeParent().getPsi()) && this.getParent() instanceof HandlebarsBlock && ((HandlebarsBlock)this.getParent()).getIndent() == Indent.getNoneIndent()) {
                return Indent.getNormalIndent();
            }
            DataLanguageBlockWrapper foreignParent = this.getForeignBlockParent(true);
            if (foreignParent != null) {
                if (foreignParent.getNode() instanceof XmlTag && !this.myHtmlPolicy.indentChildrenOf((XmlTag)foreignParent.getNode())) {
                    return Indent.getNoneIndent();
                }
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }

        protected IElementType getTemplateTextElementType() {
            return HbTokenTypes.CONTENT;
        }

        public boolean isRequiredRange(TextRange range) {
            return false;
        }

        @NotNull
        public ChildAttributes getChildAttributes(int newChildIndex) {
            if (this.myNode.getElementType() == HbTokenTypes.BLOCK_WRAPPER || this.getParent() instanceof DataLanguageBlockWrapper && (this.myNode.getElementType() != HbTokenTypes.STATEMENTS || newChildIndex != 0 || this.myNode.getTreeNext() instanceof PsiErrorElement)) {
                return new ChildAttributes(Indent.getNormalIndent(), null);
            }
            return new ChildAttributes(Indent.getNoneIndent(), null);
        }

        private DataLanguageBlockWrapper getForeignBlockParent(boolean immediate) {
            DataLanguageBlockWrapper foreignBlockParent = null;
            for (BlockWithParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (parent instanceof DataLanguageBlockWrapper && !(((DataLanguageBlockWrapper)parent).getOriginal() instanceof SyntheticBlock)) {
                    foreignBlockParent = (DataLanguageBlockWrapper)parent;
                    break;
                }
                if (immediate && parent instanceof HandlebarsBlock) break;
            }
            return foreignBlockParent;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "node";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "blockFactory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "settings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "htmlPolicy";
                    break;
                }
            }
            objectArray[1] = "com/dmarcotte/handlebars/format/HbFormattingModelBuilder$HandlebarsBlock";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

