/*
 * Decompiled with CFR 0.152.
 */
package com.dmarcotte.handlebars.editor.braces;

import com.dmarcotte.handlebars.parsing.HbTokenTypes;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HbBraceMatcher
implements BraceMatcher {
    private static final Set<IElementType> LEFT_BRACES = new HashSet<IElementType>();
    private static final Set<IElementType> RIGHT_BRACES = new HashSet<IElementType>();

    public boolean isPairBraces(@NotNull IElementType tokenType1, @NotNull IElementType tokenType2) {
        if (tokenType1 == null) {
            HbBraceMatcher.$$$reportNull$$$0(0);
        }
        if (tokenType2 == null) {
            HbBraceMatcher.$$$reportNull$$$0(1);
        }
        return LEFT_BRACES.contains(tokenType1) && RIGHT_BRACES.contains(tokenType2) || RIGHT_BRACES.contains(tokenType1) && LEFT_BRACES.contains(tokenType2);
    }

    public boolean isLBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            HbBraceMatcher.$$$reportNull$$$0(2);
        }
        if (fileText == null) {
            HbBraceMatcher.$$$reportNull$$$0(3);
        }
        if (fileType == null) {
            HbBraceMatcher.$$$reportNull$$$0(4);
        }
        return LEFT_BRACES.contains(iterator.getTokenType());
    }

    public boolean isRBraceToken(@NotNull HighlighterIterator iterator, @NotNull CharSequence fileText, @NotNull FileType fileType) {
        if (iterator == null) {
            HbBraceMatcher.$$$reportNull$$$0(5);
        }
        if (fileText == null) {
            HbBraceMatcher.$$$reportNull$$$0(6);
        }
        if (fileType == null) {
            HbBraceMatcher.$$$reportNull$$$0(7);
        }
        if (!RIGHT_BRACES.contains(iterator.getTokenType())) {
            return false;
        }
        boolean isRBraceToken = false;
        int iteratorRetreatCount = 0;
        block0: while (true) {
            iterator.retreat();
            ++iteratorRetreatCount;
            if (iterator.atEnd() || iterator.getTokenType() == HbTokenTypes.OPEN_BLOCK) break;
            if (iterator.getTokenType() == HbTokenTypes.OPEN_INVERSE) {
                while (iteratorRetreatCount-- > 0) {
                    iterator.advance();
                    if (iterator.getTokenType() == HbTokenTypes.ID) break block0;
                    if (iterator.getTokenType() != HbTokenTypes.CLOSE) continue;
                    isRBraceToken = true;
                    break block0;
                }
                break;
            }
            if (iterator.getTokenType() != HbTokenTypes.OPEN && iterator.getTokenType() != HbTokenTypes.OPEN_PARTIAL && iterator.getTokenType() != HbTokenTypes.OPEN_UNESCAPED && iterator.getTokenType() != HbTokenTypes.OPEN_ENDBLOCK) continue;
            isRBraceToken = true;
        }
        while (iteratorRetreatCount-- > 0) {
            iterator.advance();
        }
        return isRBraceToken;
    }

    public int getBraceTokenGroupId(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            HbBraceMatcher.$$$reportNull$$$0(8);
        }
        return 1;
    }

    public boolean isStructuralBrace(@NotNull HighlighterIterator iterator, @NotNull CharSequence text, @NotNull FileType fileType) {
        if (iterator == null) {
            HbBraceMatcher.$$$reportNull$$$0(9);
        }
        if (text == null) {
            HbBraceMatcher.$$$reportNull$$$0(10);
        }
        if (fileType == null) {
            HbBraceMatcher.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Nullable
    public IElementType getOppositeBraceTokenType(@NotNull IElementType type) {
        if (type == null) {
            HbBraceMatcher.$$$reportNull$$$0(12);
        }
        return null;
    }

    public boolean isPairedBracesAllowedBeforeType(@NotNull IElementType lbraceType, @Nullable IElementType contextType) {
        if (lbraceType == null) {
            HbBraceMatcher.$$$reportNull$$$0(13);
        }
        return true;
    }

    public int getCodeConstructStart(@NotNull PsiFile file, int openingBraceOffset) {
        if (file == null) {
            HbBraceMatcher.$$$reportNull$$$0(14);
        }
        return openingBraceOffset;
    }

    static {
        LEFT_BRACES.add(HbTokenTypes.OPEN);
        LEFT_BRACES.add(HbTokenTypes.OPEN_PARTIAL);
        LEFT_BRACES.add(HbTokenTypes.OPEN_UNESCAPED);
        LEFT_BRACES.add(HbTokenTypes.OPEN_BLOCK);
        LEFT_BRACES.add(HbTokenTypes.OPEN_INVERSE);
        RIGHT_BRACES.add(HbTokenTypes.CLOSE);
        RIGHT_BRACES.add(HbTokenTypes.CLOSE_UNESCAPED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType2";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileText";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lbraceType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/dmarcotte/handlebars/editor/braces/HbBraceMatcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairBraces";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isLBraceToken";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRBraceToken";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getBraceTokenGroupId";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "isStructuralBrace";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getOppositeBraceTokenType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isPairedBracesAllowedBeforeType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getCodeConstructStart";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

