/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.execution.debugger.memory.disasm.DisasmFileType;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.HexdumpFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewFileWritingAccessProvider;", "Lcom/intellij/openapi/vfs/WritingAccessProvider;", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "(Lcom/intellij/openapi/fileTypes/LanguageFileType;)V", "getFileType", "()Lcom/intellij/openapi/fileTypes/LanguageFileType;", "canEdit", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getReadOnlyMessage", "", "requestWriting", "", "files", "Disasm", "Hexdump", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nMemoryViewFileWritingAccessProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemoryViewFileWritingAccessProvider.kt\ncom/jetbrains/cidr/execution/debugger/memory/MemoryViewFileWritingAccessProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,44:1\n766#2:45\n857#2,2:46\n*S KotlinDebug\n*F\n+ 1 MemoryViewFileWritingAccessProvider.kt\ncom/jetbrains/cidr/execution/debugger/memory/MemoryViewFileWritingAccessProvider\n*L\n16#1:45\n16#1:46,2\n*E\n"})
public abstract class MemoryViewFileWritingAccessProvider
extends WritingAccessProvider {
    @NotNull
    private final LanguageFileType fileType;

    public MemoryViewFileWritingAccessProvider(@NotNull LanguageFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        this.fileType = fileType;
    }

    @NotNull
    public final LanguageFileType getFileType() {
        return this.fileType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<VirtualFile> requestWriting(@NotNull Collection<? extends VirtualFile> files) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Iterable $this$filter$iv = files;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(!this.canEdit(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public String getReadOnlyMessage() {
        Object[] objectArray = new Object[]{this.fileType.getName()};
        String string = CidrDebuggerBundle.message("debug.memory.view.modify.not.supported", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    private final boolean canEdit(VirtualFile file) {
        if (!FileTypeRegistry.getInstance().isFileOfType(file, (FileType)this.fileType)) {
            return true;
        }
        if (!(file instanceof MemoryViewFile) || !((MemoryViewFile)file).isWritable()) {
            return false;
        }
        CidrMemoryDoc<?> cidrMemoryDoc = ((MemoryViewFile)file).getMemoryDoc();
        if (cidrMemoryDoc == null) {
            return false;
        }
        CidrMemoryDoc<?> memoryDoc = cidrMemoryDoc;
        return memoryDoc.getDataProvider().readOnlyReason() == null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewFileWritingAccessProvider$Disasm;", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewFileWritingAccessProvider;", "()V", "intellij.cidr.debugger"})
    public static final class Disasm
    extends MemoryViewFileWritingAccessProvider {
        public Disasm() {
            DisasmFileType disasmFileType = DisasmFileType.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)disasmFileType), (String)"INSTANCE");
            super(disasmFileType);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewFileWritingAccessProvider$Hexdump;", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewFileWritingAccessProvider;", "()V", "getReadOnlyMessage", "", "intellij.cidr.debugger"})
    public static final class Hexdump
    extends MemoryViewFileWritingAccessProvider {
        public Hexdump() {
            HexdumpFileType hexdumpFileType = HexdumpFileType.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)hexdumpFileType), (String)"INSTANCE");
            super(hexdumpFileType);
        }

        @Override
        @NotNull
        public String getReadOnlyMessage() {
            String string = CidrDebuggerBundle.message("debug.memory.editing.action.is.not.supported", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

