/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LineNumberConverter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.CidrDebuggerHexdumpDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocGutterActionGroup;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryFileRawTypedHandler;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.execution.debugger.memory.ShowAddressesToggleAction;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.ByteCoordinates;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpRegion;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryViewFileEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final Key<Boolean> DOCUMENT_UPDATE_IN_PROGRESS = Key.create((String)"cidr.debugger.memory.documentUpdateInProgress");
    private final FileEditorProvider myDelegate = new PsiAwareTextEditorProvider();

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(1);
        }
        return file instanceof MemoryViewFile;
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        FileEditor fileEditor;
        if (project == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(2);
        }
        if (file == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(3);
        }
        if ((fileEditor = this.myDelegate.createEditor(project, file)) instanceof TextEditor && file instanceof MemoryViewFile) {
            MemoryViewFileEditorProvider.setupMemoryViewEditor((MemoryViewFile)file, (TextEditor)fileEditor);
        }
        FileEditor fileEditor2 = fileEditor;
        if (fileEditor2 == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(4);
        }
        return fileEditor2;
    }

    private static void setupMemoryViewEditor(@NotNull MemoryViewFile file, @NotNull TextEditor fileEditor) {
        CidrMemoryDoc<?> memoryDoc;
        if (file == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(5);
        }
        if (fileEditor == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(6);
        }
        if ((memoryDoc = file.getMemoryDoc()) == null) {
            return;
        }
        CidrMemoryFileRawTypedHandler.initIfNeeded();
        fileEditor.putUserData(FileEditorManagerImpl.SINGLETON_EDITOR_IN_WINDOW, (Object)true);
        Editor editor = fileEditor.getEditor();
        editor.getSettings().setUseSoftWraps(false);
        editor.getSettings().setRightMarginShown(false);
        if (memoryDoc.getDataProvider() instanceof CidrDebuggerHexdumpDataProvider) {
            ((EditorEx)editor).setContextMenuGroupId(null);
        }
        ((EditorMarkupModelImpl)editor.getMarkupModel()).setTrafficLightIconVisible(false);
        if (MemoryViewFileEditorProvider.shouldLoadDataOnScroll(memoryDoc)) {
            MemoryViewFileEditorProvider.registerDataLoadingListeners(editor, memoryDoc);
        }
        final EditorGutterComponentEx gutter = (EditorGutterComponentEx)editor.getGutter();
        gutter.setLineNumberConverter((LineNumberConverter)new CidrLineNumberToAddressConverter(memoryDoc));
        gutter.setGutterPopupGroup((ActionGroup)new CidrMemoryDocGutterActionGroup());
        ShowAddressesToggleAction.configureAddresses(editor);
        final GotoAddressPanel gotoAddressPanel = GotoAddressPanel.createFor(editor, ((EditorImpl)editor).getDisposable(), memoryDoc);
        if (gotoAddressPanel != null) {
            fileEditor.putUserData(GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY, (Object)gotoAddressPanel);
            gutter.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    gotoAddressPanel.setSeparatorOffset(gutter.getWhitespaceSeparatorOffset());
                }
            });
            if (memoryDoc.getDataProvider() instanceof CidrDebuggerHexdumpDataProvider) {
                editor.getCaretModel().addCaretListener((CaretListener)new HexdumpCaretListener(memoryDoc, editor, gotoAddressPanel));
            }
        }
    }

    @NotNull
    public String getEditorTypeId() {
        return "memory-view";
    }

    @NotNull
    public FileEditorState readState(@NotNull Element element, @NotNull Project project, @NotNull VirtualFile file) {
        if (element == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(7);
        }
        if (project == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(8);
        }
        if (file == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(9);
        }
        FileEditorState fileEditorState = this.myDelegate.readState(element, project, file);
        if (fileEditorState == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(10);
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element) {
        if (_state == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(11);
        }
        if (project == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(12);
        }
        if (element == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(13);
        }
        this.myDelegate.writeState(_state, project, element);
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(14);
        }
        return fileEditorPolicy;
    }

    private static boolean shouldLoadDataOnScroll(@NotNull CidrMemoryDoc<?> memoryDoc) {
        if (memoryDoc == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(15);
        }
        return Registry.is((String)"cidr.debugger.loadDataOnScroll", (boolean)true) && memoryDoc.getDataProvider() instanceof CidrDebuggerHexdumpDataProvider;
    }

    private static void registerDataLoadingListeners(final @NotNull Editor editor, final @NotNull CidrMemoryDoc<?> memoryDoc) {
        if (editor == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(16);
        }
        if (memoryDoc == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(17);
        }
        final CidrMemoryData.DataProvider<?> dataProvider = memoryDoc.getDataProvider();
        editor.getCaretModel().addCaretListener(new CaretListener(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (!dataProvider.canProvideData()) {
                    return;
                }
                int oldLine = e.getOldPosition().line;
                int newLine = e.getNewPosition().line;
                int lineCount = MemoryViewFileEditorProvider.getLineCount(e.getEditor());
                if (newLine > oldLine) {
                    ApplicationManager.getApplication().invokeLater(() -> memoryDoc.loadHigherAddresses(oldLine, lineCount));
                }
                if (newLine < oldLine) {
                    ApplicationManager.getApplication().invokeLater(() -> memoryDoc.loadLowerAddresses(oldLine, lineCount));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider$2", "caretPositionChanged"));
            }
        }, dataProvider);
        editor.getScrollingModel().addVisibleAreaListener(new VisibleAreaListener(){

            public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
                int line;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (!dataProvider.canProvideData()) {
                    return;
                }
                if (editor.getUserData(DOCUMENT_UPDATE_IN_PROGRESS) == Boolean.TRUE) {
                    return;
                }
                Rectangle oldRectangle = e.getOldRectangle();
                Rectangle newRectangle = e.getNewRectangle();
                if (oldRectangle == null) {
                    return;
                }
                int lineCount = MemoryViewFileEditorProvider.getLineCount(editor);
                LogicalPosition middleScreen = editor.xyToLogicalPosition(new Point(newRectangle.x, newRectangle.y + newRectangle.height / 2));
                Caret caret = editor.getCaretModel().getCurrentCaret();
                Point caretPoint = editor.offsetToXY(caret.getOffset());
                int n = line = newRectangle.contains(caretPoint) ? editor.getDocument().getLineNumber(caret.getOffset()) : middleScreen.line;
                if (newRectangle.y > oldRectangle.y) {
                    ApplicationManager.getApplication().invokeLater(() -> memoryDoc.loadHigherAddresses(line, lineCount));
                }
                if (newRectangle.y < oldRectangle.y) {
                    ApplicationManager.getApplication().invokeLater(() -> memoryDoc.loadLowerAddresses(line, lineCount));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider$3", "visibleAreaChanged"));
            }
        }, dataProvider);
        editor.getDocument().addDocumentListener((DocumentListener)new ScrollAndCaretAdjuster(editor), dataProvider);
    }

    static int getLineCount(@NotNull Editor editor) {
        if (editor == null) {
            MemoryViewFileEditorProvider.$$$reportNull$$$0(18);
        }
        return editor.getScrollingModel().getVisibleArea().height / editor.getLineHeight();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_state";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memoryDoc";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readState";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 4: 
            case 10: 
            case 14: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setupMemoryViewEditor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readState";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeState";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldLoadDataOnScroll";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerDataLoadingListeners";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLineCount";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 10, 14 -> new IllegalStateException(string);
        };
    }

    private static class CidrLineNumberToAddressConverter
    implements LineNumberConverter {
        private final CidrMemoryDoc<?> myMemoryDoc;

        CidrLineNumberToAddressConverter(CidrMemoryDoc<?> memoryDoc) {
            this.myMemoryDoc = memoryDoc;
        }

        @Nullable
        public String convertLineNumberToString(@NotNull Editor editor, int lineNumber) {
            if (editor == null) {
                CidrLineNumberToAddressConverter.$$$reportNull$$$0(0);
            }
            assert (lineNumber > 0);
            Address address2 = this.myMemoryDoc.getAddressForLine(lineNumber - 1);
            return address2 != null ? address2.toString() : null;
        }

        @NotNull
        public String getMaxLineNumberString(@NotNull Editor editor) {
            if (editor == null) {
                CidrLineNumberToAddressConverter.$$$reportNull$$$0(1);
            }
            String string = Address.MAX_VALUE.toString();
            if (string == null) {
                CidrLineNumberToAddressConverter.$$$reportNull$$$0(2);
            }
            return string;
        }

        public Integer convert(@NotNull Editor editor, int lineNumber) {
            if (editor == null) {
                CidrLineNumberToAddressConverter.$$$reportNull$$$0(3);
            }
            return 0;
        }

        public Integer getMaxLineNumber(@NotNull Editor editor) {
            if (editor == null) {
                CidrLineNumberToAddressConverter.$$$reportNull$$$0(4);
            }
            return 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider$CidrLineNumberToAddressConverter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider$CidrLineNumberToAddressConverter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMaxLineNumberString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "convertLineNumberToString";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getMaxLineNumberString";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "convert";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getMaxLineNumber";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class HexdumpCaretListener
    implements CaretListener {
        private static final int MAX_SPACES_BEFORE_HEX = "  ".length() + " ".length();
        private final CidrMemoryDoc<?> myMemoryDoc;
        private final Editor myEditor;
        private final GotoAddressPanel myGotoAddressPanel;
        @Nullable
        private RangeHighlighter myByteHighlighter;

        HexdumpCaretListener(@NotNull CidrMemoryDoc<?> memoryDoc, @NotNull Editor editor, @NotNull GotoAddressPanel gotoAddressPanel) {
            if (memoryDoc == null) {
                HexdumpCaretListener.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                HexdumpCaretListener.$$$reportNull$$$0(1);
            }
            if (gotoAddressPanel == null) {
                HexdumpCaretListener.$$$reportNull$$$0(2);
            }
            this.myMemoryDoc = memoryDoc;
            this.myEditor = editor;
            this.myGotoAddressPanel = gotoAddressPanel;
        }

        public void caretPositionChanged(@NotNull CaretEvent event) {
            int line;
            CidrHexdumpRegion region;
            if (event == null) {
                HexdumpCaretListener.$$$reportNull$$$0(3);
            }
            if ((region = (CidrHexdumpRegion)ObjectUtils.tryCast(this.myMemoryDoc.findRegionForLine(line = event.getNewPosition().line), CidrHexdumpRegion.class)) != null) {
                int offset = this.myEditor.logicalPositionToOffset(event.getNewPosition());
                ByteCoordinates coord = region.getCoordinates(offset - region.getTextRange().getStartOffset());
                if (coord != null) {
                    this.myGotoAddressPanel.showAddress(coord.getAddress());
                    this.highlightCurrentByte(coord, offset);
                } else {
                    this.removeByteHighlighting();
                }
            }
        }

        private void highlightCurrentByte(@NotNull ByteCoordinates coord, int caretOffset) {
            if (coord == null) {
                HexdumpCaretListener.$$$reportNull$$$0(4);
            }
            MarkupModel markup = this.myEditor.getMarkupModel();
            TextRange rangeToHighlight = null;
            if (coord.getAsciiRange().contains(caretOffset)) {
                rangeToHighlight = coord.getHexRange();
            } else if (coord.getHexRange().shiftLeft(MAX_SPACES_BEFORE_HEX).grown(MAX_SPACES_BEFORE_HEX).contains(caretOffset)) {
                rangeToHighlight = coord.getAsciiRange();
            }
            if (this.myByteHighlighter != null && !this.myByteHighlighter.getTextRange().equals((Object)rangeToHighlight)) {
                this.removeByteHighlighting();
            }
            if (this.myByteHighlighter == null && rangeToHighlight != null) {
                this.myByteHighlighter = markup.addRangeHighlighter(rangeToHighlight.getStartOffset(), rangeToHighlight.getEndOffset(), 5999, HexdumpCaretListener.getByteHighlighterAttributes(), HighlighterTargetArea.EXACT_RANGE);
            }
        }

        private void removeByteHighlighting() {
            if (this.myByteHighlighter != null) {
                this.myByteHighlighter.dispose();
                this.myByteHighlighter = null;
            }
        }

        @NotNull
        private static TextAttributes getByteHighlighterAttributes() {
            TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(DefaultLanguageHighlighterColors.IDENTIFIER).clone();
            attributes.setEffectType(EffectType.LINE_UNDERSCORE);
            attributes.setEffectColor((Color)JBColor.GRAY);
            TextAttributes textAttributes = attributes;
            if (textAttributes == null) {
                HexdumpCaretListener.$$$reportNull$$$0(5);
            }
            return textAttributes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memoryDoc";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "gotoAddressPanel";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "coord";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider$HexdumpCaretListener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider$HexdumpCaretListener";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getByteHighlighterAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "caretPositionChanged";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "highlightCurrentByte";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    private static final class ScrollAndCaretAdjuster
    implements DocumentListener {
        private final Editor myEditor;
        private boolean myShouldScroll;
        @Nullable
        private Caret myCaretToMove;

        private ScrollAndCaretAdjuster(@NotNull Editor editor) {
            if (editor == null) {
                ScrollAndCaretAdjuster.$$$reportNull$$$0(0);
            }
            this.myEditor = editor;
        }

        public void beforeDocumentChange(@NotNull DocumentEvent event) {
            if (event == null) {
                ScrollAndCaretAdjuster.$$$reportNull$$$0(1);
            }
            if (this.myEditor.isDisposed()) {
                return;
            }
            this.myEditor.putUserData(DOCUMENT_UPDATE_IN_PROGRESS, (Object)true);
            if (event.getOffset() == 0 && event.getOldLength() == 0 && event.getDocument().getTextLength() > 0) {
                Caret caret = this.myEditor.getCaretModel().getCurrentCaret();
                if (caret.getOffset() == 0) {
                    this.myCaretToMove = caret;
                } else if (this.myEditor.getScrollingModel().getVerticalScrollOffset() == 0) {
                    this.myShouldScroll = true;
                }
            }
        }

        public void documentChanged(@NotNull DocumentEvent event) {
            if (event == null) {
                ScrollAndCaretAdjuster.$$$reportNull$$$0(2);
            }
            if (this.myEditor.isDisposed()) {
                return;
            }
            Caret caretToMove = this.myCaretToMove;
            if (caretToMove != null) {
                caretToMove.moveToOffset(event.getNewLength());
                this.myShouldScroll = true;
            }
            if (this.myShouldScroll) {
                this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(event.getNewLength()), ScrollType.MAKE_VISIBLE);
            }
            this.myShouldScroll = false;
            this.myCaretToMove = null;
            this.myEditor.putUserData(DOCUMENT_UPDATE_IN_PROGRESS, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/memory/MemoryViewFileEditorProvider$ScrollAndCaretAdjuster";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeDocumentChange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "documentChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

