/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryInlayPass;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryInlays;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryInlays;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.cidr.debugger"})
public final class CidrMemoryInlays
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Long> TIMESTAMP_KEY;
    private static volatile boolean showDebugInfo;
    @NotNull
    private static AtomicLong showDebugInfoModificationCount;

    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        VirtualFile virtualFile = editor.getVirtualFile();
        MemoryViewFile memoryViewFile = virtualFile instanceof MemoryViewFile ? (MemoryViewFile)virtualFile : null;
        if (memoryViewFile == null) {
            return null;
        }
        MemoryViewFile memoryViewFile2 = memoryViewFile;
        CidrMemoryDoc<?> cidrMemoryDoc = memoryViewFile2.getMemoryDoc();
        if (cidrMemoryDoc == null) {
            return null;
        }
        CidrMemoryDoc<?> memoryDoc = cidrMemoryDoc;
        long memoryDocModificationCount2 = ((Number)memoryDoc.getDocAccess().read(createHighlightingPass.memoryDocModificationCount.1.INSTANCE)).longValue();
        long timestamp = editor.getDocument().getModificationStamp() + memoryDocModificationCount2 + showDebugInfoModificationCount.get();
        Long l = (Long)editor.getUserData(TIMESTAMP_KEY);
        long l2 = timestamp;
        if (l != null && l == l2) {
            return null;
        }
        return new CidrMemoryInlayPass(editor, memoryDoc, timestamp);
    }

    static {
        Key key = Key.create((String)"com.jetbrains.cidr.execution.debugger.memory.CidrMemoryInlays.timestamp");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        TIMESTAMP_KEY = key;
        showDebugInfoModificationCount = new AtomicLong(0L);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R$\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryInlays$Companion;", "", "()V", "TIMESTAMP_KEY", "Lcom/intellij/openapi/util/Key;", "", "getTIMESTAMP_KEY", "()Lcom/intellij/openapi/util/Key;", "value", "", "showDebugInfo", "getShowDebugInfo", "()Z", "setShowDebugInfo", "(Z)V", "showDebugInfoModificationCount", "Ljava/util/concurrent/atomic/AtomicLong;", "getShowDebugInfoModificationCount$intellij_cidr_debugger", "()Ljava/util/concurrent/atomic/AtomicLong;", "setShowDebugInfoModificationCount$intellij_cidr_debugger", "(Ljava/util/concurrent/atomic/AtomicLong;)V", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Long> getTIMESTAMP_KEY() {
            return TIMESTAMP_KEY;
        }

        public final boolean getShowDebugInfo() {
            return showDebugInfo;
        }

        public final void setShowDebugInfo(boolean value) {
            showDebugInfo = value;
            this.getShowDebugInfoModificationCount$intellij_cidr_debugger().incrementAndGet();
        }

        @NotNull
        public final AtomicLong getShowDebugInfoModificationCount$intellij_cidr_debugger() {
            return showDebugInfoModificationCount;
        }

        public final void setShowDebugInfoModificationCount$intellij_cidr_debugger(@NotNull AtomicLong atomicLong) {
            Intrinsics.checkNotNullParameter((Object)atomicLong, (String)"<set-?>");
            showDebugInfoModificationCount = atomicLong;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

