/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.memory.CidrDebuggerHexdumpDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocAccess;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpByteUpdate;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.CidrHexdumpRegion;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrHexdumpTypedHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "findRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/CidrHexdumpRegion;", "memoryDoc", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "offset", "", "intellij.cidr.debugger"})
public final class CidrHexdumpTypedHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        VirtualFile virtualFile = file.getVirtualFile();
        MemoryViewFile memoryViewFile = virtualFile instanceof MemoryViewFile ? (MemoryViewFile)virtualFile : null;
        if (memoryViewFile == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        MemoryViewFile memoryViewFile2 = memoryViewFile;
        CidrMemoryDoc<?> cidrMemoryDoc = memoryViewFile2.getMemoryDoc();
        if (cidrMemoryDoc == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        CidrMemoryDoc<?> memoryDoc = cidrMemoryDoc;
        if (!(memoryDoc.getDataProvider() instanceof CidrDebuggerHexdumpDataProvider)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        String readOnlyReason = memoryDoc.getDataProvider().readOnlyReason();
        if (readOnlyReason != null) {
            HintManager.getInstance().showInformationHint(editor, readOnlyReason, null);
            return TypedHandlerDelegate.Result.STOP;
        }
        int docOffset = editor.getCaretModel().getOffset();
        CidrHexdumpRegion cidrHexdumpRegion = this.findRegion(memoryDoc, docOffset);
        if (cidrHexdumpRegion == null) {
            return TypedHandlerDelegate.Result.STOP;
        }
        CidrHexdumpRegion hexdumpRegion = cidrHexdumpRegion;
        int offsetInRegion = docOffset - hexdumpRegion.getTextRange().getStartOffset();
        return (TypedHandlerDelegate.Result)memoryDoc.getDocAccess().edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<? extends Object>, TypedHandlerDelegate.Result>(hexdumpRegion, offsetInRegion, c, editor, memoryDoc){
            final /* synthetic */ CidrHexdumpRegion $hexdumpRegion;
            final /* synthetic */ int $offsetInRegion;
            final /* synthetic */ char $c;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ CidrMemoryDoc<?> $memoryDoc;
            {
                this.$hexdumpRegion = $hexdumpRegion;
                this.$offsetInRegion = $offsetInRegion;
                this.$c = $c;
                this.$editor = $editor;
                this.$memoryDoc = $memoryDoc;
                super(1);
            }

            @NotNull
            public final TypedHandlerDelegate.Result invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<? extends Object> $this$edit) {
                Intrinsics.checkNotNullParameter($this$edit, (String)"$this$edit");
                CidrHexdumpByteUpdate byteUpdate = this.$hexdumpRegion.updateByte(this.$offsetInRegion, this.$c);
                if (byteUpdate != null) {
                    this.$editor.getCaretModel().getCurrentCaret().moveToOffset(byteUpdate.getDocOffsetAfterEdit());
                    this.$editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                    int n = 0;
                    byte[] byArray = new byte[1];
                    while (n < 1) {
                        int n2 = n++;
                        byArray[n2] = byteUpdate.getNewValue();
                    }
                    byte[] dataToStore = byArray;
                    this.$memoryDoc.storeData(byteUpdate.getCoord().getAddress(), dataToStore, (Function1<Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(this.$editor, byteUpdate, this.$memoryDoc, this.$hexdumpRegion){
                        final /* synthetic */ Editor $editor;
                        final /* synthetic */ CidrHexdumpByteUpdate $byteUpdate;
                        final /* synthetic */ CidrMemoryDoc<?> $memoryDoc;
                        final /* synthetic */ CidrHexdumpRegion $hexdumpRegion;
                        {
                            this.$editor = $editor;
                            this.$byteUpdate = $byteUpdate;
                            this.$memoryDoc = $memoryDoc;
                            this.$hexdumpRegion = $hexdumpRegion;
                            super(1);
                        }

                        public final void invoke(@Nullable Throwable err) {
                            if (err != null) {
                                GotoAddressPanel gotoAddressPanel;
                                TextEditor fileEditor = TextEditorProvider.Companion.getInstance().getTextEditor(this.$editor);
                                GotoAddressPanel gotoAddressPanel2 = gotoAddressPanel = (GotoAddressPanel)((Object)GotoAddressPanel.GOTO_ADDRESS_FILE_EDITOR_KEY.get((UserDataHolder)fileEditor));
                                if (gotoAddressPanel2 != null) {
                                    Object[] objectArray = new Object[]{String.valueOf(this.$byteUpdate.getCoord().getAddress())};
                                    String string = CidrDebuggerBundle.message("debug.memory.failed.to.update.byte", objectArray);
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                    gotoAddressPanel2.showError(string);
                                }
                            }
                            this.$memoryDoc.getDocAccess().edit((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<? extends Object>, Unit>(this.$hexdumpRegion, this.$byteUpdate, err){
                                final /* synthetic */ CidrHexdumpRegion $hexdumpRegion;
                                final /* synthetic */ CidrHexdumpByteUpdate $byteUpdate;
                                final /* synthetic */ Throwable $err;
                                {
                                    this.$hexdumpRegion = $hexdumpRegion;
                                    this.$byteUpdate = $byteUpdate;
                                    this.$err = $err;
                                    super(1);
                                }

                                public final void invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<? extends Object> $this$edit) {
                                    Intrinsics.checkNotNullParameter($this$edit, (String)"$this$edit");
                                    this.$hexdumpRegion.updateCompleted(this.$byteUpdate, this.$err);
                                }
                            });
                            ((CidrDebuggerHexdumpDataProvider)this.$memoryDoc.getDataProvider()).getProcess().getSession().rebuildViews();
                        }
                    }));
                }
                return TypedHandlerDelegate.Result.STOP;
            }
        });
    }

    private final CidrHexdumpRegion findRegion(CidrMemoryDoc<?> memoryDoc, int offset) {
        return (CidrHexdumpRegion)memoryDoc.getDocAccess().read((Function1)new Function1<CidrMemoryDocAccess.DocAccessScope<? extends Object>, CidrHexdumpRegion>(offset, memoryDoc){
            final /* synthetic */ int $offset;
            final /* synthetic */ CidrMemoryDoc<?> $memoryDoc;
            {
                this.$offset = $offset;
                this.$memoryDoc = $memoryDoc;
                super(1);
            }

            @Nullable
            public final CidrHexdumpRegion invoke(@NotNull CidrMemoryDocAccess.DocAccessScope<? extends Object> $this$read) {
                Intrinsics.checkNotNullParameter($this$read, (String)"$this$read");
                int docLine = $this$read.getDocument().getLineNumber(this.$offset);
                DocRegion<?> docRegion = this.$memoryDoc.findRegionForLine(docLine);
                return docRegion instanceof CidrHexdumpRegion ? (CidrHexdumpRegion)docRegion : null;
            }
        });
    }
}

