/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public final class ValueRendererUtils {
    public static final char MARK_CHAR = '\u00fe';

    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            ValueRendererUtils.$$$reportNull$$$0(0);
        }
        return ValueRendererUtils.isBeginQuotedString(s) && s.charAt(s.length() - 1) == '\"';
    }

    private static int skipMark(@NotNull String text, int textLength, int startIndex) {
        char next;
        if (text == null) {
            ValueRendererUtils.$$$reportNull$$$0(1);
        }
        if (startIndex + 2 <= textLength && text.charAt(startIndex) == '\u00fe' && ((next = text.charAt(startIndex + 1)) == 'S' || next == 'K' || next == 'N' || next == 'C' || next == 'V' || next == 'E')) {
            startIndex += 2;
        }
        return startIndex;
    }

    public static boolean isBeginQuotedString(@NotNull String s) {
        int stringLen;
        if (s == null) {
            ValueRendererUtils.$$$reportNull$$$0(2);
        }
        if ((stringLen = s.length()) <= 1) {
            return false;
        }
        int start = 0;
        if ((start = ValueRendererUtils.skipMark(s, stringLen, start)) + 1 < stringLen && s.charAt(start) == '0' && s.charAt(start + 1) == 'x') {
            start += 2;
            while (start < stringLen && StringUtil.isHexDigit((char)s.charAt(start))) {
                ++start;
            }
            if ((start = ValueRendererUtils.skipMark(s, stringLen, start)) >= stringLen || s.charAt(start) != ' ') {
                return false;
            }
            ++start;
        }
        if ((start = ValueRendererUtils.skipMark(s, stringLen, start)) < stringLen && (s.charAt(start) == 'L' || s.charAt(start) == 'U' || s.charAt(start) == 'u')) {
            ++start;
        }
        return start + 1 < stringLen && s.charAt(start) == '\"';
    }

    @NotNull
    public static String getRawString(@NotNull String s) {
        int stringLen;
        if (s == null) {
            ValueRendererUtils.$$$reportNull$$$0(3);
        }
        if ((stringLen = s.length()) >= 2) {
            char ch0;
            int start = 0;
            if (s.charAt(start) == '0' && s.charAt(start + 1) == 'x') {
                start += 2;
                while (start < s.length() && StringUtil.isHexDigit((char)s.charAt(start))) {
                    ++start;
                }
                if (s.charAt(start) == ' ') {
                    ++start;
                } else {
                    String string = StringUtil.unescapeStringCharacters((String)s);
                    if (string == null) {
                        ValueRendererUtils.$$$reportNull$$$0(4);
                    }
                    return string;
                }
            }
            if ((ch0 = s.charAt(start)) == '\"') {
                ++start;
            } else if (start + 2 < stringLen && (ch0 == 'L' || ch0 == 'U' || ch0 == 'u') && s.charAt(start + 1) == '\"') {
                start += 2;
            } else {
                String string = StringUtil.unescapeStringCharacters((String)s);
                if (string == null) {
                    ValueRendererUtils.$$$reportNull$$$0(5);
                }
                return string;
            }
            if (s.endsWith("\"")) {
                s = s.substring(start, stringLen - 1);
            } else if (s.endsWith("\u2026")) {
                char ch = s.charAt(stringLen - 2);
                s = ch == '\"' ? s.substring(start, stringLen - 2) : s.substring(start, stringLen - 1);
            } else if (s.endsWith("...") && stringLen >= start + 4) {
                char ch = s.charAt(stringLen - 4);
                s = ch == '\"' ? s.substring(start, stringLen - 4) : s.substring(start, stringLen - 3);
            }
        }
        String string = s = StringUtil.unescapeStringCharacters((String)s);
        if (string == null) {
            ValueRendererUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String extractString(@NotNull String formattedText) {
        if (formattedText == null) {
            ValueRendererUtils.$$$reportNull$$$0(7);
        }
        StringBuilder result2 = new StringBuilder();
        int length = formattedText.length();
        int index = 0;
        while ((index = ValueRendererUtils.skipMark(formattedText, length, index)) < length) {
            char ch = formattedText.charAt(index);
            result2.append(ch);
            ++index;
        }
        String string = result2.toString();
        if (string == null) {
            ValueRendererUtils.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public static String shortenTemplateType(@NotNull String type) {
        if (type == null) {
            ValueRendererUtils.$$$reportNull$$$0(9);
        }
        return ValueRendererUtils.shortenTemplateType(type, 1);
    }

    @NotNull
    public static String shortenTemplateType(@NotNull String type, int templateTypeReduceLevel) {
        if (type == null) {
            ValueRendererUtils.$$$reportNull$$$0(10);
        }
        StringBuilder result2 = new StringBuilder();
        int count = 0;
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == '<') {
                ++count;
            }
            if (count <= templateTypeReduceLevel) {
                int length = result2.length();
                if (c == '>' && length > 2 && result2.charAt(length - 1) == ' ' && result2.charAt(length - 2) != '>') {
                    result2.setLength(length - 1);
                }
                result2.append(c);
            }
            if (c != '>') continue;
            --count;
        }
        String string = count == 0 ? result2.toString() : type;
        if (string == null) {
            ValueRendererUtils.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRendererUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattedText";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/ValueRendererUtils";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawString";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "extractString";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTemplateType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "skipMark";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBeginQuotedString";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getRawString";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "extractString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shortenTemplateType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 8, 11 -> new IllegalStateException(string);
        };
    }
}

