/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandExpiredException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrErrorValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPointerValuePresentationWrapper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueDescription;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrValue
extends XNamedValue
implements UserDataHolderEx {
    public static final Key<Boolean> DO_NOT_SHOW_ADDRESSES = Key.create((String)"DO_NOT_SHOW_ADDRESSES");
    public static final Key<Boolean> THREAT_VALUE_AS_RICH_TEXT = Key.create((String)"THREAT_VALUE_AS_RICH_TEXT");
    private static final Logger LOG = Logger.getInstance(CidrValue.class);
    @NotNull
    private final UserDataHolderBase myUserDataHolder;
    @NotNull
    private final CidrDebugProcess myProcess;
    @Nullable
    private final XSourcePosition myPosition;
    @NotNull
    private final CidrStackFrame myFrame;
    @NotNull
    private final List<String> myPresentationErrors;

    public CidrValue(@NotNull String displayName, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        if (displayName == null) {
            CidrValue.$$$reportNull$$$0(0);
        }
        if (process == null) {
            CidrValue.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            CidrValue.$$$reportNull$$$0(2);
        }
        super(displayName);
        this.myUserDataHolder = new UserDataHolderBase();
        this.myPresentationErrors = Collections.synchronizedList(new ArrayList());
        this.myProcess = process;
        this.myPosition = position;
        this.myFrame = frame;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            CidrValue.$$$reportNull$$$0(3);
        }
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            CidrValue.$$$reportNull$$$0(4);
        }
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        if (key == null) {
            CidrValue.$$$reportNull$$$0(5);
        }
        if (value == null) {
            CidrValue.$$$reportNull$$$0(6);
        }
        Object object = this.myUserDataHolder.putUserDataIfAbsent(key, value);
        if (object == null) {
            CidrValue.$$$reportNull$$$0(7);
        }
        return (T)object;
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        if (key == null) {
            CidrValue.$$$reportNull$$$0(8);
        }
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrStackFrame getFrame() {
        CidrStackFrame cidrStackFrame = this.myFrame;
        if (cidrStackFrame == null) {
            CidrValue.$$$reportNull$$$0(9);
        }
        return cidrStackFrame;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    @NotNull
    public String getEvaluationExpression() {
        String string = this.getEvaluationExpression(false);
        if (string == null) {
            CidrValue.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        String string = this.getName();
        if (string == null) {
            CidrValue.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        CidrDebugProcess cidrDebugProcess = this.myProcess;
        if (cidrDebugProcess == null) {
            CidrValue.$$$reportNull$$$0(12);
        }
        return cidrDebugProcess;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        if (navigatable == null) {
            CidrValue.$$$reportNull$$$0(13);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            XSourcePosition computedPosition;
            XSourcePosition position = this.getSourcePosition();
            if (position == null) {
                navigatable.setSourcePosition(null);
                return;
            }
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator == null) {
                LOG.warn("computeSourcePosition finished with error: ProgressIndicator is null");
                return;
            }
            try {
                computedPosition = this.doComputePositionAsync(position, indicator).get();
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                LOG.info("computeSourcePosition finished with error: " + e.getMessage());
                return;
            }
            ReadAction.run(() -> navigatable.setSourcePosition(computedPosition));
        }, CidrDebuggerBundle.message("debug.computing.source.position", new Object[0]), true, this.myProcess.getProject());
    }

    @NotNull
    protected abstract CompletableFuture<XSourcePosition> doComputePositionAsync(@NotNull XSourcePosition var1, @NotNull ProgressIndicator var2);

    @NotNull
    protected CompletableFuture<XSourcePosition> doComputeNearestUsagePositionAsync(@NotNull XSourcePosition position, @NotNull ProgressIndicator indicator) {
        if (position == null) {
            CidrValue.$$$reportNull$$$0(14);
        }
        if (indicator == null) {
            CidrValue.$$$reportNull$$$0(15);
        }
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            CidrValue.$$$reportNull$$$0(16);
        }
        return completableFuture;
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        if (callback == null) {
            CidrValue.$$$reportNull$$$0(17);
        }
        this.doComputeInlineDebuggerDataAsync(arg_0 -> ((XInlineDebuggerDataCallback)callback).computed(arg_0));
        ThreeState threeState = ThreeState.YES;
        if (threeState == null) {
            CidrValue.$$$reportNull$$$0(18);
        }
        return threeState;
    }

    protected void doComputeInlineDebuggerDataAsync(XNavigatable navigatable) {
        XSourcePosition position = this.getSourcePosition();
        if (position == null) {
            navigatable.setSourcePosition(null);
            return;
        }
        XDebugSession session = this.myProcess.getSession();
        Function<Function, CompletableFuture> execWithEmptyProgressIndicator = f -> {
            EmptyProgressIndicator indicator = new EmptyProgressIndicator();
            XDebugSessionListener listener = new XDebugSessionListener(){
                final /* synthetic */ ProgressIndicator val$indicator;
                {
                    this.val$indicator = progressIndicator;
                }

                public void sessionResumed() {
                    this.val$indicator.cancel();
                }

                public void sessionStopped() {
                    this.val$indicator.cancel();
                }
            };
            session.addSessionListener(listener);
            return ((CompletableFuture)f.apply(indicator)).whenComplete((v, t) -> session.removeSessionListener(listener));
        };
        execWithEmptyProgressIndicator.apply(i -> this.doComputePositionAsync(position, (ProgressIndicator)i).thenAccept(p -> ReadAction.run(() -> navigatable.setSourcePosition(p)))).whenComplete((v, t) -> execWithEmptyProgressIndicator.apply(ii -> this.doComputeNearestUsagePositionAsync(position, (ProgressIndicator)ii).thenAccept(pp -> ReadAction.run(() -> navigatable.setSourcePosition(pp)))));
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            CidrValue.$$$reportNull$$$0(19);
        }
        if (place == null) {
            CidrValue.$$$reportNull$$$0(20);
        }
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        XValueNodeExpirable expirable = new XValueNodeExpirable((Obsolescent)node, true);
        this.myProcess.postCommand((Expirable)expirable, driver -> {
            if (node.isObsolete()) {
                return;
            }
            long t0 = System.currentTimeMillis();
            CidrValue.setupCancellation(this.myProcess, driver, this, node, expirable);
            boolean hasChildren = false;
            try {
                XFullValueEvaluator evaluator;
                XValuePresentation presentation;
                CidrValueDescription valueDescription;
                Icon icon;
                EvaluationContext context = this.createEvaluationContext(driver, new XValueNodeExpirable((Obsolescent)node));
                SmartList presentationErrors = new SmartList();
                try {
                    hasChildren = this.doComputeMayHaveChildren(context);
                    icon = this.doComputeIcon(context, hasChildren);
                }
                catch (DebuggerCommandException e) {
                    icon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
                    presentationErrors.add(e.getMessage());
                }
                try {
                    Pair<CidrValueDescription, XValuePresentation> presentationData = this.doComputePresentation(context);
                    valueDescription = (CidrValueDescription)presentationData.first;
                    presentation = (XValuePresentation)presentationData.second;
                    evaluator = valueDescription.getFullValueEvaluator();
                }
                catch (DebuggerCommandException e) {
                    CidrValue.clearCancelLink(driver, node);
                    CidrErrorValue.doComputePresentation(node, e.getMessage(), hasChildren);
                    this.myProcess.addValuePresentationTime(System.currentTimeMillis() - t0);
                    return;
                }
                if (!presentationErrors.isEmpty()) {
                    this.myPresentationErrors.addAll((Collection<String>)presentationErrors);
                    hasChildren = true;
                }
                if (evaluator != null) {
                    node.setFullValueEvaluator(evaluator);
                }
                CidrValue.clearCancelLink(driver, node);
                node.setPresentation(icon, presentation, hasChildren);
                CidrValue.appendWarning(valueDescription, node);
            }
            catch (DebuggerCommandExpiredException e) {
                CidrValue.clearCancelLink(driver, node);
                CidrErrorValue.doComputePresentation(node, CidrDebuggerBundle.message("debug.cancelled.loading", new Object[0]), hasChildren);
            }
            catch (com.intellij.execution.ExecutionException e) {
                CidrValue.clearCancelLink(driver, node);
                CidrErrorValue.doComputePresentation(node, CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)), hasChildren);
                throw e;
            }
            finally {
                this.myProcess.addValuePresentationTime(System.currentTimeMillis() - t0);
            }
        });
    }

    private static void clearCancelLink(@NotNull DebuggerDriver driver, @NotNull XValueNode node) {
        if (driver == null) {
            CidrValue.$$$reportNull$$$0(21);
        }
        if (node == null) {
            CidrValue.$$$reportNull$$$0(22);
        }
        if (!(node instanceof XValueNodeImpl)) {
            return;
        }
        XValueNodeImpl nodeImpl = (XValueNodeImpl)node;
        if (!driver.supportsCommandCancellation()) {
            return;
        }
        nodeImpl.clearAdditionalHyperlinks();
    }

    private static void setupCancellation(final @NotNull CidrDebugProcess process, @NotNull DebuggerDriver driver, final @NotNull CidrValue value, @NotNull XValueNode node, final @NotNull XValueNodeExpirable expirable) {
        if (process == null) {
            CidrValue.$$$reportNull$$$0(23);
        }
        if (driver == null) {
            CidrValue.$$$reportNull$$$0(24);
        }
        if (value == null) {
            CidrValue.$$$reportNull$$$0(25);
        }
        if (node == null) {
            CidrValue.$$$reportNull$$$0(26);
        }
        if (expirable == null) {
            CidrValue.$$$reportNull$$$0(27);
        }
        if (!(node instanceof XValueNodeImpl)) {
            return;
        }
        final XValueNodeImpl nodeImpl = (XValueNodeImpl)node;
        if (!driver.supportsCommandCancellation()) {
            return;
        }
        XDebuggerTreeNodeHyperlink cancelLink = new XDebuggerTreeNodeHyperlink(" " + CidrDebuggerBundle.message("debug.cancel.loading", new Object[0])){

            public void onClick(MouseEvent event) {
                if (!expirable.isExpired()) {
                    expirable.expire();
                    nodeImpl.clearAdditionalHyperlinks();
                    nodeImpl.invokeNodeUpdate(() -> {
                        SimpleColoredText text = nodeImpl.getText();
                        text.clear();
                        String nodeName = nodeImpl.getName();
                        if (nodeName != null) {
                            text.append(nodeName, XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                            text.append(" = ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                        }
                        text.append(CidrDebuggerBundle.message("debug.cancelling.loading", new Object[0]), XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
                    });
                    CidrDebuggerUsagesCollector.logComputeValuePresentationCancelled(process.getDriverName());
                    process.notifyValueLoadingCancelled(value);
                }
            }
        };
        nodeImpl.addAdditionalHyperlink(cancelLink);
    }

    private static void appendWarning(@NotNull CidrValueDescription valueDescription, @NotNull XValueNode node) {
        String warning;
        if (valueDescription == null) {
            CidrValue.$$$reportNull$$$0(28);
        }
        if (node == null) {
            CidrValue.$$$reportNull$$$0(29);
        }
        if ((warning = valueDescription.getWarning()) != null && node instanceof XValueNodeImpl) {
            XValueNodeImpl nodeImpl = (XValueNodeImpl)node;
            XFullValueEvaluator.LinkAttributes linkAttributes = new XFullValueEvaluator.LinkAttributes(warning, null, AllIcons.General.Warning);
            XDebuggerTreeNodeHyperlink errorLink = new XDebuggerTreeNodeHyperlink("", linkAttributes){

                public boolean alwaysOnScreen() {
                    return true;
                }

                public void onClick(MouseEvent event) {
                }
            };
            nodeImpl.addAdditionalHyperlink(errorLink);
        }
    }

    protected abstract boolean doComputeMayHaveChildren(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract Icon doComputeIcon(@NotNull EvaluationContext var1, boolean var2) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @Nullable
    protected abstract String doComputeType(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @NotNull
    protected abstract CidrValueDescription doComputeValueDescription(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    @NotNull
    private Pair<CidrValueDescription, XValuePresentation> doComputePresentation(@NotNull EvaluationContext context) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrValue.$$$reportNull$$$0(30);
        }
        String type = CidrDebuggerSettings.getInstance().isShowTypes() ? this.doComputeType(context) : null;
        CidrValueDescription valueDescription = this.doComputeValueDescription(context);
        XValuePresentation presentation = this.createValuePresentation(context, valueDescription.getValue(), type);
        String pointerAddress = valueDescription.getPointerAddress();
        if (pointerAddress != null) {
            presentation = new CidrPointerValuePresentationWrapper(pointerAddress, presentation);
        }
        Pair pair = Pair.create((Object)valueDescription, (Object)presentation);
        if (pair == null) {
            CidrValue.$$$reportNull$$$0(31);
        }
        return pair;
    }

    @NotNull
    protected XValuePresentation createValuePresentation(@NotNull EvaluationContext context, @NotNull String value, @Nullable String type) throws com.intellij.execution.ExecutionException, DebuggerCommandException {
        if (context == null) {
            CidrValue.$$$reportNull$$$0(32);
        }
        if (value == null) {
            CidrValue.$$$reportNull$$$0(33);
        }
        if (StringUtil.isEmpty((String)value) && StringUtil.isEmpty((String)type)) {
            return new XRegularValuePresentation(value, type, "");
        }
        return new XRegularValuePresentation(value, type);
    }

    public final void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            CidrValue.$$$reportNull$$$0(34);
        }
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node)) {
            return;
        }
        if (!this.myPresentationErrors.isEmpty()) {
            node.addChildren(CidrValue.createErrorChildren(this.myPresentationErrors), false);
        }
        this.computeValueChildren(node);
    }

    @NotNull
    protected static XValueChildrenList createErrorChildren(@NotNull List<String> errors) {
        if (errors == null) {
            CidrValue.$$$reportNull$$$0(35);
        }
        XValueChildrenList errorNodesList = new XValueChildrenList();
        for (String each : errors) {
            errorNodesList.add((XNamedValue)new CidrErrorValue(each));
        }
        XValueChildrenList xValueChildrenList = errorNodesList;
        if (xValueChildrenList == null) {
            CidrValue.$$$reportNull$$$0(36);
        }
        return xValueChildrenList;
    }

    protected abstract void computeValueChildren(@NotNull XCompositeNode var1);

    public static void addLocalValues(@NotNull Collection<LLValue> vars, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull XCompositeNode toNode2, boolean last) {
        if (vars == null) {
            CidrValue.$$$reportNull$$$0(37);
        }
        if (process == null) {
            CidrValue.$$$reportNull$$$0(38);
        }
        if (frame == null) {
            CidrValue.$$$reportNull$$$0(39);
        }
        if (toNode2 == null) {
            CidrValue.$$$reportNull$$$0(40);
        }
        if (toNode2.isObsolete()) {
            return;
        }
        SmartList values = new SmartList();
        for (LLValue each : vars) {
            values.add(new CidrLocalValue(each, process, position, frame));
        }
        CidrValue.addAllTo((Collection<? extends XNamedValue>)values, toNode2, last);
    }

    public static void addAllTo(@NotNull Collection<CidrValue> values, @NotNull XCompositeNode toNode2) {
        if (values == null) {
            CidrValue.$$$reportNull$$$0(41);
        }
        if (toNode2 == null) {
            CidrValue.$$$reportNull$$$0(42);
        }
        CidrValue.addAllTo(values, toNode2, true);
    }

    public static void addAllTo(@NotNull Collection<? extends XNamedValue> values, @NotNull XCompositeNode toNode2, boolean last) {
        if (values == null) {
            CidrValue.$$$reportNull$$$0(43);
        }
        if (toNode2 == null) {
            CidrValue.$$$reportNull$$$0(44);
        }
        if (toNode2.isObsolete()) {
            return;
        }
        XValueChildrenList list = values.isEmpty() ? XValueChildrenList.EMPTY : new XValueChildrenList(values.size());
        for (XNamedValue xNamedValue : values) {
            list.add(xNamedValue);
        }
        toNode2.addChildren(list, last);
    }

    @NotNull
    public abstract String getConsoleDescription(@NotNull EvaluationContext var1) throws com.intellij.execution.ExecutionException, DebuggerCommandException;

    public EvaluationContext createEvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable) {
        if (driver == null) {
            CidrValue.$$$reportNull$$$0(45);
        }
        return this.getProcess().createEvaluationContext(driver, expirable, this.myFrame);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 9, 10, 11, 12, 16, 18, 31, 36 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 23: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 2: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: 
            case 25: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigatable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 19: 
            case 22: 
            case 26: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 21: 
            case 24: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expirable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueDescription";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNode";
                break;
            }
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/CidrValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "putUserDataIfAbsent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrame";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluationExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcess";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeNearestUsagePositionAsync";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInlineDebuggerData";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputePresentation";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createErrorChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getUserData";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putUserData";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putUserDataIfAbsent";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 18: 
            case 31: 
            case 36: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeSourcePosition";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doComputeNearestUsagePositionAsync";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeInlineDebuggerData";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "computePresentation";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "clearCancelLink";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setupCancellation";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "appendWarning";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doComputePresentation";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createValuePresentation";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "computeChildren";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createErrorChildren";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addLocalValues";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addAllTo";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createEvaluationContext";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 9, 10, 11, 12, 16, 18, 31, 36 -> new IllegalStateException(string);
        };
    }
}

