/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCleanableBreakpointHandlerBase;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CidrWatchpointHandler
extends CidrCleanableBreakpointHandlerBase<XBreakpoint<CidrWatchpointType.CidrWatchpointProperties>, LLWatchpoint> {
    public CidrWatchpointHandler(CidrDebugProcess process) {
        super(process, CidrWatchpointType.class);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Collection<LLWatchpoint> addCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint, long threadId, int n) throws ExecutionException {
        LLWatchpoint watchpoint;
        CidrWatchpointType.CidrWatchpointProperties properties;
        if (driver == null) {
            CidrWatchpointHandler.$$$reportNull$$$0(0);
        }
        if (breakpoint == null) {
            CidrWatchpointHandler.$$$reportNull$$$0(1);
        }
        if ((properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties()) == null || properties.getDebugProcess() != this.myProcess || !this.myProcess.supportsWatchpoints()) {
            return Collections.emptySet();
        }
        try {
            void frameIndex;
            watchpoint = driver.addWatchpoint(threadId, (int)frameIndex, properties.getLLValue(), properties.getExpr(), properties.getLifetime(), properties.getAccessType());
            properties.setError(null);
        }
        catch (DebuggerCommandException e) {
            properties.setError(e.getMessage());
            return Collections.emptyList();
        }
        return Collections.singleton(watchpoint);
    }

    @Override
    protected boolean shouldBreakpointBeRemoved(@NotNull XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint) {
        CidrWatchpointType.CidrWatchpointProperties properties;
        if (breakpoint == null) {
            CidrWatchpointHandler.$$$reportNull$$$0(2);
        }
        return (properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties()) != null && properties.getDebugProcess() == this.myProcess;
    }

    public void handleWatchpointScope(int id) {
        Object breakpoint = this.getXBreakpoint(id);
        if (breakpoint == null) {
            return;
        }
        this.unregisterCodepointsMapping(breakpoint);
        XDebuggerUtil.getInstance().removeBreakpoint(this.myProcess.getProject(), breakpoint);
    }

    @Override
    protected void removeCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull List<Integer> ids, @NotNull XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint) throws ExecutionException, DebuggerCommandException {
        CidrWatchpointType.CidrWatchpointProperties properties;
        if (driver == null) {
            CidrWatchpointHandler.$$$reportNull$$$0(3);
        }
        if (ids == null) {
            CidrWatchpointHandler.$$$reportNull$$$0(4);
        }
        if (breakpoint == null) {
            CidrWatchpointHandler.$$$reportNull$$$0(5);
        }
        if ((properties = (CidrWatchpointType.CidrWatchpointProperties)breakpoint.getProperties()) != null) {
            CidrDebuggerLog.LOG.assertTrue(properties.getDebugProcess() == this.myProcess);
        }
        driver.removeWatchpoint(ids);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrWatchpointHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCodepointsInBackend";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldBreakpointBeRemoved";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "removeCodepointsInBackend";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

