/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public abstract class CidrSymbolicBreakpointPropertiesPanel
extends XBreakpointCustomPropertiesPanel<XBreakpoint<CidrSymbolicBreakpointType.Properties>> {
    private JPanel myPanel;
    private TextFieldWithAutoCompletion mySymbolPatternField;
    private EditorTextField myModuleNameField;
    private JBLabel mySymbolExampleLabel;
    private JBLabel myModuleExampleLabel;
    protected final Project myProject;

    protected CidrSymbolicBreakpointPropertiesPanel(@NotNull Project project) {
        if (project == null) {
            CidrSymbolicBreakpointPropertiesPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myModuleNameField.setPlaceholder((CharSequence)CidrDebuggerBundle.message("debug.symbolic.breakpoint.module.placeholder", new Object[0]));
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            CidrSymbolicBreakpointPropertiesPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private void createUIComponents() {
        this.mySymbolPatternField = this.createSymbolNameField();
        this.mySymbolExampleLabel = new JBLabel();
        this.mySymbolExampleLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.myModuleExampleLabel = new JBLabel();
        this.myModuleExampleLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
    }

    @NotNull
    protected abstract TextFieldWithAutoCompletion createSymbolNameField();

    @TestOnly
    public TextFieldWithAutoCompletion getSymbolPatternField() {
        return this.mySymbolPatternField;
    }

    public void saveTo(@NotNull XBreakpoint<CidrSymbolicBreakpointType.Properties> breakpoint) {
        CidrSymbolicBreakpointType.Properties properties;
        boolean changed;
        if (breakpoint == null) {
            CidrSymbolicBreakpointPropertiesPanel.$$$reportNull$$$0(2);
        }
        if ((changed = (properties = (CidrSymbolicBreakpointType.Properties)breakpoint.getProperties()).updateSymbolPattern(this.mySymbolPatternField.getText().trim()) | properties.updateModuleName(StringUtil.nullize((String)this.myModuleNameField.getText().trim()))) && breakpoint instanceof XBreakpointBase) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    public void loadFrom(@NotNull XBreakpoint<CidrSymbolicBreakpointType.Properties> breakpoint) {
        CidrSymbolicBreakpointType.Properties properties;
        if (breakpoint == null) {
            CidrSymbolicBreakpointPropertiesPanel.$$$reportNull$$$0(3);
        }
        if ((properties = (CidrSymbolicBreakpointType.Properties)breakpoint.getProperties()) != null) {
            this.mySymbolPatternField.setText(properties.getSymbolPattern());
            this.myModuleNameField.setText(properties.getModuleName());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EditorTextField editorTextField;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrSymbolicBreakpointPropertiesPanel.class).getString("debug.symbolic.breakpoint.moduleName.label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/CidrDebuggerBundle", CidrSymbolicBreakpointPropertiesPanel.class).getString("debug.symbolic.breakpoint.symbolName.label"));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = new Insets(0, 0, 0, 10);
        jPanel.add((Component)jLabel2, gridBagConstraints2);
        this.myModuleNameField = editorTextField = new EditorTextField();
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.fill = 2;
        jPanel.add((Component)editorTextField, gridBagConstraints3);
        JBLabel jBLabel = this.mySymbolExampleLabel;
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setMinimumSize(new Dimension(380, 28));
        jBLabel.setText("<html>E.g. [UIViewController viewDidLoad], viewWillAppear:,<br/> +[UIView commitAnimations], Namespace::Clazz::foo(int *)</html>");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 18;
        gridBagConstraints4.insets = new Insets(0, 7, 5, 0);
        jPanel.add((Component)jBLabel, gridBagConstraints4);
        JBLabel jBLabel2 = this.myModuleExampleLabel;
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setText("E.g. UIKit, libobjc.A.dylib, IOSApp");
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.anchor = 18;
        gridBagConstraints5.insets = new Insets(0, 7, 5, 0);
        jPanel.add((Component)jBLabel2, gridBagConstraints5);
        TextFieldWithAutoCompletion textFieldWithAutoCompletion = this.mySymbolPatternField;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.anchor = 17;
        gridBagConstraints6.fill = 2;
        jPanel.add((Component)textFieldWithAutoCompletion, gridBagConstraints6);
        JSeparator jSeparator = new JSeparator();
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 4;
        gridBagConstraints7.gridwidth = 2;
        gridBagConstraints7.weighty = 1.0;
        gridBagConstraints7.fill = 2;
        jPanel.add((Component)jSeparator, gridBagConstraints7);
        jLabel.setLabelFor((Component)textFieldWithAutoCompletion);
        jLabel2.setLabelFor((Component)textFieldWithAutoCompletion);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointPropertiesPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointPropertiesPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

