/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbLoadedLibrariesState;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@State(name="gdb-loaded-libraries", storages={@Storage(value="$CACHE_FILE$", roamingType=RoamingType.DISABLED)}, allowLoadInTests=true)
@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0016J\u0006\u0010\u0012\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbLoadedLibrariesStorage;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbLoadedLibrariesState;", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "addLibrary", "", "executable", "Ljava/io/File;", "libraryPath", "", "deleteLibrary", "librariesForExecutable", "", "", "loadState", "state", "reset", "intellij.cidr.debugger"})
@SourceDebugExtension(value={"SMAP\nGdbIndexer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GdbIndexer.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbLoadedLibrariesStorage\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,736:1\n372#2,7:737\n372#2,7:744\n*S KotlinDebug\n*F\n+ 1 GdbIndexer.kt\ncom/jetbrains/cidr/execution/debugger/backend/gdb/GdbLoadedLibrariesStorage\n*L\n633#1:737,7\n642#1:744,7\n*E\n"})
public final class GdbLoadedLibrariesStorage
extends SimplePersistentStateComponent<GdbLoadedLibrariesState> {
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();

    public GdbLoadedLibrariesStorage() {
        super((BaseState)new GdbLoadedLibrariesState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull GdbLoadedLibrariesState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            super.loadState((BaseState)state);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, Long> librariesForExecutable(@NotNull File executable) {
        HashMap<String, Long> hashMap;
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        String path = executable.getAbsolutePath();
        Lock lock = this.lock;
        lock.lock();
        try {
            Map<String, Long> map;
            boolean bl = false;
            if (((GdbLoadedLibrariesState)this.getState()).getLibraries().get(path) == null) {
                Map map2 = MapsKt.emptyMap();
                return map2;
            }
            Map<String, Long> libs = map;
            hashMap = new HashMap<String, Long>(libs);
        }
        finally {
            lock.unlock();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void addLibrary(@NotNull File executable, @NotNull String libraryPath) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)libraryPath, (String)"libraryPath");
        String path = executable.getAbsolutePath();
        long now = System.currentTimeMillis();
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map<String, Map<String, Long>> map = ((GdbLoadedLibrariesState)this.getState()).getLibraries();
            Intrinsics.checkNotNull((Object)path);
            String key$iv = path;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Map answer$iv = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Map libs = (Map)object;
            Long l = now;
            libs.put(libraryPath, l);
            ((GdbLoadedLibrariesState)this.getState()).intIncrementModificationCount();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void deleteLibrary(@NotNull File executable, @NotNull String libraryPath) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)libraryPath, (String)"libraryPath");
        String path = executable.getAbsolutePath();
        Lock lock = this.lock;
        lock.lock();
        try {
            Object object;
            void $this$getOrPut$iv;
            boolean bl = false;
            Map<String, Map<String, Long>> map = ((GdbLoadedLibrariesState)this.getState()).getLibraries();
            Intrinsics.checkNotNull((Object)path);
            String key$iv = path;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Map answer$iv = new HashMap();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Map libs = (Map)object;
            libs.remove(libraryPath);
            ((GdbLoadedLibrariesState)this.getState()).intIncrementModificationCount();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            this.loadState(new GdbLoadedLibrariesState());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }
}

