/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\u00020\f*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexingSessionFileStat;", "", "()V", "indexedFileCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "indexedLargestFileSizeBytes", "Ljava/util/concurrent/atomic/AtomicLong;", "indexedTotalFileSizeBytes", "processedFileCount", "processedLargestFileSizeBytes", "processedTotalFileSizeBytes", "toMb", "", "getToMb", "(Ljava/util/concurrent/atomic/AtomicLong;)I", "recordIndexedFile", "", "fileSizeBytes", "", "recordProcessedFile", "report", "intellij.cidr.debugger"})
@ApiStatus.Internal
public final class GdbIndexingSessionFileStat {
    @NotNull
    private final AtomicInteger processedFileCount = new AtomicInteger(0);
    @NotNull
    private final AtomicLong processedLargestFileSizeBytes = new AtomicLong(0L);
    @NotNull
    private final AtomicLong processedTotalFileSizeBytes = new AtomicLong(0L);
    @NotNull
    private final AtomicInteger indexedFileCount = new AtomicInteger(0);
    @NotNull
    private final AtomicLong indexedLargestFileSizeBytes = new AtomicLong(0L);
    @NotNull
    private final AtomicLong indexedTotalFileSizeBytes = new AtomicLong(0L);

    public final void recordProcessedFile(long fileSizeBytes) {
        this.processedFileCount.incrementAndGet();
        this.processedLargestFileSizeBytes.accumulateAndGet(fileSizeBytes, Math::max);
        this.processedTotalFileSizeBytes.addAndGet(fileSizeBytes);
    }

    public final void recordIndexedFile(long fileSizeBytes) {
        this.indexedFileCount.incrementAndGet();
        this.indexedLargestFileSizeBytes.accumulateAndGet(fileSizeBytes, Math::max);
        this.indexedTotalFileSizeBytes.addAndGet(fileSizeBytes);
    }

    public final void report() {
        int processedCount = this.processedFileCount.get();
        if (processedCount > 0) {
            CidrDebuggerUsagesCollector.INSTANCE.logGdbIndexingFileStat(processedCount, this.getToMb(this.processedLargestFileSizeBytes), this.getToMb(this.processedTotalFileSizeBytes), this.indexedFileCount.get(), this.getToMb(this.indexedLargestFileSizeBytes), this.getToMb(this.indexedTotalFileSizeBytes));
        }
    }

    private final int getToMb(AtomicLong $this$toMb) {
        return RangesKt.coerceAtMost((int)((int)($this$toMb.get() / (long)0x100000)), (int)Integer.MAX_VALUE);
    }
}

