/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessListener;
import com.jetbrains.cidr.execution.debugger.CidrLocalDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexNotificationListener;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessListener;", "()V", "childrenLoadingCancelled", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "value", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrValue;", "suggestEnablingGdbIndexer", "valueLoadingCancelled", "Companion", "intellij.cidr.debugger"})
public final class GdbIndexNotificationListener
implements CidrDebugProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<Boolean> GDB_INDEX_NOTIFICATION_SHOWN;
    @NotNull
    private static final String GDB_INDEX_NOTIFICATION_HIDDEN;

    @Override
    public void childrenLoadingCancelled(@NotNull CidrDebugProcess process, @NotNull CidrValue value) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.suggestEnablingGdbIndexer(process);
    }

    @Override
    public void valueLoadingCancelled(@NotNull CidrDebugProcess process, @NotNull CidrValue value) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.suggestEnablingGdbIndexer(process);
    }

    private final void suggestEnablingGdbIndexer(CidrDebugProcess process) {
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        GDBDriverConfiguration gDBDriverConfiguration = debuggerDriverConfiguration instanceof GDBDriverConfiguration ? (GDBDriverConfiguration)debuggerDriverConfiguration : null;
        if (gDBDriverConfiguration == null) {
            return;
        }
        GDBDriverConfiguration driverConfig = gDBDriverConfiguration;
        if (!(process instanceof CidrLocalDebugProcess) || driverConfig.getHostMachine().isRemote()) {
            return;
        }
        if (!SystemInfo.isLinux) {
            return;
        }
        if (driverConfig.isPrepareGdbIndexes()) {
            return;
        }
        String string = driverConfig.getGdbIndexAdvancedSettingsText();
        if (string == null) {
            return;
        }
        String gdbIndexesSettingsText = string;
        if (PropertiesComponent.getInstance().getBoolean(GDB_INDEX_NOTIFICATION_HIDDEN)) {
            return;
        }
        Object object = GDB_INDEX_NOTIFICATION_SHOWN.get((UserDataHolder)process, (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        if (((Boolean)object).booleanValue()) {
            return;
        }
        process.putUserData(GDB_INDEX_NOTIFICATION_SHOWN, true);
        NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
        Object[] objectArray = new Object[]{ShowSettingsUtil.getSettingsMenuName()};
        String string2 = CidrDebuggerBundle.message("debug.gdb.index.notification.content", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Notification notification = notificationGroup.createNotification(string2, NotificationType.INFORMATION);
        notification.addAction((AnAction)NotificationAction.createSimple((String)CidrDebuggerBundle.message("debug.gdb.index.notification.configure", new Object[0]), () -> GdbIndexNotificationListener.suggestEnablingGdbIndexer$lambda$0(process, gdbIndexesSettingsText)));
        notification.addAction((AnAction)NotificationAction.createSimple((String)CidrDebuggerBundle.message("debug.gdb.index.notification.hide", new Object[0]), GdbIndexNotificationListener::suggestEnablingGdbIndexer$lambda$1));
        notification.notify(process.getProject());
    }

    private static final void suggestEnablingGdbIndexer$lambda$0(CidrDebugProcess $process, String $gdbIndexesSettingsText) {
        Intrinsics.checkNotNullParameter((Object)$process, (String)"$process");
        Intrinsics.checkNotNullParameter((Object)$gdbIndexesSettingsText, (String)"$gdbIndexesSettingsText");
        ShowSettingsUtilImpl.Companion.showSettingsDialog(((CidrLocalDebugProcess)$process).getProject(), "advanced.settings", $gdbIndexesSettingsText);
    }

    private static final void suggestEnablingGdbIndexer$lambda$1() {
        PropertiesComponent.getInstance().setValue(GDB_INDEX_NOTIFICATION_HIDDEN, true, false);
    }

    static {
        Key key = Key.create((String)(GdbIndexNotificationListener.class.getSimpleName() + ".notification.shown"));
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        GDB_INDEX_NOTIFICATION_SHOWN = key;
        GDB_INDEX_NOTIFICATION_HIDDEN = GdbIndexNotificationListener.class.getSimpleName() + ".notification.hidden";
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GdbIndexNotificationListener$Companion;", "", "()V", "GDB_INDEX_NOTIFICATION_HIDDEN", "", "GDB_INDEX_NOTIFICATION_SHOWN", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

