/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.util.ByteList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0005\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J#\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/LLMemoryHunk;", "", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "bytes", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;[B)V", "", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/List;)V", "getBytes", "()Ljava/util/List;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.debugger.backend"})
public final class LLMemoryHunk {
    @NotNull
    private final AddressRange range;
    @NotNull
    private final List<Byte> bytes;

    public LLMemoryHunk(@NotNull AddressRange range, @NotNull List<Byte> bytes) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(bytes, (String)"bytes");
        this.range = range;
        this.bytes = bytes;
        if (!(this.range.getSize() == (long)this.bytes.size())) {
            boolean bl = false;
            String string = "Range " + this.range + " of size " + this.range.getSize() + "; bytes.length=" + this.bytes.size();
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final AddressRange getRange() {
        return this.range;
    }

    @NotNull
    public final List<Byte> getBytes() {
        return this.bytes;
    }

    public LLMemoryHunk(@NotNull AddressRange range, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this(range, (List)((Object)new ByteList(bytes)));
    }

    @NotNull
    public final AddressRange component1() {
        return this.range;
    }

    @NotNull
    public final List<Byte> component2() {
        return this.bytes;
    }

    @NotNull
    public final LLMemoryHunk copy(@NotNull AddressRange range, @NotNull List<Byte> bytes) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter(bytes, (String)"bytes");
        return new LLMemoryHunk(range, bytes);
    }

    public static /* synthetic */ LLMemoryHunk copy$default(LLMemoryHunk lLMemoryHunk, AddressRange addressRange, List list, int n, Object object) {
        if ((n & 1) != 0) {
            addressRange = lLMemoryHunk.range;
        }
        if ((n & 2) != 0) {
            list = lLMemoryHunk.bytes;
        }
        return lLMemoryHunk.copy(addressRange, list);
    }

    @NotNull
    public String toString() {
        return "LLMemoryHunk(range=" + this.range + ", bytes=" + this.bytes + ")";
    }

    public int hashCode() {
        int result2 = this.range.hashCode();
        result2 = result2 * 31 + ((Object)this.bytes).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LLMemoryHunk)) {
            return false;
        }
        LLMemoryHunk lLMemoryHunk = (LLMemoryHunk)other;
        if (!Intrinsics.areEqual((Object)this.range, (Object)lLMemoryHunk.range)) {
            return false;
        }
        return Intrinsics.areEqual(this.bytes, lLMemoryHunk.bytes);
    }
}

