/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationExpiredException;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EvaluationContext
implements Expirable {
    private static final Key<Map<String, UserDataHolder>> TYPES_CACHE_KEY = Key.create((String)"TYPES_CACHE_KEY");
    @NotNull
    private final UserDataHolderEx myCacheHolder;
    @NotNull
    protected final LLThread myThread;
    @NotNull
    protected final LLFrame myFrame;
    @NotNull
    private final DebuggerDriver myDriver;
    @Nullable
    private final Expirable myExpirable;

    public EvaluationContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull UserDataHolderEx cacheHolder) {
        if (driver == null) {
            EvaluationContext.$$$reportNull$$$0(0);
        }
        if (thread == null) {
            EvaluationContext.$$$reportNull$$$0(1);
        }
        if (frame == null) {
            EvaluationContext.$$$reportNull$$$0(2);
        }
        if (cacheHolder == null) {
            EvaluationContext.$$$reportNull$$$0(3);
        }
        this.myThread = thread;
        this.myFrame = frame;
        this.myCacheHolder = cacheHolder;
        this.myDriver = driver;
        this.myExpirable = expirable;
    }

    public boolean isExpired() {
        return this.myExpirable != null && this.myExpirable.isExpired();
    }

    public void checkExpiration() {
        if (this.myExpirable != null && this.isExpired()) {
            throw new EvaluationExpiredException(this, this.myExpirable);
        }
    }

    @NotNull
    public LLValue evaluate(@NlsSafe @NotNull String expression) throws ExecutionException, DebuggerCommandException {
        if (expression == null) {
            EvaluationContext.$$$reportNull$$$0(4);
        }
        LLValue lLValue = this.evaluate(expression, null);
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(5);
        }
        return lLValue;
    }

    @NotNull
    public LLValueData evaluateData(@NlsSafe @NotNull String expression) throws ExecutionException, DebuggerCommandException {
        if (expression == null) {
            EvaluationContext.$$$reportNull$$$0(6);
        }
        LLValueData lLValueData = this.getData(this.evaluate(expression, null));
        if (lLValueData == null) {
            EvaluationContext.$$$reportNull$$$0(7);
        }
        return lLValueData;
    }

    @NotNull
    public LLValue evaluate(@NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        if (expression == null) {
            EvaluationContext.$$$reportNull$$$0(8);
        }
        this.checkExpiration();
        LLValue lLValue = this.myDriver.evaluate(this.myThread, this.myFrame, expression, language);
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(9);
        }
        return lLValue;
    }

    @NotNull
    public LLValueData evaluateData(@NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws ExecutionException, DebuggerCommandException {
        if (expression == null) {
            EvaluationContext.$$$reportNull$$$0(10);
        }
        LLValueData lLValueData = this.getData(this.evaluate(expression, language));
        if (lLValueData == null) {
            EvaluationContext.$$$reportNull$$$0(11);
        }
        return lLValueData;
    }

    @NotNull
    public String castIDToNumber(@NotNull String expr, @NotNull String type) {
        if (expr == null) {
            EvaluationContext.$$$reportNull$$$0(12);
        }
        if (type == null) {
            EvaluationContext.$$$reportNull$$$0(13);
        }
        String string = EvaluationContext.cast(expr, type);
        if (string == null) {
            EvaluationContext.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String convertToLValue(@NotNull String name) {
        if (name == null) {
            EvaluationContext.$$$reportNull$$$0(15);
        }
        String string = name;
        if (string == null) {
            EvaluationContext.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public abstract String convertToRValue(@NotNull LLValueData var1, @NotNull Pair<LLValue, String> var2) throws DebuggerCommandException, ExecutionException;

    public static String cast(String expr, String type) {
        return "((" + type + ")(" + expr + "))";
    }

    @NotNull
    public LLValue messageSend(LLValueData self, String selectorAndArgs, String returnType) throws ExecutionException, DebuggerCommandException {
        LLValue lLValue = this.evaluate(EvaluationContext.messageSendExpr(self.getPointer(), selectorAndArgs, returnType), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS);
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(17);
        }
        return lLValue;
    }

    @NotNull
    public LLValue messageSend(LLValue self, String selectorAndArgs, String returnType) throws ExecutionException, DebuggerCommandException {
        LLValue lLValue = this.messageSend(this.getData(self), selectorAndArgs, returnType);
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(18);
        }
        return lLValue;
    }

    protected static String messageSendExpr(String expr, String selectorAndArgs, String returnType) {
        return EvaluationContext.cast("[" + EvaluationContext.cast(expr, "id") + " " + selectorAndArgs + "]", returnType);
    }

    @NotNull
    public LLValue messageSend(LLValue self, String selectorAndArgs) throws ExecutionException, DebuggerCommandException {
        LLValue lLValue = this.messageSend(self, selectorAndArgs, "id");
        if (lLValue == null) {
            EvaluationContext.$$$reportNull$$$0(19);
        }
        return lLValue;
    }

    @NotNull
    public LLValueData messageSendData(LLValue self, String selectorAndArgs, String returnType) throws ExecutionException, DebuggerCommandException {
        LLValueData lLValueData = this.getData(this.messageSend(self, selectorAndArgs, returnType));
        if (lLValueData == null) {
            EvaluationContext.$$$reportNull$$$0(20);
        }
        return lLValueData;
    }

    public boolean isKindOfClass(String className, LLValue value) throws ExecutionException, DebuggerCommandException {
        return this.evaluateData("(unsigned char)((Class)objc_getClass(\"" + className + "\")?" + EvaluationContext.cast("[" + EvaluationContext.cast(this.getData(value).getPointer(), "id") + " isKindOfClass:(Class)objc_lookUpClass(\"" + className + "\")]", "unsigned char") + ":0)", DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS).isTrue();
    }

    @NotNull
    public String stringFromNSString(LLValue nsstring) throws ExecutionException, DebuggerCommandException {
        String string = this.stringFromNSString(this.getData(nsstring).getPointer());
        if (string == null) {
            EvaluationContext.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public String stringFromNSString(String expr) throws ExecutionException, DebuggerCommandException {
        String string = StringUtil.unquoteString((String)this.evaluateData(EvaluationContext.stringFromNSStringExpr(expr), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS).getPresentableValue());
        if (string == null) {
            EvaluationContext.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static String stringFromNSStringExpr(String expr) {
        String lengthExpr = EvaluationContext.messageSendExpr(expr, "length", "int");
        String substringExpr = EvaluationContext.messageSendExpr(expr, "substringToIndex:" + String.format("(((%s) > %d) ? %d : %s)", lengthExpr, 256, 256, lengthExpr), "id");
        return EvaluationContext.messageSendExpr(substringExpr, "UTF8String", "char *");
    }

    @NotNull
    public LLValueData getData(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            EvaluationContext.$$$reportNull$$$0(23);
        }
        this.checkExpiration();
        LLValueData lLValueData = this.myDriver.getData(var);
        if (lLValueData == null) {
            EvaluationContext.$$$reportNull$$$0(24);
        }
        return lLValueData;
    }

    @Nullable
    public Integer getChildrenCount(@NotNull LLValue var) throws ExecutionException, DebuggerCommandException {
        if (var == null) {
            EvaluationContext.$$$reportNull$$$0(25);
        }
        this.checkExpiration();
        return this.myDriver.getChildrenCount(var);
    }

    @NotNull
    public DebuggerDriver.ResultList<LLValue> getVariableChildren(LLValue var, int offset, int size) throws ExecutionException, DebuggerCommandException {
        this.checkExpiration();
        DebuggerDriver.ResultList<LLValue> resultList = this.myDriver.getVariableChildren(var, offset, size);
        if (resultList == null) {
            EvaluationContext.$$$reportNull$$$0(26);
        }
        return resultList;
    }

    @Nullable
    public <T> T getCachedTypeInfo(@NotNull String type, @NotNull Key<T> key) {
        UserDataHolder holder;
        if (type == null) {
            EvaluationContext.$$$reportNull$$$0(27);
        }
        if (key == null) {
            EvaluationContext.$$$reportNull$$$0(28);
        }
        return (T)((holder = this.getTypeInfoHolder(type)) == null ? null : holder.getUserData(key));
    }

    public <T> void putCachedTypeInfo(@NotNull String type, @NotNull Key<T> key, @Nullable T value) {
        UserDataHolder holder;
        if (type == null) {
            EvaluationContext.$$$reportNull$$$0(29);
        }
        if (key == null) {
            EvaluationContext.$$$reportNull$$$0(30);
        }
        if ((holder = this.getTypeInfoHolder(type)) != null) {
            holder.putUserData(key, value);
        }
    }

    @Nullable
    private UserDataHolder getTypeInfoHolder(@NotNull String type) {
        if (type == null) {
            EvaluationContext.$$$reportNull$$$0(31);
        }
        if (type.equals("id")) {
            return null;
        }
        Map map = (Map)this.myCacheHolder.getUserData(TYPES_CACHE_KEY);
        if (map == null) {
            map = (Map)this.myCacheHolder.putUserDataIfAbsent(TYPES_CACHE_KEY, (Object)FactoryMap.create(key -> new UserDataHolderBase()));
        }
        return (UserDataHolder)map.get(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9, 11, 14, 16, 17, 18, 19, 20, 21, 22, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheHolder";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/EvaluationContext";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 13: 
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/EvaluationContext";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluate";
                break;
            }
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateData";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "castIDToNumber";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "convertToLValue";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "messageSend";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "messageSendData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "stringFromNSString";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getData";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                break;
            }
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "evaluateData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "castIDToNumber";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "convertToLValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenCount";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getCachedTypeInfo";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "putCachedTypeInfo";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getTypeInfoHolder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9, 11, 14, 16, 17, 18, 19, 20, 21, 22, 24, 26 -> new IllegalStateException(string);
        };
    }
}

