/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeValueNodeInplaceEditor;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\u0005R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/SetArraySizeInplaceEditor;", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreeValueNodeInplaceEditor;", "valueNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "nodeName", "", "callback", "Lkotlin/Function1;", "", "(Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "doOKAction", "show", "initialValue", "intellij.cidr.debugger"})
final class SetArraySizeInplaceEditor
extends XDebuggerTreeValueNodeInplaceEditor {
    @NotNull
    private final Function1<String, Unit> callback;

    public SetArraySizeInplaceEditor(@NotNull XValueNodeImpl valueNode, @NotNull String nodeName, @NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)valueNode, (String)"valueNode");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        super("setArraySize", valueNode, nodeName);
        this.callback = callback;
    }

    public final void show(@Nullable String initialValue) {
        this.myExpressionEditor.setExpression((XExpression)XExpressionImpl.fromText((String)initialValue));
        this.myExpressionEditor.selectAll();
        this.show();
    }

    public void doOKAction() {
        String string = this.getExpression().getExpression();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExpression(...)");
        String size = string;
        if (!StringsKt.isBlank((CharSequence)size)) {
            this.callback.invoke((Object)size);
        } else {
            String string2 = CidrDebuggerBundle.message("debugger.variables.viewAsArray.enterSize.error", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String errorMessage = string2;
            if (this.getEditor() != null) {
                HintManager.getInstance().showErrorHint(this.getEditor(), errorMessage);
            } else {
                Messages.showErrorDialog((Component)((Component)this.myTree), (String)errorMessage);
            }
        }
        super.doOKAction();
    }
}

