/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.jetbrains.cidr.execution.debugger.CidrDebugSessionEventType;
import com.jetbrains.cidr.execution.debugger.CidrTimelineEvent;
import com.jetbrains.cidr.execution.debugger.TimelineElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u00103\u001a\u0002022\u0006\u00104\u001a\u00020\u0013H\u0002J\u0014\u00105\u001a\u0002022\f\u00106\u001a\b\u0012\u0004\u0012\u00020201J\u0006\u00107\u001a\u000202J\u000e\u00108\u001a\u0002022\u0006\u00104\u001a\u00020\u0013J\u001f\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\n2\n\b\u0002\u0010;\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020\u0015H\u0007J\u0010\u0010>\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u0019H\u0002J\u0010\u0010@\u001a\u00020\u00192\u0006\u0010?\u001a\u00020\u0019H\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0004j\b\u0012\u0004\u0012\u00020\n`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010 \u001a\u001e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\n0!j\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\n`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u001c\u0010(\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u001b\"\u0004\b/\u0010\u001dR*\u00100\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u000202010\u0004j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020201`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "", "()V", "debugSessionEvents", "Ljava/util/ArrayList;", "Lcom/jetbrains/cidr/execution/debugger/CidrTimelineEvent$DebugSessionEvent;", "Lkotlin/collections/ArrayList;", "getDebugSessionEvents", "()Ljava/util/ArrayList;", "elements", "Lcom/jetbrains/cidr/execution/debugger/TimelineElement;", "getElements", "fifoReqQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "firstDroppedEventTime", "Ljava/util/concurrent/atomic/AtomicLong;", "getFirstDroppedEventTime", "()Ljava/util/concurrent/atomic/AtomicLong;", "incomingEvents", "Lcom/jetbrains/cidr/execution/debugger/CidrTimelineEvent;", "isStopped", "", "lastDroppedEventTime", "getLastDroppedEventTime", "maxTime", "", "getMaxTime", "()J", "setMaxTime", "(J)V", "processIncomingQueue", "Ljava/util/concurrent/atomic/AtomicBoolean;", "runningRequests", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "secondsCount", "", "getSecondsCount", "()I", "selectedElement", "getSelectedElement", "()Lcom/jetbrains/cidr/execution/debugger/TimelineElement;", "setSelectedElement", "(Lcom/jetbrains/cidr/execution/debugger/TimelineElement;)V", "startTime", "getStartTime", "setStartTime", "updateListeners", "Lkotlin/Function0;", "", "addPlaceholderIfNeeded", "event", "addUpdateListener", "listener", "clear", "enqueue", "finishTimeOrNow", "req", "now", "(Lcom/jetbrains/cidr/execution/debugger/TimelineElement;Ljava/lang/Long;)J", "processIncomingEvents", "secondEnd", "time", "secondStart", "intellij.cidr.debugger"})
public final class TimelineModel {
    @NotNull
    private final ArrayBlockingQueue<CidrTimelineEvent> incomingEvents = new ArrayBlockingQueue(1024);
    @NotNull
    private final ArrayList<CidrTimelineEvent.DebugSessionEvent> debugSessionEvents = new ArrayList();
    @NotNull
    private final ArrayList<TimelineElement> elements = new ArrayList();
    @NotNull
    private final HashMap<String, TimelineElement> runningRequests = new HashMap();
    private long startTime;
    private long maxTime;
    @NotNull
    private final AtomicLong firstDroppedEventTime = new AtomicLong(0L);
    @NotNull
    private final AtomicLong lastDroppedEventTime = new AtomicLong(0L);
    @NotNull
    private final ArrayList<Function0<Unit>> updateListeners = new ArrayList();
    @NotNull
    private final AtomicBoolean processIncomingQueue = new AtomicBoolean(false);
    @NotNull
    private final ArrayBlockingQueue<TimelineElement> fifoReqQueue = new ArrayBlockingQueue(1024);
    @Nullable
    private TimelineElement selectedElement;
    private boolean isStopped;

    @NotNull
    public final ArrayList<CidrTimelineEvent.DebugSessionEvent> getDebugSessionEvents() {
        return this.debugSessionEvents;
    }

    @NotNull
    public final ArrayList<TimelineElement> getElements() {
        return this.elements;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final void setStartTime(long l) {
        this.startTime = l;
    }

    public final long getMaxTime() {
        return this.maxTime;
    }

    public final void setMaxTime(long l) {
        this.maxTime = l;
    }

    @NotNull
    public final AtomicLong getFirstDroppedEventTime() {
        return this.firstDroppedEventTime;
    }

    @NotNull
    public final AtomicLong getLastDroppedEventTime() {
        return this.lastDroppedEventTime;
    }

    @Nullable
    public final TimelineElement getSelectedElement() {
        return this.selectedElement;
    }

    public final void setSelectedElement(@Nullable TimelineElement timelineElement) {
        this.selectedElement = timelineElement;
    }

    public final void clear() {
        this.debugSessionEvents.clear();
        this.elements.clear();
        this.firstDroppedEventTime.set(0L);
        this.lastDroppedEventTime.set(0L);
        this.isStopped = false;
        this.selectedElement = null;
        this.startTime = 0L;
        this.maxTime = 0L;
        this.fifoReqQueue.clear();
    }

    public final long finishTimeOrNow(@NotNull TimelineElement req, @Nullable Long now) {
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Long reqFinishTime = req.getFinishTime();
        if (reqFinishTime != null) {
            return reqFinishTime;
        }
        if (this.isStopped && this.maxTime != 0L) {
            return this.maxTime;
        }
        Long l = now;
        return l != null ? l : System.currentTimeMillis();
    }

    public static /* synthetic */ long finishTimeOrNow$default(TimelineModel timelineModel, TimelineElement timelineElement, Long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = null;
        }
        return timelineModel.finishTimeOrNow(timelineElement, l);
    }

    public final void addUpdateListener(@NotNull Function0<Unit> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.updateListeners.add(listener);
    }

    public final void enqueue(@NotNull CidrTimelineEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.incomingEvents.offer(event)) {
            this.firstDroppedEventTime.compareAndSet(0L, event.getTime());
            this.lastDroppedEventTime.set(event.getTime());
        }
        if (this.processIncomingQueue.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> TimelineModel.enqueue$lambda$0(this));
        }
    }

    private final long secondStart(long time) {
        return time / (long)1000 * (long)1000;
    }

    private final long secondEnd(long time) {
        return this.secondStart(time + (long)1000);
    }

    @RequiresEdt
    public final boolean processIncomingEvents() {
        CidrTimelineEvent event;
        boolean updated = false;
        while ((event = this.incomingEvents.poll()) != null) {
            TimelineElement request;
            TimelineElement element;
            if (event instanceof CidrTimelineEvent.DebugSessionEvent) {
                if (((CidrTimelineEvent.DebugSessionEvent)event).getType() == CidrDebugSessionEventType.FIRST_SESSION_STARTED) {
                    this.clear();
                }
                if (((CidrTimelineEvent.DebugSessionEvent)event).getType() == CidrDebugSessionEventType.LAST_SESSION_STOPPED) {
                    this.isStopped = true;
                }
                this.debugSessionEvents.add((CidrTimelineEvent.DebugSessionEvent)event);
            }
            if (this.startTime == 0L) {
                this.startTime = this.secondStart(event.getTime());
                updated = true;
            }
            if (!(event instanceof CidrTimelineEvent.TimeTick && this.runningRequests.isEmpty() && this.fifoReqQueue.isEmpty())) {
                this.maxTime = this.secondEnd(event.getTime());
                updated = true;
            }
            if (event instanceof CidrTimelineEvent.Request) {
                if (this.runningRequests.isEmpty()) {
                    this.addPlaceholderIfNeeded(event);
                }
                element = new TimelineElement(event.getTime(), ((CidrTimelineEvent.Request)event).getText(), ((CidrTimelineEvent.Request)event).getTitle(), null, false, 24, null);
                this.elements.add(element);
                ((Map)this.runningRequests).put(((CidrTimelineEvent.Request)event).getId(), element);
                continue;
            }
            if (event instanceof CidrTimelineEvent.Response) {
                if (((CidrTimelineEvent.Response)event).getId() != null) {
                    request = this.runningRequests.remove(((CidrTimelineEvent.Response)event).getId());
                    if (request != null) {
                        request.finish(event.getTime(), ((CidrTimelineEvent.Response)event).getText());
                        continue;
                    }
                    TimelineElement timelineElement = (TimelineElement)CollectionsKt.lastOrNull((List)this.elements);
                    if (timelineElement != null) {
                        timelineElement.addMessage(event.getTime(), ((CidrTimelineEvent.Response)event).getText());
                    }
                    continue;
                }
                TimelineElement timelineElement = (TimelineElement)CollectionsKt.lastOrNull((List)this.elements);
                if (timelineElement != null) {
                    timelineElement.addMessage(event.getTime(), ((CidrTimelineEvent.Response)event).getText());
                }
                continue;
            }
            if (event instanceof CidrTimelineEvent.FifoRequest) {
                if (this.fifoReqQueue.isEmpty()) {
                    this.addPlaceholderIfNeeded(event);
                }
                element = new TimelineElement(event.getTime(), ((CidrTimelineEvent.FifoRequest)event).getText(), ((CidrTimelineEvent.FifoRequest)event).getTitle(), null, false, 24, null);
                this.elements.add(element);
                if (this.fifoReqQueue.offer(element)) continue;
                this.firstDroppedEventTime.compareAndSet(0L, event.getTime());
                this.lastDroppedEventTime.set(event.getTime());
                continue;
            }
            if (!(event instanceof CidrTimelineEvent.FifoResponse)) continue;
            request = this.fifoReqQueue.poll();
            if (request != null) {
                request.finish(event.getTime(), ((CidrTimelineEvent.FifoResponse)event).getText());
                continue;
            }
            TimelineElement timelineElement = (TimelineElement)CollectionsKt.lastOrNull((List)this.elements);
            if (timelineElement == null) continue;
            timelineElement.addMessage(event.getTime(), ((CidrTimelineEvent.FifoResponse)event).getText());
        }
        return updated;
    }

    private final void addPlaceholderIfNeeded(CidrTimelineEvent event) {
        Long lastRequestFinishTime;
        TimelineElement timelineElement = (TimelineElement)CollectionsKt.lastOrNull((List)this.elements);
        Long l = lastRequestFinishTime = timelineElement != null ? timelineElement.getFinishTime() : null;
        if (lastRequestFinishTime != null) {
            long lastReqSecondEnd = this.secondEnd(lastRequestFinishTime);
            long newReqSecondStart = this.secondStart(event.getTime());
            long durationSeconds = (newReqSecondStart - lastReqSecondEnd) / (long)1000;
            if (durationSeconds >= 2L) {
                this.elements.add(new TimelineElement(lastReqSecondEnd, "Nothing happens for " + durationSeconds + " seconds", "", newReqSecondStart, true));
            }
        }
    }

    public final int getSecondsCount() {
        long durationMillis = this.maxTime - this.startTime;
        if (durationMillis <= 0L) {
            return 0;
        }
        return (int)Math.ceil((double)durationMillis / 1000.0) + 1;
    }

    private static final void enqueue$lambda$0(TimelineModel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.processIncomingQueue.set(false);
        if (!this$0.processIncomingEvents()) {
            return;
        }
        for (Function0<Unit> listener : this$0.updateListeners) {
            listener.invoke();
        }
    }
}

