/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.debugger.CidrDebugLogConsole;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerDevToolWindowKt;
import com.jetbrains.cidr.execution.debugger.TimelineElement;
import com.jetbrains.cidr.execution.debugger.TimelineModel;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/TimelineElementDetailsConsole;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/execution/debugger/TimelineModel;)V", "getModel", "()Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "showDetails", "", "element", "Lcom/jetbrains/cidr/execution/debugger/TimelineElement;", "intellij.cidr.debugger"})
public final class TimelineElementDetailsConsole
extends ConsoleViewImpl {
    @NotNull
    private final TimelineModel model;

    public TimelineElementDetailsConsole(@NotNull Project project, @NotNull TimelineModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(project, true);
        this.model = model;
    }

    @NotNull
    public final TimelineModel getModel() {
        return this.model;
    }

    public final void showDetails(@NotNull TimelineElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.clear();
        long finishTime = TimelineModel.finishTimeOrNow$default(this.model, element, null, 2, null);
        Duration duration = Duration.ofMillis(finishTime - element.getStartTime());
        this.print(duration.toSeconds() + "s" + duration.toMillisPart() + "ms\n", ConsoleViewContentType.LOG_DEBUG_OUTPUT);
        for (Pair<String, Long> pair : element.getMessages()) {
            String message = (String)pair.component1();
            long time = ((Number)pair.component2()).longValue();
            String formattedTime = CidrDebuggerDevToolWindowKt.access$formatTime(CidrDebugLogConsole.Companion.getLOG_TIME_FORMAT(), time);
            this.print("[" + formattedTime + "] " + message + "\n", ConsoleViewContentType.NORMAL_OUTPUT);
        }
        this.scrollTo(0);
        this.setVisible(true);
        this.repaint();
    }
}

